/* Generated by GOB (v2.0.20)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 2 "loqui-account-dialog.gob"

/*
 * Loqui -- Chat/IM client for Gtk2 <http://launchpad.net/loqui/>
 * Copyright (C) 2002-2003 Yoichi Imai <sunnyone41@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#line 28 "loqui-account-dialog.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 20

#define selfp (self->_priv)

#include "loqui-account-dialog.h"

#include "loqui-account-dialog-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "loqui-account-dialog.gob"

/* #include "config.h" */

#include <glib/gi18n.h>
#include "gtkutils.h"

#include <libloqui/loqui-account-manager.h>
#include <libloqui/loqui-utils.h>
#include <loqui_profile_account.h>
#include <loqui_profile_account_irc.h>
#include <loqui_codeconv.h>

#include "loqui-protocol-selection-dialog.h"
#include <string.h>

enum {
	CODECONV_COLUMN_TITLE,
	CODECONV_COLUMN_NAME,
	CODECONV_COLUMN_NUMBER,
};

#line 69 "loqui-account-dialog.c"
/* self casting macros */
#define SELF(x) LOQUI_ACCOUNT_DIALOG(x)
#define SELF_CONST(x) LOQUI_ACCOUNT_DIALOG_CONST(x)
#define IS_SELF(x) LOQUI_IS_ACCOUNT_DIALOG(x)
#define TYPE_SELF LOQUI_TYPE_ACCOUNT_DIALOG
#define SELF_CLASS(x) LOQUI_ACCOUNT_DIALOG_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_ACCOUNT_DIALOG_GET_CLASS(x)

/* self typedefs */
typedef LoquiAccountDialog Self;
typedef LoquiAccountDialogClass SelfClass;

/* here are local prototypes */
static void loqui_account_dialog_init (LoquiAccountDialog * o) G_GNUC_UNUSED;
static void loqui_account_dialog_class_init (LoquiAccountDialogClass * c) G_GNUC_UNUSED;
#line 81 "loqui-account-dialog.gob"
static void loqui_account_dialog_set_codeconv_mode (LoquiAccountDialog * self, LoquiCodeConvMode mode) G_GNUC_UNUSED;
#line 88 "loqui-account-dialog.c"
#line 99 "loqui-account-dialog.gob"
static LoquiCodeConvMode loqui_account_dialog_get_codeconv_mode (LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 91 "loqui-account-dialog.c"
#line 113 "loqui-account-dialog.gob"
static void loqui_account_dialog_response_cb (GtkWidget * widget, gint response, gpointer data) G_GNUC_UNUSED;
#line 94 "loqui-account-dialog.c"
#line 128 "loqui-account-dialog.gob"
static void loqui_account_dialog_radio_toggled_cb (GtkWidget * radio, LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 97 "loqui-account-dialog.c"
#line 133 "loqui-account-dialog.gob"
static void loqui_account_dialog_save_irc (LoquiAccountDialog * self, LoquiProfileAccountIRC * profile_irc) G_GNUC_UNUSED;
#line 100 "loqui-account-dialog.c"
#line 143 "loqui-account-dialog.gob"
static void loqui_account_dialog_save_general (LoquiAccountDialog * self, LoquiProfileAccount * profile) G_GNUC_UNUSED;
#line 103 "loqui-account-dialog.c"
#line 172 "loqui-account-dialog.gob"
static void loqui_account_dialog_save (LoquiAccountDialog * self, LoquiProfileAccount * profile) G_GNUC_UNUSED;
#line 106 "loqui-account-dialog.c"
#line 181 "loqui-account-dialog.gob"
static void loqui_account_dialog_update_codeconv_sensitivity (LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 109 "loqui-account-dialog.c"
#line 191 "loqui-account-dialog.gob"
static void loqui_account_dialog_load_general (LoquiAccountDialog * self, LoquiProfileAccount * profile) G_GNUC_UNUSED;
#line 112 "loqui-account-dialog.c"
#line 241 "loqui-account-dialog.gob"
static void loqui_account_dialog_load_irc (LoquiAccountDialog * self, LoquiProfileAccountIRC * profile_irc) G_GNUC_UNUSED;
#line 115 "loqui-account-dialog.c"
#line 253 "loqui-account-dialog.gob"
static void loqui_account_dialog_load (LoquiAccountDialog * self, LoquiProfileAccount * profile) G_GNUC_UNUSED;
#line 118 "loqui-account-dialog.c"
#line 262 "loqui-account-dialog.gob"
static void loqui_account_dialog_append_profile_page (LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 121 "loqui-account-dialog.c"
#line 302 "loqui-account-dialog.gob"
static void loqui_account_dialog_append_irc_page (LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 124 "loqui-account-dialog.c"
#line 315 "loqui-account-dialog.gob"
static void loqui_account_dialog_append_code_page (LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 127 "loqui-account-dialog.c"
#line 383 "loqui-account-dialog.gob"
static void loqui_account_dialog_append_nick_page (LoquiAccountDialog * self) G_GNUC_UNUSED;
#line 130 "loqui-account-dialog.c"

/* pointer to the class of our parent */
static GtkDialogClass *parent_class = NULL;

/* Short form macros */
#define self_set_codeconv_mode loqui_account_dialog_set_codeconv_mode
#define self_get_codeconv_mode loqui_account_dialog_get_codeconv_mode
#define self_response_cb loqui_account_dialog_response_cb
#define self_radio_toggled_cb loqui_account_dialog_radio_toggled_cb
#define self_save_irc loqui_account_dialog_save_irc
#define self_save_general loqui_account_dialog_save_general
#define self_save loqui_account_dialog_save
#define self_update_codeconv_sensitivity loqui_account_dialog_update_codeconv_sensitivity
#define self_load_general loqui_account_dialog_load_general
#define self_load_irc loqui_account_dialog_load_irc
#define self_load loqui_account_dialog_load
#define self_append_profile_page loqui_account_dialog_append_profile_page
#define self_append_irc_page loqui_account_dialog_append_irc_page
#define self_append_code_page loqui_account_dialog_append_code_page
#define self_append_nick_page loqui_account_dialog_append_nick_page
#define self_new loqui_account_dialog_new
#define self_open_add_dialog loqui_account_dialog_open_add_dialog
#define self_open_configure_dialog loqui_account_dialog_open_configure_dialog
#define self_open_remove_dialog loqui_account_dialog_open_remove_dialog
GType
loqui_account_dialog_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiAccountDialogClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_account_dialog_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiAccountDialog),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_account_dialog_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DIALOG, "LoquiAccountDialog", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiAccountDialog *)g_object_new(loqui_account_dialog_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiAccountDialog * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiAccountDialog *
GET_NEW_VARG (const char *first, ...)
{
	LoquiAccountDialog *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiAccountDialog *)g_object_new_valist (loqui_account_dialog_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::finalize"
	LoquiAccountDialog *self G_GNUC_UNUSED = LOQUI_ACCOUNT_DIALOG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
loqui_account_dialog_init (LoquiAccountDialog * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LOQUI_TYPE_ACCOUNT_DIALOG,LoquiAccountDialogPrivate);
}
#undef __GOB_FUNCTION__
static void 
loqui_account_dialog_class_init (LoquiAccountDialogClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LoquiAccountDialogPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DIALOG);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 81 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_set_codeconv_mode (LoquiAccountDialog * self, LoquiCodeConvMode mode)
{
#line 236 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::set_codeconv_mode"
#line 81 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 81 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 242 "loqui-account-dialog.c"
{
#line 82 "loqui-account-dialog.gob"
	
        	switch (mode) {
        	case LOQUI_CODECONV_MODE_AUTOMATIC:
        		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->radio_automatic), TRUE);
        		break;
        	case LOQUI_CODECONV_MODE_NO_CONV:
        		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->radio_noconv), TRUE);
        		break;
        	case LOQUI_CODECONV_MODE_BY_TABLE:
        		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->radio_bytable), TRUE);
        		break;
        	case LOQUI_CODECONV_MODE_CODESET:
        		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->radio_codeset), TRUE);
        		break;
        	}
        }}
#line 261 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 99 "loqui-account-dialog.gob"
static LoquiCodeConvMode 
loqui_account_dialog_get_codeconv_mode (LoquiAccountDialog * self)
{
#line 268 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::get_codeconv_mode"
#line 99 "loqui-account-dialog.gob"
	g_return_val_if_fail (self != NULL, (LoquiCodeConvMode )0);
#line 99 "loqui-account-dialog.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self), (LoquiCodeConvMode )0);
#line 274 "loqui-account-dialog.c"
{
#line 100 "loqui-account-dialog.gob"
	
        	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->radio_automatic)))
        		return LOQUI_CODECONV_MODE_AUTOMATIC;
        	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->radio_noconv)))
        		return LOQUI_CODECONV_MODE_NO_CONV;
        	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->radio_bytable)))
        		return LOQUI_CODECONV_MODE_BY_TABLE;
        	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->radio_codeset)))
        		return LOQUI_CODECONV_MODE_CODESET;
        
        	return 0;
        }}
#line 289 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 113 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_response_cb (GtkWidget * widget, gint response, gpointer data)
{
#line 296 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::response_cb"
{
#line 114 "loqui-account-dialog.gob"
	
		Self *self;

        	self = SELF(data);
        
        	switch(response) {
        	case GTK_RESPONSE_OK:
			self_save(self, selfp->profile);
        		break;
        	default:
        		break;
        	}
        }}
#line 313 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 128 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_radio_toggled_cb (GtkWidget * radio, LoquiAccountDialog * self)
{
#line 320 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::radio_toggled_cb"
{
#line 129 "loqui-account-dialog.gob"
	
        	self_update_codeconv_sensitivity(self);
        }}
#line 327 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 133 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_save_irc (LoquiAccountDialog * self, LoquiProfileAccountIRC * profile_irc)
{
#line 334 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::save_irc"
#line 133 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 133 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 340 "loqui-account-dialog.c"
{
#line 134 "loqui-account-dialog.gob"
	
       		g_object_set(profile_irc,
			     "realname", gtk_entry_get_text(GTK_ENTRY(selfp->entry_realname)),
			     "userinfo", gtk_entry_get_text(GTK_ENTRY(selfp->entry_userinfo)),
			     "autojoin", gtk_entry_get_text(GTK_ENTRY(selfp->entry_autojoin)),
			     "quit_message", gtk_entry_get_text(GTK_ENTRY(selfp->entry_quit_message)),
			     NULL);
	}}
#line 351 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 143 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_save_general (LoquiAccountDialog * self, LoquiProfileAccount * profile)
{
#line 358 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::save_general"
#line 143 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 143 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 364 "loqui-account-dialog.c"
{
#line 144 "loqui-account-dialog.gob"
	
        	GList *nick_list;
        	GtkTreeIter iter;
        	const gchar *codeconv_item_name;

		if (gtk_combo_box_get_active_iter(GTK_COMBO_BOX(selfp->combobox_table), &iter))
			gtk_tree_model_get(selfp->model_codeconv_table, &iter, CODECONV_COLUMN_NAME, &codeconv_item_name, -1);
		else
			codeconv_item_name = NULL;

		g_object_set(profile,
			     "use", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->check_use)),
			     "name", gtk_entry_get_text(GTK_ENTRY(selfp->entry_name)),
			     "nick", gtk_entry_get_text(GTK_ENTRY(selfp->entry_nick)),
			     "username", gtk_entry_get_text(GTK_ENTRY(selfp->entry_username)),
			     "password", gtk_entry_get_text(GTK_ENTRY(selfp->entry_password)),
			     "servername", gtk_entry_get_text(GTK_ENTRY(selfp->entry_servername)),
			     "port", (int) gtk_spin_button_get_value(GTK_SPIN_BUTTON(selfp->spin_port)),
			     "codeconv_mode", self_get_codeconv_mode(self),
			     "codeconv_item_name", codeconv_item_name,
			     "codeset", gtk_entry_get_text(GTK_ENTRY(selfp->entry_codeset)),
			     NULL);

		nick_list = NULL;
		gtkutils_set_string_list_from_textview(&nick_list, GTK_TEXT_VIEW(selfp->textview_nicklist));
		loqui_profile_account_set_nick_list(selfp->profile, nick_list);
	}}
#line 394 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 172 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_save (LoquiAccountDialog * self, LoquiProfileAccount * profile)
{
#line 401 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::save"
#line 172 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 172 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 407 "loqui-account-dialog.c"
{
#line 173 "loqui-account-dialog.gob"
	
		self_save_general(self, profile);
		
		if (LOQUI_IS_PROFILE_ACCOUNT_IRC(profile)) {
			self_save_irc(self, LOQUI_PROFILE_ACCOUNT_IRC(profile));
		}
	}}
#line 417 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 181 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_update_codeconv_sensitivity (LoquiAccountDialog * self)
{
#line 424 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::update_codeconv_sensitivity"
#line 181 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 181 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 430 "loqui-account-dialog.c"
{
#line 182 "loqui-account-dialog.gob"
	
        	LoquiCodeConvMode mode;
        
        	mode = self_get_codeconv_mode(self);
        
        	gtk_widget_set_sensitive(selfp->entry_codeset, (mode == LOQUI_CODECONV_MODE_CODESET));
        	gtk_widget_set_sensitive(selfp->combobox_table, (mode == LOQUI_CODECONV_MODE_BY_TABLE));
        }}
#line 441 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 191 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_load_general (LoquiAccountDialog * self, LoquiProfileAccount * profile)
{
#line 448 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::load_general"
#line 191 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 191 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 454 "loqui-account-dialog.c"
{
#line 192 "loqui-account-dialog.gob"
	
        	const gchar *name;
        	LoquiCodeConvTableItem *table;
        	gint i;
        	GtkTreeIter iter;

		gtk_entry_set_text(GTK_ENTRY(selfp->entry_name),
				   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_get_name(profile)));
        	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->check_use),
					     loqui_profile_account_get_use(profile));

                gtk_entry_set_text(GTK_ENTRY(selfp->entry_nick),
                                   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_get_nick(profile)));
                gtk_entry_set_text(GTK_ENTRY(selfp->entry_username),
                                   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_get_username(profile)));
                gtk_entry_set_text(GTK_ENTRY(selfp->entry_password),
                                   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_get_password(profile)));
                gtk_entry_set_text(GTK_ENTRY(selfp->entry_servername),
                                   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_get_servername(profile)));
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(selfp->spin_port),
                                          loqui_profile_account_get_port(profile));

		table = loqui_protocol_get_codeconv_table(loqui_profile_account_get_protocol(profile));
        	name = loqui_profile_account_get_codeconv_item_name(profile);

		gtk_list_store_clear(GTK_LIST_STORE(selfp->model_codeconv_table));
        	for (i = 0; table[i].name != NULL; i++) {
        		gtk_list_store_append(GTK_LIST_STORE(selfp->model_codeconv_table), &iter);
        		gtk_list_store_set(GTK_LIST_STORE(selfp->model_codeconv_table),
        				   &iter,
        				   CODECONV_COLUMN_TITLE, loqui_codeconv_translate(table[i].title),
        				   CODECONV_COLUMN_NAME, table[i].name,
        				   -1);
        
        		if (name != NULL && strcmp(table[i].name, name) == 0) {
        			gtk_combo_box_set_active_iter(GTK_COMBO_BOX(selfp->combobox_table), &iter);
        		}
        	}

        	self_set_codeconv_mode(self, loqui_profile_account_get_codeconv_mode(LOQUI_PROFILE_ACCOUNT(profile)));
        	self_update_codeconv_sensitivity(self);

		gtk_entry_set_text(GTK_ENTRY(selfp->entry_codeset),
				   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_get_codeset(LOQUI_PROFILE_ACCOUNT(profile))));

        	gtkutils_set_textview_from_string_list(GTK_TEXT_VIEW(selfp->textview_nicklist),
        					       loqui_profile_account_get_nick_list(profile));
	}}
#line 505 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 241 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_load_irc (LoquiAccountDialog * self, LoquiProfileAccountIRC * profile_irc)
{
#line 512 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::load_irc"
#line 241 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 241 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 518 "loqui-account-dialog.c"
{
#line 242 "loqui-account-dialog.gob"
	
        	gtk_entry_set_text(GTK_ENTRY(selfp->entry_realname),
				   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_irc_get_realname(profile_irc)));
        	gtk_entry_set_text(GTK_ENTRY(selfp->entry_userinfo),
				   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_irc_get_userinfo(profile_irc)));
        	gtk_entry_set_text(GTK_ENTRY(selfp->entry_autojoin),
				   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_irc_get_autojoin(profile_irc)));
        	gtk_entry_set_text(GTK_ENTRY(selfp->entry_quit_message),
				   LOQUI_UTILS_EMPTY_IF_NULL(loqui_profile_account_irc_get_quit_message(profile_irc)));
	}}
#line 531 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 253 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_load (LoquiAccountDialog * self, LoquiProfileAccount * profile)
{
#line 538 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::load"
#line 253 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 253 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 544 "loqui-account-dialog.c"
{
#line 254 "loqui-account-dialog.gob"
	
		self_load_general(self, profile);

		if (LOQUI_IS_PROFILE_ACCOUNT_IRC(profile)) {
			self_load_irc(self, LOQUI_PROFILE_ACCOUNT_IRC(profile));
		}
	}}
#line 554 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 262 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_append_profile_page (LoquiAccountDialog * self)
{
#line 561 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::append_profile_page"
#line 262 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 262 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 567 "loqui-account-dialog.c"
{
#line 263 "loqui-account-dialog.gob"
	
        	GtkWidget *hbox, *vbox_c;
		GtkWidget *vbox;
        	GtkWidget *frame;

        	vbox = gtk_vbox_new(FALSE, 0);

        	gtk_notebook_append_page(GTK_NOTEBOOK(selfp->notebook), vbox, gtk_label_new(_("Profile")));
        	
        	hbox = gtk_hbox_new(TRUE, 0);
        	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
        	
        	gtkutils_add_label_entry(hbox, _("Account name:"), &selfp->entry_name, NULL);
        	
        	selfp->check_use = gtk_check_button_new_with_label(_("Connect by default"));
        	gtk_box_pack_start(GTK_BOX(hbox), selfp->check_use, TRUE, TRUE, 0);
        
        	frame = gtk_frame_new(_("User"));
        	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);
        	
        	vbox_c = gtk_vbox_new(TRUE, 0);
        	gtk_container_add(GTK_CONTAINER(frame), vbox_c);
        	
        	gtkutils_add_label_entry(vbox_c, _("Nickname:"), &selfp->entry_nick, NULL);
        	gtkutils_add_label_entry(vbox_c, _("User name:"), &selfp->entry_username, NULL);
        	gtkutils_add_label_entry(vbox_c, _("Password:"), &selfp->entry_password, NULL);
        	gtk_entry_set_visibility(GTK_ENTRY(selfp->entry_password), FALSE);
        
        	frame = gtk_frame_new(_("Server"));
        	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);
        	
        	vbox_c = gtk_vbox_new(TRUE, 0);
        	gtk_container_add(GTK_CONTAINER(frame), vbox_c);
        	
        	gtkutils_add_label_entry(vbox_c, _("Hostname:"), &selfp->entry_servername, NULL);
        	gtkutils_add_label_spin_button(vbox_c, _("Port:"), &selfp->spin_port, 1, 65535, 1);
        
	}}
#line 608 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 302 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_append_irc_page (LoquiAccountDialog * self)
{
#line 615 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::append_irc_page"
#line 302 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 302 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 621 "loqui-account-dialog.c"
{
#line 303 "loqui-account-dialog.gob"
	
		GtkWidget *vbox;

        	vbox = gtk_vbox_new(FALSE, 0);
        	gtk_notebook_append_page(GTK_NOTEBOOK(selfp->notebook), vbox, gtk_label_new(_("IRC")));
        	
        	gtkutils_add_label_entry(vbox, _("Realname:"), &selfp->entry_realname, NULL);
        	gtkutils_add_label_entry(vbox, _("User information:"), &selfp->entry_userinfo, NULL);
        	gtkutils_add_label_entry(vbox, _("Auto join channels (ex. #a,#b,#c keyA,keyB):"), &selfp->entry_autojoin, NULL);
        	gtkutils_add_label_entry(vbox, _("Quit message:"), &selfp->entry_quit_message, NULL);
	}}
#line 635 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 315 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_append_code_page (LoquiAccountDialog * self)
{
#line 642 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::append_code_page"
#line 315 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 315 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 648 "loqui-account-dialog.c"
{
#line 316 "loqui-account-dialog.gob"
	
		GtkWidget *vbox;
        	GtkCellRenderer *cell;
        	GtkWidget *frame;
                GSList *group_codeconv = NULL;
        	GtkWidget *vbox1;
        	GtkWidget *hbox1;
        	GtkWidget *label;

        	vbox = gtk_vbox_new(FALSE, 0);
        	gtk_notebook_append_page(GTK_NOTEBOOK(selfp->notebook), vbox, gtk_label_new(_("Code")));
        
        	frame = gtk_frame_new(_("Code convertion"));
        	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 2);
        	
                vbox1 = gtk_vbox_new(FALSE, 0);
                gtk_container_add(GTK_CONTAINER(frame), vbox1);
        
                selfp->radio_automatic = gtk_radio_button_new_with_mnemonic(NULL, _("Automatic detection by locale"));
                gtk_box_pack_start(GTK_BOX(vbox1), selfp->radio_automatic, FALSE, FALSE, 0);
                group_codeconv = gtk_radio_button_get_group(GTK_RADIO_BUTTON(selfp->radio_automatic));
        	g_signal_connect(G_OBJECT(selfp->radio_automatic), "toggled",
        			 G_CALLBACK(self_radio_toggled_cb), self);
        
                selfp->radio_noconv = gtk_radio_button_new_with_mnemonic(NULL, _("No convertion"));
                gtk_box_pack_start(GTK_BOX(vbox1), selfp->radio_noconv, FALSE, FALSE, 0);
                gtk_radio_button_set_group(GTK_RADIO_BUTTON(selfp->radio_noconv), group_codeconv);
                group_codeconv = gtk_radio_button_get_group(GTK_RADIO_BUTTON(selfp->radio_noconv));
        	g_signal_connect(G_OBJECT(selfp->radio_noconv), "toggled",
        			 G_CALLBACK(self_radio_toggled_cb), self);
        
                selfp->radio_bytable = gtk_radio_button_new_with_mnemonic(NULL, _("Select from the table"));
                gtk_box_pack_start(GTK_BOX(vbox1), selfp->radio_bytable, FALSE, FALSE, 0);
                gtk_radio_button_set_group(GTK_RADIO_BUTTON(selfp->radio_bytable), group_codeconv);
                group_codeconv = gtk_radio_button_get_group(GTK_RADIO_BUTTON(selfp->radio_bytable));
        	g_signal_connect(G_OBJECT(selfp->radio_bytable), "toggled",
        			 G_CALLBACK(self_radio_toggled_cb), self);
        
        	selfp->model_codeconv_table = GTK_TREE_MODEL(gtk_list_store_new(CODECONV_COLUMN_NUMBER,
        								       G_TYPE_STRING,
        								       G_TYPE_STRING));
        	
                selfp->combobox_table = gtk_combo_box_new_with_model(selfp->model_codeconv_table);
                gtk_box_pack_start(GTK_BOX(vbox1), selfp->combobox_table, FALSE, FALSE, 0);
        
        	cell = gtk_cell_renderer_text_new();
        	gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(selfp->combobox_table), cell, TRUE);
        	gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(selfp->combobox_table), cell,
        				       "text", 0,
        				       NULL);
        
                selfp->radio_codeset = gtk_radio_button_new_with_mnemonic(NULL, _("Specify codeset"));
                gtk_box_pack_start(GTK_BOX(vbox1), selfp->radio_codeset, FALSE, FALSE, 0);
                gtk_radio_button_set_group(GTK_RADIO_BUTTON(selfp->radio_codeset), group_codeconv);
                group_codeconv = gtk_radio_button_get_group(GTK_RADIO_BUTTON(selfp->radio_codeset));
        	g_signal_connect(G_OBJECT(selfp->radio_codeset), "toggled",
        			 G_CALLBACK(self_radio_toggled_cb), self);
        
                hbox1 = gtk_hbox_new(FALSE, 0);
                gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, FALSE, 0);
        
                label = gtk_label_new(_("Codeset: "));
                gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 0);
        
                selfp->entry_codeset = gtk_entry_new();
                gtk_box_pack_start(GTK_BOX(hbox1), selfp->entry_codeset, TRUE, TRUE, 0);
	}}
#line 718 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 383 "loqui-account-dialog.gob"
static void 
loqui_account_dialog_append_nick_page (LoquiAccountDialog * self)
{
#line 725 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::append_nick_page"
#line 383 "loqui-account-dialog.gob"
	g_return_if_fail (self != NULL);
#line 383 "loqui-account-dialog.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_DIALOG (self));
#line 731 "loqui-account-dialog.c"
{
#line 384 "loqui-account-dialog.gob"
	
		GtkWidget *vbox;
        	GtkWidget *frame;

        	vbox = gtk_vbox_new(FALSE, 0);
        	gtk_notebook_append_page(GTK_NOTEBOOK(selfp->notebook), vbox, gtk_label_new(_("Nick")));
        
        	frame = gtkutils_create_framed_textview(&selfp->textview_nicklist,
        						_("List of often used nick(Separate each words with linefeeds)"));
        
        	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);
        }}
#line 746 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 397 "loqui-account-dialog.gob"
GtkWidget * 
loqui_account_dialog_new (LoquiProfileAccount * profile)
{
#line 753 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::new"
{
#line 398 "loqui-account-dialog.gob"
	
		GtkWidget *vbox;
		Self *self;
       
		self = GET_NEW;
        	
        	selfp->profile = profile;
        
        	gtk_dialog_add_buttons(GTK_DIALOG(self),
        			       GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
        			       GTK_STOCK_OK, GTK_RESPONSE_OK,
        			       NULL);
        
        	g_signal_connect(G_OBJECT(self),
        			 "response",
        			 G_CALLBACK(loqui_account_dialog_response_cb),
        			 self);
        
        	vbox = GTK_DIALOG(self)->vbox;
        	
        	selfp->notebook = gtk_notebook_new();
        	gtk_box_pack_start(GTK_BOX(vbox), selfp->notebook, TRUE, TRUE, 0);
        
		self_append_profile_page(self);
		if (LOQUI_IS_PROFILE_ACCOUNT_IRC(profile)) {
			self_append_irc_page(self);
		}

		self_append_code_page(self);
		self_append_nick_page(self);

		self_load(self, profile);

        	gtk_widget_show_all(GTK_WIDGET(self));
        
        	return GTK_WIDGET(self);
        }}
#line 794 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 436 "loqui-account-dialog.gob"
void 
loqui_account_dialog_open_add_dialog (GtkWindow * parent, LoquiAccountManager * manager)
{
#line 801 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::open_add_dialog"
{
#line 437 "loqui-account-dialog.gob"
	
        	LoquiAccountDialog *dialog;
        	LoquiProfileAccount *profile;
        	LoquiAccount *account;
        	gint response;
		LoquiProtocolSelectionDialog *protocol_dialog;
		LoquiProtocol *protocol;

		protocol = loqui_protocol_manager_get_protocol(manager->protocol_manager, "IRC"); /* FIXME */
		protocol_dialog = LOQUI_PROTOCOL_SELECTION_DIALOG(loqui_protocol_selection_dialog_new(parent, manager->protocol_manager, protocol));
		
        	response = gtk_dialog_run(GTK_DIALOG(protocol_dialog));
		if (response != GTK_RESPONSE_OK ||
		    (protocol = loqui_protocol_selection_dialog_get_protocol(protocol_dialog)) == NULL) {
			gtk_widget_destroy(GTK_WIDGET(protocol_dialog));
			return;
		}

		g_object_ref(protocol);
		gtk_widget_destroy(GTK_WIDGET(protocol_dialog));

		profile = loqui_protocol_create_profile_account(protocol);
        	dialog = SELF(self_new(profile));
        	gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);
        	response = gtk_dialog_run(GTK_DIALOG(dialog));
        	gtk_widget_destroy(GTK_WIDGET(dialog));
        
        	if (response == GTK_RESPONSE_OK) {
			account = loqui_protocol_create_account(protocol, profile);
        		loqui_account_manager_add_account(manager, account);
        		g_object_unref(account);
			
        		loqui_account_manager_save_accounts(manager);
        	}

		g_object_unref(profile);
		g_object_unref(protocol);
        }}
#line 843 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 476 "loqui-account-dialog.gob"
void 
loqui_account_dialog_open_configure_dialog (GtkWindow * parent, LoquiAccountManager * manager, LoquiAccount * account)
{
#line 850 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::open_configure_dialog"
{
#line 477 "loqui-account-dialog.gob"
	
        	GtkWidget *dialog;
        	
        	dialog = self_new(loqui_account_get_profile(account));
        	gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);
        	gtk_dialog_run(GTK_DIALOG(dialog));
        	gtk_widget_destroy(dialog);
        
        	/* FIXME: should do
        	   account_manager_update_account(manager, account); */
        	loqui_account_manager_save_accounts(manager);
        }}
#line 866 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__

#line 490 "loqui-account-dialog.gob"
void 
loqui_account_dialog_open_remove_dialog (GtkWindow * parent, LoquiAccountManager * manager, LoquiAccount * account)
{
#line 873 "loqui-account-dialog.c"
#define __GOB_FUNCTION__ "Loqui:Account:Dialog::open_remove_dialog"
{
#line 491 "loqui-account-dialog.gob"
	
        	GtkWidget *dialog;
        	gint response;
        
        	dialog = gtk_message_dialog_new(parent,
        					GTK_DIALOG_DESTROY_WITH_PARENT,
        					GTK_MESSAGE_WARNING,
        					GTK_BUTTONS_YES_NO,
        					_("This account's configuration and connection will be removed.\n"
        					  "Do you really want to remove this account?"));
        	response = gtk_dialog_run(GTK_DIALOG(dialog));
        	gtk_widget_destroy(dialog);
        
        	if (response == GTK_RESPONSE_YES) {
        		loqui_account_manager_remove_account(manager, account);
        		loqui_account_manager_save_accounts(manager);
        		loqui_debug_puts("Removed account.");
        	}
        }}
#line 896 "loqui-account-dialog.c"
#undef __GOB_FUNCTION__
