<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2008-2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2008, Stéphane Graber <stgraber@ubuntu.com>
 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of·
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

function theme_ubuntu_menu($categories) {
    # Takes an array as input containing arrays then containing title, link and status for each item
    foreach ($categories as $category) {
        echo "
            <b class=\"ubuntu_roundnavbar\">
            <b class=\"ubuntu_roundnavbar1\"></b>
            <b class=\"ubuntu_roundnavbar2\"></b>
            <b class=\"ubuntu_roundnavbar3\"></b>
            <b class=\"ubuntu_roundnavbar4\"><b></b></b>
            <b class=\"ubuntu_roundnavbar5\"><b></b></b></b>
            <table class=\"ubuntu_menu\">
                <tr class=\"ubuntu_menuheader\">
                    <td>
                        <b>".$category['name']."</b>
                    </td>
                </tr>";
            foreach ($category['items'] as $item) {
                if ($item['current'] == 0) {
                    echo "
                <tr>
                    <td class=\"ubuntu_menu_entry\">
                        <a href=\"".$item['link']."\">".$item['title']."</a>
                    </td>
                </tr>
                    ";
                }
                else {
                    echo "
                <tr>
                    <td class=\"ubuntu_menu_entry\">
                        <b>".$item['title']."</b>
                    </td>
                </tr>
                    ";
                }
            }
        echo "
            </table>
        ";
    }
}
?>
