/*--------------------------------------------------------------------------+
$Id: DigesterTest.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.digest;

import java.util.Arrays;
import java.util.regex.Pattern;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test case for {@link Digester}.
 * 
 * @author juergens
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 6A738E200E284235C1F909D7C4362B01
 */
public class DigesterTest extends CCSMTestCaseBase {

	/** Test whether fingerprints conform to MD5 format. */
	public void testCreateMD5Digest() {
		String[] bases = new String[] { "b", "bbb", "Hallo",
				"This is some Text", "8u6e5783492365" };

		for (String base : bases) {
			String fingerprint = Digester.createMD5Digest(base);
			validateFingerprint(fingerprint);
		}
	}

	/**
	 * Asserts that the fingerprint is 32 chars long and only uses hex
	 * characters.
	 */
	private void validateFingerprint(String fingerprint) {
		assertEquals(32, fingerprint.length());
		assertTrue("Illegal characters found in fingerprint: " + fingerprint,
				Pattern.matches("[0-9a-fA-F]+", fingerprint));
	}

	/**
	 * Assert that order of strings in collection has no influence on generated
	 * MD5
	 */
	public void testCreateFingerprintFromCollection() {
		String digest1 = Digester.createMD5Digest(Arrays.asList(new String[] {
				"a", "b", "c" }));
		String digest2 = Digester.createMD5Digest(Arrays.asList(new String[] {
				"c", "b", "a" }));

		assertEquals(digest1, digest2);
	}

}