/*--------------------------------------------------------------------------+
$Id: EnumUtilsTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.enums;

import junit.framework.TestCase;

/**
 * JUnit test for <code>EnumUtils</code> class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * 
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: B622B3D9A6A99204D2A3F6D6D4A21549
 */
public class EnumUtilsTest extends TestCase {

	/** Test enum. */
	private enum TestEnum {
		/***/
		TEST1, /***/
		TEST2, /***/
		TEST3
	}

	/**
	 * Test method for 'edu.tum.cs.commons.enums.EnumUtils.valueOf(Class<T>,
	 * String) <T>'
	 */
	public void testValueOf() {
		TestEnum result = EnumUtils.valueOf(TestEnum.class, "TEST1");
		assertEquals(TestEnum.TEST1, result);
		result = EnumUtils.valueOf(TestEnum.class, "TEST2");
		assertEquals(TestEnum.TEST2, result);
		result = EnumUtils.valueOf(TestEnum.class, "TEST3");
		assertEquals(TestEnum.TEST3, result);

		result = EnumUtils.valueOf(TestEnum.class, "TEST4");
		assertNull(result);

		result = EnumUtils.valueOf(TestEnum.class, "test1");
		assertNull(result);
	}

	/**
	 * Test method for
	 * 'edu.tum.cs.commons.enums.EnumUtils.valueOfIgnoreCase(Class<T>, String)
	 * <T>'
	 */
	public void testValueOfIgnoreCase() {
		TestEnum result = EnumUtils.valueOfIgnoreCase(TestEnum.class, "TEST1");
		assertEquals(TestEnum.TEST1, result);

		result = EnumUtils.valueOfIgnoreCase(TestEnum.class, "test1");
		assertEquals(TestEnum.TEST1, result);

		result = EnumUtils.valueOfIgnoreCase(TestEnum.class, "teSt1");
		assertEquals(TestEnum.TEST1, result);

		result = EnumUtils.valueOfIgnoreCase(TestEnum.class, "Test1");
		assertEquals(TestEnum.TEST1, result);

		result = EnumUtils.valueOf(TestEnum.class, "testX");
		assertNull(result);

	}

}