/*--------------------------------------------------------------------------+
$Id: ModelUtils.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml.example;

import java.io.File;
import java.io.IOException;

import edu.tum.cs.commons.filesystem.FileSystemUtils;

/**
 * Class with static methods to create demo models.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 54FE5A71A558850CA75D07EE78EAE4E2
 */
public class ModelUtils {

	/** Create simple example model. */
	public static Model createExampleModel() {
		Model model = new Model();

		Address addressA = new Address("Street A", "City A");
		Address addressB = new Address("Street B", "City B");

		Person personA = new Person("Person A", addressA, "details of person A");
		Person personB = new Person("Person B", addressB, "details of person B contain Markup: <element/> &<>'\"");

		Order order1 = new Order("Order 1", "1");
		Order order2 = new Order("Order 2", "2");
		Order order3 = new Order("Order 3", "3");
		Order order4 = new Order("Order 4", "4&<>'\"");
		

		personA.add(order1);
		personA.add(order2);

		personB.add(order3);
		personB.add(order4);

		model.add(personA);
		model.add(personB);

		return model;
	}

	/** Create an example model that raised an exception when read. */
	public static Model createIllegalExampleModel() {
		Model model = createExampleModel();

		Address address = new Address("Illegal Street", "Illegal City");
		Person person = new Person("Illegal Person", address, "Illegal Details");

		Order order1 = new Order("Order 1", "1");
		Order order2 = new Order("Order 2", "2");
		Order order3 = new Order("Order 3", "3");

		person.add(order1);
		person.add(order2);
		person.add(order3);

		model.add(person);

		return model;
	}

	/**
	 * Write a model to a file. This ensures all necessary directories exist.
	 */
	public static void writeModel(Model model, File file) throws IOException {

		FileSystemUtils.ensureParentDirectoryExists(file);

		ModelWriter writer = new ModelWriter(file, model);

		writer.writeModel();
	}
}