/*--------------------------------------------------------------------------+
$Id: StateflowData.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.commons.assertion.CCSMPre;

/**
 * A Stateflow data object.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 92945C07CDDDF1ECF95133627868160F
 */
public class StateflowData extends StateflowDeclBase {

	/** Create new data object. */
	public StateflowData() {
		super();
	}

	/** Copy constructor for deep cloning. */
	private StateflowData(StateflowData stateflowData) {
		super(stateflowData);
	}

	/** Remove this data object from the model. */
	@Override
	public void remove() {
		CCSMPre.isFalse(getParent() == null,
				"Data object has no parent to be removed from.");
		getParent().removeData(this);
	}

	/** Deep clone this data object. */
	public StateflowData deepClone() {
		return new StateflowData(this);
	}
}