/*--------------------------------------------------------------------------+
$Id: StateflowJunction.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.simulink.model.SimulinkConstants;
import edu.tum.cs.simulink.util.SimulinkUtils;

/**
 * This class represents Stateflow junctions.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 57A4190FFF522741F8A0EAA1281D12EA
 */
public class StateflowJunction extends StateflowNodeBase {

	/** Create junction. */
	public StateflowJunction() {
		super();
	}

	/** Create new junction from existing one (for deep cloning). */
	private StateflowJunction(StateflowJunction orig) {
		super(orig);

		// duplicate all default transitions to this one
		for (StateflowTransition transition : orig.getInTransitions()) {
			if (transition.getSrc() == null) {
				SimulinkUtils.copyParameters(transition,
						new StateflowTransition(this));
			}
		}
	}

	/** Get junction type. */
	public String getType() {
		return getParameter(SimulinkConstants.PARAM_type);
	}

	/** Returns junction type and id. */
	@Override
	public String toString() {
		return getType() + " (" + getStateflowId() + ")";
	}

	/** {@inheritDoc} */
	@Override
	public StateflowJunction deepClone() {
		return new StateflowJunction(this);
	}
}