/*--------------------------------------------------------------------------+
$Id: MDLSmokeTestlet.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.targetlink;

import org.junit.Ignore;

import edu.tum.cs.commons.logging.SimpleLogger;
import edu.tum.cs.commons.test.TestletBase;
import edu.tum.cs.simulink.builder.SimulinkModelBuilder;
import edu.tum.cs.simulink.model.SimulinkModel;
import edu.tum.cs.simulink.util.SimulinkUtils;

/**
 * Smoke testlet for Simulink/Stateflow. This builds a Simulink file and runs
 * the {@link TargetLinkDataResolver} on all blocks.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 7A9D9C3759A52F67978F8BC83576EB7A
 */
@Ignore
public class MDLSmokeTestlet extends TestletBase {

	/** Name of file to read. */
	private final String filename;

	/** Create new testlet. */
	MDLSmokeTestlet(String filename) {
		this.filename = filename;
	}

	/** Return name smoke test. */
	@Override
	public String getName() {
		return filename;
	}

	/**
	 * Builds a Simulink file and run the {@link TargetLinkDataResolver} on all
	 * blocks.
	 */
	@Override
	public void test() throws Exception {
		SimulinkModelBuilder builder = new SimulinkModelBuilder(
				useTestFile(filename), new SimpleLogger());
		SimulinkModel model = builder.buildModel();
		SimulinkUtils.visitDepthFirst(model, new TargetLinkDataResolver());
	}
}