/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__BOUNDSEXCEPTION_HPP)
#include <BoundsException.hpp>
#endif

namespace   corelinux
{
   //
   // Default public constructor
   //

   BoundsException::BoundsException
      ( 
         CharCptr file,
         LineNum  line,
         Severity severity,
         bool     outOfMemory
      )
      :
      StorageException("BoundsException",file,line,severity,outOfMemory)
   {
      ;  // do nothing
   }

   //
   // Implementation protected constructor
   //

   BoundsException::BoundsException
      ( 
         CharCptr why,
         CharCptr file,
         LineNum  line,
         Severity severity,
         bool     outOfMemory
      )
      :
      StorageException(why,file,line,severity,outOfMemory)
   {
      ;  // do nothing
   }
   //
   // Default protected constructor
   //

   BoundsException::BoundsException( void )
      :
      StorageException()
   {
      NEVER_GET_HERE;
   }

   //
   // Copy constructor
   //

   BoundsException::BoundsException( BoundsExceptionCref aRef )
      :
      StorageException( aRef )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   BoundsException::~BoundsException( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   BoundsExceptionRef BoundsException::operator=
      ( 
         BoundsExceptionCref aRef 
      )
   {
      StorageException::operator=( aRef );
      return (*this);
   }

   //
   // Equality operator
   //

   bool  BoundsException::operator==( BoundsExceptionCref aRef ) const
   {
      return (this == &aRef);
   }

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/15 13:45:56 $
   $Locker:  $
*/


