/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif 

namespace corelinux
{
   //
   // Default constructor
   //

   Identifier::Identifier( void )
      :
      CoreLinuxObject()
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   Identifier::Identifier( IdentifierCref aRef )
      :
      CoreLinuxObject( aRef )
   {
      ;  // do nothing
   }

   //
   // Virtual Destructor
   //

   Identifier::~Identifier( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   IdentifierRef  Identifier::operator=( IdentifierCref aRef )
   {
      CoreLinuxObject::operator=( aRef );
      return (*this);
   }

   //
   // Equality operator
   //

   bool  Identifier::operator==( IdentifierCref aRef ) const
   {
      return isEqual( aRef );
   }

   //
   // Non-equality operator
   //

   bool  Identifier::operator!=( IdentifierCref aRef ) const
   {
      return !( this->operator==(aRef) );
   }

   //
   // Less than operator
   //

   bool Identifier::operator<( IdentifierCref aRef ) const
   {
      return isLessThan(aRef);
   }

   //
   // Less than or equal operator
   //

   bool Identifier::operator<=( IdentifierCref aRef ) const
   {
      return isLessThanOrEqual(aRef);
   }

   //
   // Greater than operator
   //

   bool Identifier::operator>( IdentifierCref aRef ) const
   {
      return isGreaterThan(aRef);
   }

   //
   // Greater than or equal operator
   //

   bool Identifier::operator>=( IdentifierCref aRef ) const
   {
      return isGreaterThanOrEqual(aRef);
   }

   //
   // Virtual methods that all return true
   //

   bool Identifier::isEqual( IdentifierCref ) const
   {
      return true;
   }

   bool Identifier::isLessThan( IdentifierCref ) const
   {
      return true;
   }

   bool Identifier::isLessThanOrEqual( IdentifierCref ) const
   {
      return true;
   }

   bool Identifier::isGreaterThan( IdentifierCref ) const
   {
      return true;
   }

   bool Identifier::isGreaterThanOrEqual( IdentifierCref ) const
   {
      return true;
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/03/01 03:29:37 $
   $Locker:  $
*/


