/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__WALLFLYWEIGHT_HPP)
#include <WallFlyweight.hpp>
#endif

using namespace corelinux;
#include <iostream>
using namespace std;

//
// Default constructor
//

WallFlyweight::WallFlyweight( void )
   : 
   MapSite(),
   Flyweight()
{
   ;  // do nothing
}

//
// Copy constructor
//

WallFlyweight::WallFlyweight( WallFlyweightCref aRef )
   :
   MapSite( aRef ),
   Flyweight( aRef )
{
   ;  // do nothing
}

//
// Virtual destructor
//

WallFlyweight::~WallFlyweight( void )
{
   ;  // do nothing
}

//
// Assignment
//

WallFlyweightRef  WallFlyweight::operator=( WallFlyweightCref )
{
   return (*this);
}

//
// Equality
//

bool  WallFlyweight::operator==( WallFlyweightCref aRef ) const
{
   return ( this == &aRef );
}

//
// Operation
//

void  WallFlyweight::enter( void )
{
   cout  << "Bam you just hit a flyweight wall" << endl;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/07/28 01:51:37 $
   $Locker:  $
*/

