#if   !defined(__ASSOCIATIVEITERATOR_HPP)
#define  __ASSOCIATIVEITERATOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ITERATOR_HPP)
#include <Iterator.hpp>
#endif

namespace   corelinux
{

   /**
   The AssociativeIterator that extends Iterator to include the
   interface for describing an associative collection type 
   without exposing its underlying representation. 
   The implementation requires a template arguments
   that describes the KeyType and ElementType being iterated over.
   */

   template< class KeyType, class ElementType >
      class AssociativeIterator : public Iterator<ElementType>
      {
      public:

         //
         // Constructors and destructor
         //

                     /// Default constructor

                     AssociativeIterator( void )
                        :
                        Iterator<ElementType>()
                     {
                        ;  // do nothing
                     }

                     /**
                     Copy constructor
                     @param AssociativeIterator const reference
                     */

                     AssociativeIterator( const AssociativeIterator &aRef )
                        :
                        Iterator<ElementType>( aRef )
                     {
                        ;  // do nothing
                     }

                     /// Destructor

         virtual     ~AssociativeIterator( void )
         {
            ;  // do nothing
         }

         //
         // Operator overloads
         //

                  /**
                  Assignment operator
                  @param AssociativeIterator const reference
                  @return AssociativeIterator reference
                  */

                  AssociativeIterator & operator=( const AssociativeIterator & )
                  {
                     return (*this);
                  }

                  /**
                  Equality operator
                  @param AssociativeIterator const reference
                  @return bool - true if instances are equal
                  */

                  bool  operator==( const AssociativeIterator & aRef ) const
                  {
                     return (this == &aRef);
                  }
                  

         //
         // Accessors
         //

                  /**
                  getKey returns the KeyType instance
                  that is currently pointed to by the AssociativeIterator
                  @return KeyType 
                  @exception IteratorBoundsException if the AssociativeIterator
                  is not positioned correctly.
                  */

         virtual  KeyType  getKey( void ) 
                         const throw(IteratorBoundsException) = 0;
   
      };
}

#endif   // if !defined(__ASSOCIATIVEITERATOR_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


