/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__SUBJECT_HPP)
#include <Subject.hpp>
#endif

#if   !defined(__OBSERVER_HPP)
#include <Observer.hpp>
#endif

namespace corelinux
{
   //
   // Default constructor
   //

   Subject::Subject( void )
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   Subject::Subject( SubjectCref )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   Subject::~Subject( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   SubjectRef Subject::operator=( SubjectCref )
   {
      return (*this);
   }

   //
   // Equality operator
   //

   bool  Subject::operator==( SubjectCref aRef ) const
   {
      bool  isMe(false);

      if( this == &aRef )
      {
         isMe = true;
      }
      else
      {
         ;  // do nothing
      }
      return isMe;
   }

   //
   // Non-equality operator
   //

   bool  Subject::operator!=( SubjectCref aRef ) const
   {
      return !(this->operator==(aRef));
   }

   // Notification spray

   void  Subject::notifyObservers( Event<Identifier> * anEvent )
               throw ( NullPointerException ) 
   {
      if( anEvent == NULLPTR )
      {
         throw NullPointerException(LOCATION);
      }
      else
      {
         Iterator<ObserverPtr> *aItr( this->createIterator( anEvent ) );
         while( aItr->isValid() )
         {
            aItr->getElement()->event( anEvent );
            aItr->setNext();
         }
      }
   }

   // Notification spray

   void  Subject::notifyAllObservers( Event<Identifier> * anEvent )
               throw ( NullPointerException ) 
   {
      if( anEvent == NULLPTR )
      {
         throw NullPointerException(LOCATION);
      }
      else
      {
         Iterator<ObserverPtr> *aItr( this->createIterator() );
         while( aItr->isValid() )
         {
            aItr->getElement()->event( anEvent );
            aItr->setNext();
         }
      }
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 14:53:13 $
   $Locker:  $
*/



