<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
Specialized stylesheet to generate a stand-alone web page for the
code coverage project.

version $Date: 2004/04/17 08:24:39 $
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>

    <xsl:output method="html" indent="no" />
    
    <xsl:param name="projectname" select="'[unknown]'" />
    <xsl:param name="projectversion" select="'[unknown]'" />
    
    <!-- base document -->
    <xsl:template match="document">
<HTML>
<xsl:comment>
WARNING: DO NOT EDIT THIS FILE

This file was auto-generated.  Please look at the .xml version of this file
and edit that one instead.
</xsl:comment>
<HEAD>
    <TITLE>
    GroboCoverage - <xsl:value-of select="head/name/text()" />
    </TITLE>
</HEAD>
<BODY>
<P STYLE="font-size: smaller; text-align: right;"><i><a href="index.html">
<xsl:value-of select="$projectname" /> version
<xsl:value-of select="$projectversion" /></a></i></P>
<CENTER>
<H1><!-- <xsl:value-of select="$projectname"/>: -->
<xsl:value-of select="head/name/text()" /></H1>
</CENTER>
<xsl:if test="head/author"> <!-- if there is a second node,
    then use the plural form. -->
    <P STYLE="font-size: smaller; text-align: left;"><i>
    <xsl:choose><xsl:when test="head/author[2]">Authors:</xsl:when
    ><xsl:otherwise>Author:</xsl:otherwise></xsl:choose> <xsl:apply-templates
    select="head/author"  /></i></P></xsl:if>
<xsl:if test="head/doc-version"><xsl:comment>
version: <xsl:value-of select="head/doc-version/text()" />
</xsl:comment></xsl:if>



<xsl:apply-templates select="body" />

<TABLE WIDTH="100%">
<TR>
    <TD COLSPAN="2" WIDTH="100%">
        <HR />
    </TD>
</TR>
<TR>
    <!--
    <TD ALIGN="LEFT" WIDTH="30%">
        <A href="https://sourceforge.net"><IMG
            src="https://sourceforge.net/sflogo.php?group_id=22594&amp;type=1"
            width="88" height="31" border="0" alt="SourceForge Logo" /></A>
        <BR />
        <I>This space graciously provided by the SourceForge project</I>
    </TD>
    -->
    <TD ALIGN="RIGHT" WIDTH="70%">
        <I><xsl:text disable-output-escaping="yes">Copyright &amp;copy;
2002-2004 GroboUtils Project.</xsl:text><BR />All rights reserved.</I>
    </TD>
</TR>
</TABLE>
</BODY>
</HTML>
    </xsl:template>

    <xsl:template match="author"><xsl:if
            test="preceding-sibling::author[position()=1]"
            >, </xsl:if><xsl:apply-templates select="text()|*" /></xsl:template>

    <!-- Copy all the text -->
    <xsl:template match="body">
        <xsl:apply-templates select="text()|*" />
    </xsl:template>
    
    <xsl:template match="description">
        <xsl:apply-templates select="text()|*" />
    </xsl:template>
    
    <!-- easy way to make links -->
    <xsl:template match="ant-link">
        <tt><a><xsl:attribute
            name="href">http://ant.apache.org/manual/<xsl:value-of
            select="@href" /></xsl:attribute><xsl:value-of select="text()"
            /></a></tt>
    </xsl:template>
    
    <xsl:template match="link">
        <a href="{@name}.html"><xsl:value-of select="text()" /></a>
    </xsl:template>
    
    <xsl:template match="ref">
        <a href="#{@name}">[<xsl:value-of select="@name" />]</a>
    </xsl:template>
    
    <xsl:template match="javabug">
        <a href="http://developer.java.sun.com/developer/bugParade/bugs/{@bugid}.html"><xsl:value-of select="@bugid" /></a>
    </xsl:template>
    
    <xsl:template match="source">
        <PRE>
<xsl:apply-templates select="text()|*" />
<!--
<xsl:call-template name="CopyWithTemplates" />
<xsl:value-of select="text()" />
-->
        </PRE>
    </xsl:template>
    
    <xsl:template match="section">
        <xsl:if test="@name">
            <A><xsl:attribute
            name="NAME"><xsl:value-of select="@name" /></xsl:attribute></A>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="@level">
                <xsl:element name="concat('H',@level+1)">
                    <xsl:apply-templates select="text()|*" />
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <H3><xsl:apply-templates select="text()|*" /></H3>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="special-text">
        <!-- ignored -->
    </xsl:template>
    
    <xsl:template match="definition">
        <LI>
        <B><xsl:value-of select="@term" />:</B>
        <xsl:apply-templates select="text()|*" />
        </LI>
    </xsl:template>
    
    <xsl:template match="definition-link">
        <LI>
        <B><a href="{@href}"><xsl:value-of select="@term" /></a>:</B>
        <xsl:apply-templates select="text()" />
        </LI>
    </xsl:template>
    
    <xsl:template match="reflist">
        <H3><a name="references">References</a></H3>
        <TABLE BORDER="0" WIDTH="100%">
            <xsl:apply-templates />
        </TABLE>
    </xsl:template>
    
    <xsl:template match="refitem">
            <TR><TD VALIGN="TOP" ALIGN="LEFT" WIDTH="20%"><a>
                <xsl:attribute name="name"><xsl:value-of select="@id"
                /></xsl:attribute>[<xsl:value-of select="@id" />]</a></TD>
            <TD VALIGN="TOP" ALIGN="LEFT" WIDTH="80%">
            <xsl:apply-templates select="text()|*" />
            </TD>
            </TR>
    </xsl:template>
    
    <!--
      Ant Tasks
      -->
    <xsl:template match="anttask">
        <H2><a><xsl:attribute name="name"><xsl:value-of select='@name' /></xsl:attribute><xsl:value-of select='@name' /></a></H2>
        <xsl:if test="description" >
        <H3>Description</H3>
            <xsl:apply-templates select="description" />
        <BR />
        </xsl:if>
        <xsl:call-template name="ant-nested-element-table" />
        <xsl:call-template name="ant-param-table" />
        <xsl:if test="ant-example">
        <H3>Examples</H3>
            <xsl:apply-templates select="ant-example" />
            <BR />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ant-nested-element-table">
        <xsl:if test="ant-nested-element">
        <H3>Nested Elements</H3>
            <xsl:apply-templates select="ant-nested-element" >
                    <!-- <xsl:sort select="@name" /> -->
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="ant-nested-element">
        <table border="1"><tr><td>
        <H4><xsl:value-of select="@name" /></H4>
        <xsl:if test="description">
            <xsl:apply-templates select="description" />
            <BR />
        </xsl:if>
        <xsl:call-template name="ant-param-table" />
        <xsl:call-template name="ant-nested-element-table" />
        </td></tr></table>
        <BR />
    </xsl:template>
    
    <xsl:template name="ant-param-table">
        <xsl:if test="ant-parameter" >
    <H3>Parameters</H3>
    <TABLE BORDER="1" CELLPADDING="1" CELLSPACING="0">
        <TR>
            <TD VALIGN="top"><B>Attribute</B></TD>
            <TD VALIGN="top"><B>Description</B></TD>
            <TD ALIGN="center" VALIGN="top"><B>Required</B></TD>
        </TR>
        <xsl:apply-templates select="ant-parameter">
            <!-- <xsl:sort select="attribute/text()" /> -->
        </xsl:apply-templates>
    </TABLE>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="ant-parameter">
        <TR>
            <TD VALIGN="top"><CODE><xsl:value-of select="attribute/text()" /></CODE></TD>
            <TD VALIGN="top"><xsl:apply-templates select="description" /></TD>
            <TD VALIGN="top" ALIGN="center"><xsl:apply-templates select="required" /></TD>
        </TR>
    </xsl:template>
    
    <xsl:template match="ant-example">
        <xsl:apply-templates select="source" />
        <xsl:apply-templates select="description" />
        <xsl:if test="position()!=last()">
        <HR WIDTH="50%" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="project"><xsl:value-of
        select="$projectname" /></xsl:template>
    <xsl:template match="version"><xsl:value-of
        select="$projectversion" /></xsl:template>
    
    <!-- The copy stuff -->
    <xsl:template match="@*|node()" name="CopyWithTemplates">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
