/*
 *  @(#)AsmblTransitionSet.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.assembler;

import net.sourceforge.groboutils.mbtf.v1.IState;
import net.sourceforge.groboutils.mbtf.v1.ITransition;
import net.sourceforge.groboutils.mbtf.v1.engine.TransitionImpl;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;


/**
 * Contains the set of transitions in their pre-assembled state.  Used for
 * accessing a collection of transitions.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 13, 2002
 */
public class AsmblTransitionSet
{
    private Hashtable nameToTrans = new Hashtable();
    
    /**
     * 
     */
    public AsmblTransitionSet()
    {
        // do nothing
    }
    
    
    /**
     * 
     */
    public void addTransition( AsmblTransition trans )
    {
        if (trans != null)
        {
            this.nameToTrans.put( trans.getName(), trans );
        }
    }
    
    
    /**
     * 
     */
    public void addTransitions( AsmblTransition[] trans )
    {
        if (trans != null)
        {
            for (int i = trans.length; --i >= 0;)
            {
                addTransition( trans[i] );
            }
        }
    }
    
    
    /**
     * 
     */
    public AsmblTransition getTransition( String name )
    {
        return (AsmblTransition)this.nameToTrans.get( name );
    }
    
    
    /**
     * 
     */
    public AsmblTransition[] getTransitions()
    {
        AsmblTransition as[] = new AsmblTransition[ this.nameToTrans.size() ];
        Enumeration enum = this.nameToTrans.elements();
        for (int i = 0; enum.hasMoreElements(); ++i)
        {
            as[i] = (AsmblTransition)enum.nextElement();
        }
        return as;
    }
    
    
    /**
     * Sets the destination state for every transition.  If a transition's
     * destination state is not in the set, then an IllegalArgumentException
     * is thrown.
     */
    public void setDestinationStates( Hashtable nameToIState )
    {
        AsmblTransition[] ats = getTransitions();
        for (int i = ats.length; --i >= 0;)
        {
            IState s = (IState)nameToIState.get( ats[i].getNextStateName() );
            if (s == null)
            {
                throw new IllegalArgumentException("Transition '"+
                    ats[i].getName()+"' expects existing state '"+
                    ats[i].getNextStateName()+"'");
            }
            ats[i].setDestinationState( s );
        }
    }
}

