package org.pietschy.command;

import javax.swing.*;

/**
 * FaceRenderers are used by the libarary to configure buttons and menus.
 */
public interface
FaceRenderer
{
   /**
    * Configures the specified button using the specified {@link RenderContext}.
    *
    * @param button        the button to configure.
    * @param buttonContext the {@link RenderContext} of the button.
    */
   public void configureButton(AbstractButton button, RenderContext buttonContext);

   /**
    * Configures the specified button using the specified {@link RenderContext}.
    *
    * @param menu        the menu to configure.
    * @param menuContext the {@link RenderContext} of the menu.
    */
   public void configureMenu(JMenuItem menu, RenderContext menuContext);
}
