/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: MenuFactory.java,v 1.5 2005/06/10 08:45:45 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;

/**
 * This interface defines factory methods that all commands use when creating menus.
 * @see ButtonFactory
 * @see ToolbarFactory
 * @see DefaultButtonFactory
 * @see CommandManager#setMenuFactory
 */
public interface
MenuFactory
{
   public JMenu createMenu();
   public JMenuItem createMenuItem();
   public JCheckBoxMenuItem createCheckBoxMenuItem();
   public JRadioButtonMenuItem createRadioButtonMenuItem();
   public JPopupMenu createPopupMenu();
   public JMenuBar createMenuBar();
}
