/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tst_action.h"

#include "../../src/action.h"
#include "../../src/slider-parameter.h"

#include <QtTest/QtTest>

void
TestAction::setIdentifier()
{
    Ubuntu::HUD::Action action;

    QSignalSpy spy(&action, SIGNAL(identifierChanged(QString)));
    action.setIdentifier("myid");
    QVERIFY(action.identifier() == "myid");
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == "myid");

    spy.clear();
    action.setIdentifier("myid");
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setLabel()
{
    Ubuntu::HUD::Action action;

    QSignalSpy spy(&action, SIGNAL(labelChanged(QString)));
    action.setLabel("Foo");
    QVERIFY(action.label() == "Foo");
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == "Foo");

    spy.clear();
    action.setLabel("Foo");
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setDescription()
{
    Ubuntu::HUD::Action action;

    QSignalSpy spy(&action, SIGNAL(descriptionChanged(QString)));
    action.setDescription("Lorem Ipsum");
    QVERIFY(action.description() == "Lorem Ipsum");
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == "Lorem Ipsum");

    spy.clear();
    action.setDescription("Lorem Ipsum");
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setKeywords()
{
    Ubuntu::HUD::Action action;
    QString keywords;

    QSignalSpy spy(&action, SIGNAL(keywordsChanged(QString)));

    keywords = "Foo;Bar";

    action.setKeywords(keywords);
    QVERIFY(action.keywords() == keywords);
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == keywords);

    spy.clear();
    action.setKeywords(keywords);
    QCOMPARE(spy.count(), 0);}

void
TestAction::setIsBackgroundAction()
{
    Ubuntu::HUD::Action action;

    action.setIsBackgroundAction(false);
    QSignalSpy spy(&action, SIGNAL(isBackgroundActionChanged(bool)));
    action.setIsBackgroundAction(true);
    QVERIFY(action.isBackgroundAction() == true);
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toBool() == true);

    spy.clear();
    action.setIsBackgroundAction(true);
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setEnabled()
{
    Ubuntu::HUD::Action action;

    action.setEnabled(true);
    QSignalSpy spy(&action, SIGNAL(enabledChanged(bool)));
    action.setEnabled(false);
    QVERIFY(action.enabled() == false);
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toBool() == false);

    spy.clear();
    action.setEnabled(false);
    QCOMPARE(spy.count(), 0);
}

void
TestAction::trigger()
{
    Ubuntu::HUD::Action action;

    QSignalSpy spy(&action, SIGNAL(triggered()));
    action.trigger();
    QCOMPARE(spy.count(), 1);
}

void
TestAction::setCommitLabel()
{
    Ubuntu::HUD::Action action;

    QSignalSpy spy(&action, SIGNAL(commitLabelChanged(QString)));
    action.setCommitLabel("commit_label");
    QVERIFY(action.commitLabel() == "commit_label");
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == "commit_label");

    spy.clear();
    action.setCommitLabel("commit_label");
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setHasLivePreview()
{
    Ubuntu::HUD::Action action;

    action.setHasLivePreview(false);
    QVERIFY(action.hasLivePreview() == false);
    QSignalSpy spy(&action, SIGNAL(hasLivePreviewChanged(bool)));
    action.setHasLivePreview(true);
    QVERIFY(action.hasLivePreview() == true);
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toBool() == true);

    spy.clear();
    action.setHasLivePreview(true);
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setHasNoPreview()
{
    Ubuntu::HUD::Action action;

    action.setHasNoPreview(false);
    QVERIFY(action.hasNoPreview() == false);
    QSignalSpy spy(&action, SIGNAL(hasNoPreviewChanged(bool)));
    action.setHasNoPreview(true);
    QVERIFY(action.hasNoPreview() == true);
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toBool() == true);

    spy.clear();
    action.setHasNoPreview(true);
    QCOMPARE(spy.count(), 0);
}

void
TestAction::setRequiresPreview()
{
    Ubuntu::HUD::Action action;

    action.setRequiresPreview(false);
    QVERIFY(action.requiresPreview() == false);
    QSignalSpy spy(&action, SIGNAL(requiresPreviewChanged(bool)));
    action.setRequiresPreview(true);
    QVERIFY(action.requiresPreview() == true);
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toBool() == true);

    spy.clear();
    action.setRequiresPreview(true);
    QCOMPARE(spy.count(), 0);
}

void
TestAction::parameterOperations()
{
    Ubuntu::HUD::Action action;
    Ubuntu::HUD::SliderParameter param1;
    Ubuntu::HUD::SliderParameter param2;

    QList<Ubuntu::HUD::Parameter *> parameters;

    QSignalSpy params_spy(&action, SIGNAL(parametersChanged()));
    QSignalSpy added_spy(&action, SIGNAL(parameterAdded(Ubuntu::HUD::Parameter*)));
    QSignalSpy removed_spy(&action, SIGNAL(parameterRemoved(Ubuntu::HUD::Parameter*)));

    parameters = action.parameters();
    QVERIFY(parameters.isEmpty());

    action.addParameter(&param1);
    QCOMPARE(params_spy.count(), 1);
    QCOMPARE(added_spy.count(), 1);
    QVERIFY(action.parameters().contains(&param1));

    action.addParameter(&param2);
    QCOMPARE(params_spy.count(), 2);
    QCOMPARE(added_spy.count(), 2);
    QVERIFY(action.parameters().contains(&param2));

    action.removeParameter(&param1);
    QCOMPARE(action.parameters().count(), 1);
    QVERIFY(!action.parameters().contains(&param1));
    QCOMPARE(params_spy.count(), 3);
    QCOMPARE(removed_spy.count(), 1);
}

