/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.amof;

import java.io.Serializable;
import java.math.BigDecimal;

import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 77998 $
 */
public class BigDecimalSimpleValue extends AbstractMetaValue implements SimpleValue
{
   private static final long serialVersionUID = 1L;

   /** The value */
   private BigDecimal value;

   public BigDecimalSimpleValue(BigDecimal value)
   {
      this.value = value;
   }

   public SimpleMetaType getMetaType()
   {
      return SimpleMetaType.BIGDECIMAL;
   }

   public Serializable getValue()
   {
      return value;
   }

}
