/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.deployment;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractInstanceClassFactory;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class JmsDestinationICF extends AbstractInstanceClassFactory<JmsDestination>
{

   public JmsDestinationICF()
   {
      super();
   }
   public JmsDestinationICF(ManagedObjectFactory mof)
   {
      super(mof);
   }

   public Class<JmsDestination> getType()
   {
      return JmsDestination.class;
   }
   @Override
   public void setValue(BeanInfo beanInfo, ManagedProperty property,
         JmsDestination object, MetaValue value)
   {
      if(property.getName().equals("domain"))
      {
         GenericValue gv = (GenericValue) value;
         ManagedObject mo = (ManagedObject) gv.getValue();
         // Create the correct type of 
         ManagedProperty type = mo.getProperty("securityDeploymentType");
         ManagedProperty domain = mo.getProperty("domain");
         String domainName = ((SimpleValue) domain.getValue()).getValue().toString();
         EnumValue typeValue = (EnumValue) type.getValue();
         String typeString = typeValue.getValue();
         SecurityDeploymentType stype = SecurityDeploymentType.valueOf(typeString);
         SecDomainMD domainMD = null;
         switch(stype)
         {
         case APPLICATION:
            domainMD = new SecurityDomainApplicationManagedMetaData();
            break;
         case DOMAIN:
            domainMD = new SecurityDomain();
            break;
         default:
         case NONE:
            break;
         }
         domainMD.setDomain(domainName);
         object.setDomain(domainMD);
      }
      else
      {
         super.setValue(beanInfo, property, object, value);
      }
   }

}
