/* vi:set ts=4 sw=4 expandtab:
 *
 * Copyright 2016, Chris Leishman (http://github.com/cleishm)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "../../config.h"
#include "colorization.h"


static struct error_colorization _no_error_colorization =
    { .def = { "", "" },
      .pos = { "", "" },
      .msg = { "", "" },
      .ctx = { "", "" } };

static struct error_colorization _ansi_error_colorization =
    { .def = { ANSI_COLOR_RED ANSI_COLOR_BOLD, ANSI_COLOR_RESET },
      .pos = { ANSI_COLOR_BOLD, ANSI_COLOR_RESET },
      .msg = { ANSI_COLOR_RESET, "" },
      .ctx = { ANSI_COLOR_BOLD, ANSI_COLOR_RESET } };

const struct error_colorization *no_error_colorization =
        &_no_error_colorization;
const struct error_colorization *ansi_error_colorization =
        &_ansi_error_colorization;
