/*
 * $Id: VisitorGraph.java,v 1.2 2006/07/17 20:22:40 larry Exp $ 
 */
package com.representqueens.spark;

/*
 * 
 * Copyright 2006 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import javax.imageio.ImageIO;

import com.representqueens.util.StringUtils;

/**
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.2 $ $Date: 2006/07/17 20:22:40 $
 */
public final class VisitorGraph
{

  /**
   * @param args
   */
  public static void main(final String[] args) throws IOException
  {
    final BufferedReader br = new BufferedReader(new FileReader(args[0]));
    
    final Number[] data =
      StringUtils.toIntList(br.readLine(), "\\s+").toArray(new Number[0]);
    
    final BufferedImage i =
      BarGraph.createGraph(data, BarGraph.DEFAULT_SIZE,
                           BarGraph.DEFAULT_COLOR,
                           BarGraph.DEFAULT_HIGH_COLOR,
                           BarGraph.DEFAULT_LAST_COLOR);
    
    final File out = new File(args[2]);
    
    if (out.exists())
    {
      out.delete();
    }
    
    ImageIO.write(i, "png", out);
  }
}
