/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking.ws;

import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/** A logical organization of dockables. Used to define and save desktop layouts (xml loading in not supported yet).
 *<p>
 * A Workspace is composed of WSDesktop elements (one per involved desktop).
 * <p>
 * Each WSDesktop supports an API similar to the DockingDesktop (addDockable, split, createTab), where
 * arguments are simple DockKeys (and not Dockables).
 *
 * <p> Currently this version doesn't support dockable removal : you can create a workspace, but shouldn't alter its
 * layout by moving already positionned dockables elsewhere (e.g. workspace will fail if you install a dockable
 * on an auto-hide border, then add is as a docked tab later).
 *
 *
 * @author Lilian Chamontin, VLSolutions
 * @since 2.1.2
 */
public class Workspace {
  private ArrayList desktops = new ArrayList();
  
  /** Creates a workspace with a single default WSDesktop */
  public Workspace() {
    desktops.add(new WSDesktop());
  }
  
  /** Removes the contained desktops */
  public void clear(){
    desktops.clear();
  }
  
  /** Adds a new desktop to this workspace */
  public void addDesktop(WSDesktop desktop){
    desktops.add(desktop);
  }
  
  /** Return the number of desktops contained in this workspace (default is 1 ) */
  public int getDesktopCount(){
    return desktops.size();
  }
  
  /** Returns the index-th desktop contained */
  public WSDesktop getDesktop(int index){
    return (WSDesktop) desktops.get(index);
  }
  
  /** Returns a desktop identified by its name or null if not found */
  public WSDesktop getDesktop(String desktopName){
    if (desktops.size() == 1){
      return (WSDesktop) desktops.get(0);
    }
    for (int i=0; i < desktops.size(); i++){
      WSDesktop d = (WSDesktop) desktops.get(i);
      if (d.getDesktopName().equals(desktopName) ){
        return d;
      }
    }
    return null;
  }
  
  
  /** Applies this workspace to the given docking context (this is equivalent as loading a
   * workspace file from DockingContext.readXML() : it removes every dockable from the context and
   * associated desktops, and clears their dockable states, then it reloads the dockables as specified
   * by this workspace layout.
   */
  public void apply(DockingContext dockingContext) throws WorkspaceException {
    ByteArrayOutputStream outb = new ByteArrayOutputStream();
    PrintWriter out = new PrintWriter(outb);
    out.println("<?xml version=\"1.0\"?>");
    out.println("<VLDocking version=\"2.1\">");
    for (int i=0; i < desktops.size(); i++){
      WSDesktop desktop = (WSDesktop) desktops.get(i);
      desktop.writeDesktopNode(out);
    }
    out.println("</VLDocking>");
    out.close();
    byte [] bytes = outb.toByteArray();
    //System.out.println(new String(bytes));
    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
    try {
      dockingContext.readXML(is);
    } catch (Exception ex) {
      throw new WorkspaceException(ex);
    } finally {
      try {
        is.close();
      } catch (Exception ignore) {
      }
    }
  }
  
  /** Loads and configures this workspace from a given docking context.
   *<p>
   * The workspace is then ready to be applied or saved as a stream.
   * @since 2.1.3
   * @see #apply(DockingContext)
   */
  public void loadFrom(DockingContext context) throws WorkspaceException{    
    try {
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      context.writeXML(out);
      out.close();
      byte [] bytes = out.toByteArray();
      //System.out.println(new String(bytes));
      ByteArrayInputStream is = new ByteArrayInputStream(bytes);
      readXML(is);
      is.close();
    } catch (Exception e){
      throw new WorkspaceException(e);
    }
  }
  
  /** Saves the workspace layout into an XML stream.
   * <p>
   * The workspace is composed of every desktop layouts associated
   * with this workspace (desktops are identified by their 'desktopName' property).
   *
   * <p>
   * The stream is not closed at the end of the operation.
   *
   * @see #readXML(InputStream)
   * */
  public void writeXML(OutputStream stream) throws IOException {
    PrintWriter out = new PrintWriter(stream);
    out.println("<?xml version=\"1.0\"?>");
    out.println("<VLDocking version=\"2.1\">");
    for (int i=0; i < desktops.size(); i++){
      WSDesktop desktop = (WSDesktop) desktops.get(i);
      desktop.writeDesktopNode(out);
    }
    out.println("</VLDocking>");
    
    out.flush();
  }
  
  public void readXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
  
    // remove all dockable states
    
    for (int i=0; i < desktops.size(); i++){
      WSDesktop desk = (WSDesktop) desktops.get(i);
      desk.clear();
    }
    
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = factory.newDocumentBuilder();
    Document doc = builder.parse(in);
    Element root = doc.getDocumentElement();
    if (root.getNodeName().equals("DockingDesktop")){
      // this is an old desktop file, missing the VLDocking root node (VLDocking 2.0 format)
      // so we noly have a single desktop
      WSDesktop desk = getDesktop(0); // only one
      desk.readDesktopNode(root);
    } else {
      NodeList desktopChildren = root.getChildNodes();
      for (int i = 0, len = desktopChildren.getLength(); i < len; i++) {
        Node node = desktopChildren.item(i);
        if (node instanceof Element){
          Element deskChild = (Element) node;
          WSDesktop desk = getDesktop(deskChild.getAttribute("name"));
          desk.readDesktopNode(deskChild);
        }
      }
    }
    
  }
  
  
  
}
