/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleBooleanExpr;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleNumberExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ConvertibleVariantExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function1;
import com.jclark.xsl.expr.GlobalVariableRefExpr;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.ResultFragmentVariant;

class ObjectTypeFunction
extends Function1 {
    ObjectTypeFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr e) throws ParseException {
        LiteralExpr objType = new LiteralExpr("string");
        if (e instanceof ConvertibleVariantExpr) {
            final ConvertibleVariantExpr ve = e.makeVariantExpr();
            final Name varName = e instanceof GlobalVariableRefExpr ? ((GlobalVariableRefExpr)e).getName() : null;
            return new ConvertibleStringExpr(){

                public String eval(Node node, ExprContext context) throws XSLException {
                    if (varName != null && varName.getNamespace() != null && context.getExtensionContext(varName.getNamespace()).available(varName.getLocalPart())) {
                        return "external";
                    }
                    Variant v = ve.eval(node, context);
                    if (v.isBoolean()) {
                        return "boolean";
                    }
                    if (v.isNumber()) {
                        return "number";
                    }
                    if (v.isString()) {
                        return "string";
                    }
                    if (v.isNodeSet()) {
                        return "node-set";
                    }
                    if (v instanceof ResultFragmentVariant) {
                        return "RTF";
                    }
                    return "unknown";
                }
            };
        }
        if (e instanceof ConvertibleNumberExpr) {
            objType = new LiteralExpr("number");
        } else if (e instanceof ConvertibleBooleanExpr) {
            objType = new LiteralExpr("boolean");
        } else if (e instanceof ConvertibleNodeSetExpr) {
            objType = new LiteralExpr("boolean");
        } else if (e instanceof ConvertibleStringExpr) {
            objType = new LiteralExpr("string");
        }
        return objType;
    }
}

