/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleBooleanExpr;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexpTestFunction
implements Function {
    RegexpTestFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length < 2 || args.length > 3) {
            throw new ParseException("expected 2 or 3 arguments");
        }
        final ConvertibleStringExpr se = args[0].makeStringExpr();
        final ConvertibleStringExpr se2 = args[1].makeStringExpr();
        final ConvertibleStringExpr se3 = args.length == 2 ? new LiteralExpr("") : args[2].makeStringExpr();
        return new ConvertibleBooleanExpr(){

            public boolean eval(Node node, ExprContext context) throws XSLException {
                return RegexpTestFunction.test(se.eval(node, context), se2.eval(node, context), se3.eval(node, context));
            }
        };
    }

    private static final boolean test(String src, String pattern, String flags) {
        boolean ignoreCase = false;
        if (flags.length() > 0) {
            ignoreCase = flags.indexOf("i") >= 0;
        }
        try {
            Pattern pat = ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
            return pat.matcher(src).matches();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }
}

