<div align="center"><img src="https://magit.vc/assets/magit-168x200px.png"/></div>
<h2 align="center">A Git Porcelain inside Emacs</h2>
<p align="center">
  <a href="https://magit.vc"><b>homepage</b></a> |
  <a href="https://magit.vc/manual"><b>manual</b></a> |
  <a href="https://magit.vc/manual/magit/FAQ.html"><b>faq</b></a> |
  <a href="https://github.com/magit/magit/wiki"><b>wiki</b></a> |
  <a href="https://groups.google.com/forum/?fromgroups#!forum/magit"><b>mailing list</b></a> |
  <a href="https://emacs.stackexchange.com/questions/tagged/magit"><b>forum</b></a> |
  <a href="https://gitter.im/magit/magit"><b>chat</b></a> |
  <a href="https://twitter.com/magit_emacs"><b>news</b></a>
</p>
***

<p align="justify">
  Magit is an interface to the version control system
  <a href="https://git-scm.com">Git</a>, implemented as an
  <a href="https://www.gnu.org/software/emacs">Emacs</a> package.
  Magit aspires to be a complete Git porcelain.  While we cannot
  (yet) claim that Magit wraps and improves upon each and every Git
  command, it is complete enough to allow even experienced Git users
  to perform almost all of their daily version control tasks directly
  from within Emacs.  While many fine Git clients exist, only Magit
  and Git itself deserve to be called porcelains.
  <a href="https://magit.vc/about">(more)</a>
</p>
***

<div align="center">
  Keeping its user <a href= "https://magit.vc/quotes">this excited</a> is
  <a href="https://magit.vc/stats/authors.html#cumulated_added_lines_of_code_per_author">
    a lot of work
  </a>.
  If Magit makes you <br> more productive too,
  then <b>please consider making a donation</b>.
</div>
<div align="center">
  <em>Thank you! &mdash; Jonas Bernoulli</em>
</div>
<br>
<div align="center">
  <a href="https://www.paypal.me/JonasBernoulli/20">
    <img title="Donate using PayPal"
         alt="Donate using PayPal"
		 style="height: 50px; width: auto;"
         src="https://magit.vc/assets/paypal.png"></a>
  &nbsp;&nbsp;
  <a href="https://www.patreon.com/tarsius">
    <img title="Donate monthly using Patreon"
         alt="Donate monthly using Patreon"
		 style="height: 50px; width: auto;"
         src="https://magit.vc/assets/patreon-50px.png"></a>
  &nbsp;&nbsp;
  <a href="https://salt.bountysource.com/teams/magit">
    <img title="Donate monthly using Bountysource"
         alt="Donate monthly using Bountysource"
		 style="height: 50px; width: auto;"
         src="https://magit.vc/assets/bountysource-50px.png"></a>
</div>
<br>
<div align="center">
  Some alternative donation methods are <a href="/donate">available</a>.
</div>
***

Support
=======

When something doesn't work as expected then please first see the
[FAQ][faq].  Then also try the list of [open issues][issues] and use
the search box at the top of that page to find older related issues.
You should also consult the [manual][manual] and ask a general-purpose
search engine.

If that doesn't answer your question, then ask for help on the
**[Emacs Stackexchange site][forum]**, the [mailing list][list], or
the [Gitter chat][chat].  We only use the GitHub issue tracker for
feature requests and bug reports, so please don't ask for help there.

Contributing
============

To report bugs and suggest new feature use the
[issue tracker][issues].  If you have some code which you would like
to be merged, then open a [pull request][pulls]. Please also see
[CONTRIBUTING.md][contrib].

Acknowledgments
===============

Magit was started by [Marius Vollmer][marius], and is now maintained
by [Jonas Bernoulli][jonas], [Kyle Meyer][kyle], and
[Noam Postavsky][noam].  Other former maintainers are
[Nicolas Dudebout][nicolas], [Peter J. Weisberg][peter],
[Phil Jackson][phil], [Rémi Vanicat][remi], and [Yann Hodique][yann].
Many more people have [contributed code][authors] and suggested
features.

Thanks to all of you, may (the history of) the source be with you!

***
[![Build Status](https://travis-ci.org/magit/magit.svg?branch=master)](https://travis-ci.org/magit/magit)

[contrib]: https://github.com/magit/magit/blob/master/CONTRIBUTING.md
[issues]:  https://github.com/magit/magit/issues
[pulls]:   https://github.com/magit/magit/pulls

[authors]: https://magit.vc/stats/authors.html
[faq]:     https://magit.vc/manual/magit/FAQ.html
[manual]:  https://magit.vc/manual

[chat]:    https://gitter.im/magit/magit
[forum]:   https://emacs.stackexchange.com/questions/tagged/magit
[list]:    https://groups.google.com/forum/?fromgroups#!forum/magit

[jonas]:   https://emacsair.me
[kyle]:    https://github.com/kyleam
[marius]:  https://github.com/mvollmer
[nicolas]: http://dudebout.com
[noam]:    https://github.com/npostavs
[peter]:   https://github.com/pjweisberg
[phil]:    https://github.com/philjackson
[remi]:    https://github.com/vanicat
[yann]:    http://www.hodique.info
