include "logic/equality.ma".

(* Inclusion of: LAT010-1.p *)

(* -------------------------------------------------------------------------- *)

(*  File     : LAT010-1 : TPTP v3.7.0. Released v2.2.0. *)

(*  Domain   : Lattice Theory *)

(*  Problem  : McKenzie's basis for the variety generated by N5. *)

(*  Version  : [MP96] (equality) axioms : Especial. *)

(*  English  : McKenzie's basis for the variety generated by N5. *)

(*  Refs     : [McC98] McCune (1998), Email to G. Sutcliffe *)

(*           : [MP96]  McCune & Padmanabhan (1996), Automated Deduction in Eq *)

(*  Source   : [McC98] *)

(*  Names    : LT-6 [MP96] *)

(*  Status   : Unsatisfiable *)

(*  Rating   : 0.11 v3.4.0, 0.12 v3.3.0, 0.07 v3.2.0, 0.00 v2.5.0, 0.25 v2.4.0, 0.00 v2.2.1 *)

(*  Syntax   : Number of clauses     :   12 (   0 non-Horn;  12 unit;   1 RR) *)

(*             Number of atoms       :   12 (  12 equality) *)

(*             Maximal clause size   :    1 (   1 average) *)

(*             Number of predicates  :    1 (   0 propositional; 2-2 arity) *)

(*             Number of functors    :    6 (   4 constant; 0-2 arity) *)

(*             Number of variables   :   27 (   2 singleton) *)

(*             Maximal term depth    :    6 (   3 average) *)

(*  Comments : *)

(* -------------------------------------------------------------------------- *)

(* ----Include lattice axioms *)

(* Inclusion of: Axioms/LAT001-0.ax *)

(* -------------------------------------------------------------------------- *)

(*  File     : LAT001-0 : TPTP v3.7.0. Released v1.0.0. *)

(*  Domain   : Lattice Theory *)

(*  Axioms   : Lattice theory (equality) axioms *)

(*  Version  : [McC88] (equality) axioms. *)

(*  English  :  *)

(*  Refs     : [Bum65] Bumcroft (1965), Proceedings of the Glasgow Mathematic *)

(*           : [McC88] McCune (1988), Challenge Equality Problems in Lattice  *)

(*           : [Wos88] Wos (1988), Automated Reasoning - 33 Basic Research Pr *)

(*  Source   : [McC88] *)

(*  Names    :  *)

(*  Status   :  *)

(*  Syntax   : Number of clauses    :    8 (   0 non-Horn;   8 unit;   0 RR) *)

(*             Number of atoms      :    8 (   8 equality) *)

(*             Maximal clause size  :    1 (   1 average) *)

(*             Number of predicates :    1 (   0 propositional; 2-2 arity) *)

(*             Number of functors   :    2 (   0 constant; 2-2 arity) *)

(*             Number of variables  :   16 (   2 singleton) *)

(*             Maximal term depth   :    3 (   2 average) *)

(*  Comments :  *)

(* -------------------------------------------------------------------------- *)

(* ----The following 8 clauses characterise lattices  *)

(* -------------------------------------------------------------------------- *)

(* -------------------------------------------------------------------------- *)

(* ----Hypotheses: *)

(* ----Denial of the conclusion: *)
ntheorem prove_this:
 (∀Univ:Type.∀U:Univ.∀X:Univ.∀Y:Univ.∀Z:Univ.
∀a:Univ.
∀b:Univ.
∀c:Univ.
∀d:Univ.
∀join:∀_:Univ.∀_:Univ.Univ.
∀meet:∀_:Univ.∀_:Univ.Univ.
∀H0:∀X:Univ.∀Y:Univ.∀Z:Univ.eq Univ (meet (join X (meet Y Z)) (join Z (meet X Y))) (join (meet Z (join X (meet Y Z))) (meet X (join Y Z))).
∀H1:∀U:Univ.∀X:Univ.∀Y:Univ.∀Z:Univ.eq Univ (join X (meet Y (join Z (meet X U)))) (meet (join X (meet Y (join X Z))) (join X (meet (join X Y) (join Z U)))).
∀H2:∀U:Univ.∀X:Univ.∀Y:Univ.∀Z:Univ.eq Univ (meet X (join Y (meet Z (join X U)))) (join (meet X (join Y (meet X Z))) (meet X (join (meet X Y) (meet Z U)))).
∀H3:∀X:Univ.∀Y:Univ.∀Z:Univ.eq Univ (join (join X Y) Z) (join X (join Y Z)).
∀H4:∀X:Univ.∀Y:Univ.∀Z:Univ.eq Univ (meet (meet X Y) Z) (meet X (meet Y Z)).
∀H5:∀X:Univ.∀Y:Univ.eq Univ (join X Y) (join Y X).
∀H6:∀X:Univ.∀Y:Univ.eq Univ (meet X Y) (meet Y X).
∀H7:∀X:Univ.∀Y:Univ.eq Univ (join X (meet X Y)) X.
∀H8:∀X:Univ.∀Y:Univ.eq Univ (meet X (join X Y)) X.
∀H9:∀X:Univ.eq Univ (join X X) X.
∀H10:∀X:Univ.eq Univ (meet X X) X.eq Univ (meet a (meet (join b c) (join b d))) (meet (meet a (meet (join b c) (join b d))) (join (meet a (join b (meet c d))) (join (meet a c) (meet a d)))))
.
#Univ ##.
#U ##.
#X ##.
#Y ##.
#Z ##.
#a ##.
#b ##.
#c ##.
#d ##.
#join ##.
#meet ##.
#H0 ##.
#H1 ##.
#H2 ##.
#H3 ##.
#H4 ##.
#H5 ##.
#H6 ##.
#H7 ##.
#H8 ##.
#H9 ##.
#H10 ##.
nauto by H0,H1,H2,H3,H4,H5,H6,H7,H8,H9,H10 ##;
ntry (nassumption) ##;
nqed.

(* -------------------------------------------------------------------------- *)
