*
* $Id: fxnlla.F,v 1.1.1.3 1996/11/15 17:32:48 cernlib Exp $
*
* $Log: fxnlla.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:48  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:07:13  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:20  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXNLLA(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.1154E-01,0.1220E-01,0.1289E-01,0.1363E-01,0.1440E-01,0.1522E-01,
     +0.1609E-01,0.1701E-01,0.1798E-01,0.1901E-01,0.2009E-01,0.2123E-01,
     +0.2245E-01,0.2372E-01,0.2508E-01,0.2651E-01,0.2802E-01,0.2961E-01,
     +0.3130E-01,0.3308E-01,0.3497E-01,0.3696E-01,0.3906E-01,0.4129E-01,
     +0.4364E-01,0.4612E-01,0.4874E-01,0.5151E-01,0.5444E-01,0.5753E-01,
     +0.6080E-01,0.6425E-01,0.6790E-01,0.7175E-01,0.7581E-01,0.8010E-01,
     +0.8463E-01,0.8942E-01,0.9447E-01,0.9979E-01,0.1054E+00,0.1113E+00,
     +0.1176E+00,0.1242E+00,0.1311E+00,0.1384E+00,0.1462E+00,0.1543E+00,
     +0.1628E+00,0.1718E+00,0.1812E+00,0.1912E+00,0.2016E+00,0.2125E+00,
     +0.2239E+00,0.2359E+00,0.2484E+00,0.2615E+00,0.2751E+00,0.2893E+00,
     +0.3040E+00,0.3193E+00,0.3351E+00,0.3513E+00,0.3680E+00,0.3850E+00,
     +0.4023E+00,0.4198E+00,0.4374E+00,0.4548E+00,0.4720E+00,0.4887E+00,
     +0.5046E+00,0.5194E+00,0.5327E+00,0.5441E+00,0.5531E+00,0.5592E+00,
     +0.5618E+00,0.5603E+00,0.5539E+00,0.5422E+00,0.5244E+00,0.5003E+00,
     +0.4694E+00,0.4319E+00,0.3881E+00,0.3391E+00,0.2861E+00,0.2312E+00,
     +0.1983E+00,0.1680E+00,0.1404E+00,0.1157E+00,0.9372E-01,0.7443E-01,
     +0.5769E-01,0.4337E-01,0.3133E-01,0.2144E-01,0.1356E-01,0.7619E-02,
     +0.3495E-02,0.1056E-02/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.6588E-02,0.6963E-02,0.7360E-02,0.7780E-02,0.8224E-02,0.8693E-02,
     +0.9188E-02,0.9712E-02,0.1027E-01,0.1085E-01,0.1147E-01,0.1212E-01,
     +0.1281E-01,0.1354E-01,0.1432E-01,0.1513E-01,0.1599E-01,0.1690E-01,
     +0.1787E-01,0.1888E-01,0.1996E-01,0.2109E-01,0.2229E-01,0.2356E-01,
     +0.2490E-01,0.2632E-01,0.2781E-01,0.2939E-01,0.3106E-01,0.3282E-01,
     +0.3468E-01,0.3664E-01,0.3872E-01,0.4091E-01,0.4322E-01,0.4565E-01,
     +0.4823E-01,0.5094E-01,0.5380E-01,0.5682E-01,0.6000E-01,0.6335E-01,
     +0.6689E-01,0.7061E-01,0.7452E-01,0.7864E-01,0.8297E-01,0.8752E-01,
     +0.9230E-01,0.9731E-01,0.1026E+00,0.1081E+00,0.1138E+00,0.1199E+00,
     +0.1262E+00,0.1327E+00,0.1395E+00,0.1466E+00,0.1539E+00,0.1615E+00,
     +0.1693E+00,0.1773E+00,0.1855E+00,0.1938E+00,0.2022E+00,0.2107E+00,
     +0.2191E+00,0.2274E+00,0.2355E+00,0.2433E+00,0.2507E+00,0.2574E+00,
     +0.2633E+00,0.2682E+00,0.2719E+00,0.2742E+00,0.2747E+00,0.2732E+00,
     +0.2694E+00,0.2631E+00,0.2540E+00,0.2419E+00,0.2269E+00,0.2089E+00,
     +0.1882E+00,0.1651E+00,0.1404E+00,0.1149E+00,0.8971E-01,0.6601E-01,
     +0.5297E-01,0.4179E-01,0.3236E-01,0.2454E-01,0.1816E-01,0.1305E-01,
     +0.9059E-02,0.6015E-02,0.3770E-02,0.2185E-02,0.1134E-02,0.4971E-03,
     +0.1639E-03,0.3018E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.7804E+01,0.7693E+01,0.7584E+01,0.7477E+01,0.7371E+01,0.7267E+01,
     +0.7165E+01,0.7065E+01,0.6966E+01,0.6869E+01,0.6774E+01,0.6680E+01,
     +0.6588E+01,0.6498E+01,0.6410E+01,0.6323E+01,0.6238E+01,0.6154E+01,
     +0.6073E+01,0.5993E+01,0.5914E+01,0.5838E+01,0.5763E+01,0.5690E+01,
     +0.5618E+01,0.5549E+01,0.5481E+01,0.5414E+01,0.5350E+01,0.5287E+01,
     +0.5225E+01,0.5166E+01,0.5108E+01,0.5052E+01,0.4997E+01,0.4944E+01,
     +0.4892E+01,0.4842E+01,0.4794E+01,0.4746E+01,0.4700E+01,0.4655E+01,
     +0.4612E+01,0.4568E+01,0.4526E+01,0.4484E+01,0.4443E+01,0.4401E+01,
     +0.4359E+01,0.4317E+01,0.4274E+01,0.4230E+01,0.4184E+01,0.4136E+01,
     +0.4085E+01,0.4032E+01,0.3975E+01,0.3914E+01,0.3849E+01,0.3778E+01,
     +0.3702E+01,0.3620E+01,0.3530E+01,0.3434E+01,0.3331E+01,0.3219E+01,
     +0.3099E+01,0.2971E+01,0.2834E+01,0.2689E+01,0.2537E+01,0.2377E+01,
     +0.2211E+01,0.2040E+01,0.1864E+01,0.1686E+01,0.1507E+01,0.1330E+01,
     +0.1156E+01,0.9884E+00,0.8287E+00,0.6796E+00,0.5433E+00,0.4215E+00,
     +0.3157E+00,0.2267E+00,0.1548E+00,0.9926E-01,0.5884E-01,0.3151E-01,
     +0.2032E-01,0.1274E-01,0.7732E-02,0.4513E-02,0.2516E-02,0.1326E-02,
     +0.6529E-03,0.2949E-03,0.1192E-03,0.4151E-04,0.1172E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6997E+00,0.6997E+00,0.6994E+00,0.6995E+00,0.6994E+00,0.6992E+00,
     +0.6991E+00,0.6990E+00,0.6989E+00,0.6988E+00,0.6987E+00,0.6986E+00,
     +0.6984E+00,0.6982E+00,0.6980E+00,0.6979E+00,0.6976E+00,0.6974E+00,
     +0.6971E+00,0.6968E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6912E+00,
     +0.6902E+00,0.6891E+00,0.6880E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6819E+00,0.6799E+00,0.6778E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5134E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3373E-04,0.1183E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2913E+00,
     +0.2913E+00,0.2913E+00,0.2912E+00,0.2911E+00,0.2911E+00,0.2911E+00,
     +0.2910E+00,0.2909E+00,0.2908E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2903E+00,0.2902E+00,0.2900E+00,0.2899E+00,0.2897E+00,
     +0.2894E+00,0.2892E+00,0.2889E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1670E-02,
     +0.1016E-02,0.5893E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1406E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1295E-03,0.6680E-04,0.3207E-04,0.1413E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.1271E-01,0.1343E-01,0.1419E-01,0.1500E-01,0.1585E-01,0.1675E-01,
     +0.1770E-01,0.1871E-01,0.1977E-01,0.2089E-01,0.2207E-01,0.2332E-01,
     +0.2464E-01,0.2604E-01,0.2751E-01,0.2907E-01,0.3072E-01,0.3246E-01,
     +0.3429E-01,0.3623E-01,0.3828E-01,0.4044E-01,0.4273E-01,0.4514E-01,
     +0.4768E-01,0.5037E-01,0.5321E-01,0.5621E-01,0.5937E-01,0.6271E-01,
     +0.6623E-01,0.6995E-01,0.7387E-01,0.7801E-01,0.8237E-01,0.8698E-01,
     +0.9183E-01,0.9695E-01,0.1023E+00,0.1080E+00,0.1140E+00,0.1203E+00,
     +0.1270E+00,0.1339E+00,0.1413E+00,0.1490E+00,0.1571E+00,0.1657E+00,
     +0.1746E+00,0.1840E+00,0.1939E+00,0.2042E+00,0.2150E+00,0.2263E+00,
     +0.2381E+00,0.2503E+00,0.2631E+00,0.2764E+00,0.2902E+00,0.3045E+00,
     +0.3193E+00,0.3345E+00,0.3501E+00,0.3660E+00,0.3822E+00,0.3986E+00,
     +0.4152E+00,0.4317E+00,0.4480E+00,0.4640E+00,0.4794E+00,0.4940E+00,
     +0.5075E+00,0.5195E+00,0.5297E+00,0.5377E+00,0.5430E+00,0.5450E+00,
     +0.5433E+00,0.5373E+00,0.5264E+00,0.5102E+00,0.4883E+00,0.4604E+00,
     +0.4266E+00,0.3871E+00,0.3427E+00,0.2944E+00,0.2438E+00,0.1930E+00,
     +0.1631E+00,0.1362E+00,0.1121E+00,0.9081E-01,0.7225E-01,0.5625E-01,
     +0.4265E-01,0.3126E-01,0.2193E-01,0.1449E-01,0.8783E-02,0.4670E-02,
     +0.1987E-02,0.5329E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.7252E-02,0.7664E-02,0.8099E-02,0.8558E-02,0.9044E-02,0.9557E-02,
     +0.1010E-01,0.1067E-01,0.1128E-01,0.1191E-01,0.1259E-01,0.1330E-01,
     +0.1406E-01,0.1485E-01,0.1569E-01,0.1658E-01,0.1752E-01,0.1851E-01,
     +0.1955E-01,0.2066E-01,0.2182E-01,0.2305E-01,0.2435E-01,0.2572E-01,
     +0.2717E-01,0.2870E-01,0.3031E-01,0.3202E-01,0.3381E-01,0.3571E-01,
     +0.3771E-01,0.3982E-01,0.4204E-01,0.4439E-01,0.4686E-01,0.4946E-01,
     +0.5221E-01,0.5510E-01,0.5815E-01,0.6135E-01,0.6472E-01,0.6827E-01,
     +0.7200E-01,0.7592E-01,0.8003E-01,0.8435E-01,0.8889E-01,0.9364E-01,
     +0.9861E-01,0.1038E+00,0.1093E+00,0.1149E+00,0.1208E+00,0.1270E+00,
     +0.1334E+00,0.1401E+00,0.1469E+00,0.1540E+00,0.1613E+00,0.1688E+00,
     +0.1765E+00,0.1843E+00,0.1923E+00,0.2002E+00,0.2082E+00,0.2161E+00,
     +0.2239E+00,0.2315E+00,0.2387E+00,0.2454E+00,0.2516E+00,0.2569E+00,
     +0.2613E+00,0.2646E+00,0.2665E+00,0.2668E+00,0.2653E+00,0.2617E+00,
     +0.2559E+00,0.2475E+00,0.2365E+00,0.2229E+00,0.2065E+00,0.1877E+00,
     +0.1667E+00,0.1441E+00,0.1205E+00,0.9679E-01,0.7402E-01,0.5320E-01,
     +0.4202E-01,0.3261E-01,0.2482E-01,0.1847E-01,0.1340E-01,0.9429E-02,
     +0.6388E-02,0.4127E-02,0.2507E-02,0.1400E-02,0.6946E-03,0.2874E-03,
     +0.8759E-04,0.1426E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.1728E+02,0.1694E+02,0.1661E+02,0.1628E+02,0.1596E+02,0.1564E+02,
     +0.1533E+02,0.1503E+02,0.1472E+02,0.1443E+02,0.1414E+02,0.1385E+02,
     +0.1357E+02,0.1329E+02,0.1302E+02,0.1275E+02,0.1249E+02,0.1223E+02,
     +0.1198E+02,0.1173E+02,0.1149E+02,0.1125E+02,0.1101E+02,0.1078E+02,
     +0.1055E+02,0.1033E+02,0.1011E+02,0.9891E+01,0.9679E+01,0.9471E+01,
     +0.9266E+01,0.9066E+01,0.8868E+01,0.8675E+01,0.8484E+01,0.8297E+01,
     +0.8114E+01,0.7933E+01,0.7755E+01,0.7581E+01,0.7409E+01,0.7239E+01,
     +0.7073E+01,0.6908E+01,0.6745E+01,0.6585E+01,0.6426E+01,0.6268E+01,
     +0.6112E+01,0.5957E+01,0.5802E+01,0.5648E+01,0.5494E+01,0.5340E+01,
     +0.5185E+01,0.5029E+01,0.4872E+01,0.4713E+01,0.4553E+01,0.4390E+01,
     +0.4225E+01,0.4057E+01,0.3886E+01,0.3712E+01,0.3535E+01,0.3355E+01,
     +0.3172E+01,0.2986E+01,0.2797E+01,0.2607E+01,0.2415E+01,0.2222E+01,
     +0.2030E+01,0.1840E+01,0.1652E+01,0.1468E+01,0.1289E+01,0.1118E+01,
     +0.9556E+00,0.8032E+00,0.6626E+00,0.5349E+00,0.4212E+00,0.3221E+00,
     +0.2382E+00,0.1691E+00,0.1143E+00,0.7269E-01,0.4280E-01,0.2269E-01,
     +0.1441E-01,0.8739E-02,0.4911E-02,0.2378E-02,0.7454E-03,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.2156E+01,0.2119E+01,0.2083E+01,0.2047E+01,0.2013E+01,0.1978E+01,
     +0.1944E+01,0.1911E+01,0.1879E+01,0.1847E+01,0.1815E+01,0.1784E+01,
     +0.1754E+01,0.1724E+01,0.1695E+01,0.1666E+01,0.1638E+01,0.1610E+01,
     +0.1583E+01,0.1556E+01,0.1530E+01,0.1504E+01,0.1478E+01,0.1453E+01,
     +0.1429E+01,0.1404E+01,0.1381E+01,0.1357E+01,0.1334E+01,0.1311E+01,
     +0.1289E+01,0.1267E+01,0.1245E+01,0.1224E+01,0.1203E+01,0.1182E+01,
     +0.1161E+01,0.1141E+01,0.1121E+01,0.1100E+01,0.1080E+01,0.1061E+01,
     +0.1041E+01,0.1021E+01,0.1001E+01,0.9817E+00,0.9618E+00,0.9418E+00,
     +0.9217E+00,0.9013E+00,0.8807E+00,0.8598E+00,0.8384E+00,0.8167E+00,
     +0.7944E+00,0.7716E+00,0.7482E+00,0.7242E+00,0.6994E+00,0.6740E+00,
     +0.6478E+00,0.6209E+00,0.5932E+00,0.5647E+00,0.5356E+00,0.5059E+00,
     +0.4756E+00,0.4449E+00,0.4139E+00,0.3829E+00,0.3520E+00,0.3214E+00,
     +0.2914E+00,0.2622E+00,0.2341E+00,0.2073E+00,0.1820E+00,0.1583E+00,
     +0.1363E+00,0.1160E+00,0.9740E-01,0.8050E-01,0.6519E-01,0.5143E-01,
     +0.3922E-01,0.2863E-01,0.1974E-01,0.1266E-01,0.7407E-02,0.3877E-02,
     +0.2472E-02,0.1552E-02,0.9683E-03,0.6065E-03,0.3858E-03,0.2508E-03,
     +0.1660E-03,0.1102E-03,0.7152E-04,0.4398E-04,0.2459E-04,0.1174E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.6237E+00,0.6154E+00,0.6071E+00,0.5990E+00,0.5911E+00,0.5832E+00,
     +0.5755E+00,0.5680E+00,0.5605E+00,0.5532E+00,0.5461E+00,0.5390E+00,
     +0.5321E+00,0.5253E+00,0.5186E+00,0.5120E+00,0.5055E+00,0.4991E+00,
     +0.4928E+00,0.4866E+00,0.4806E+00,0.4746E+00,0.4687E+00,0.4628E+00,
     +0.4571E+00,0.4514E+00,0.4459E+00,0.4404E+00,0.4349E+00,0.4295E+00,
     +0.4242E+00,0.4189E+00,0.4137E+00,0.4085E+00,0.4034E+00,0.3982E+00,
     +0.3931E+00,0.3880E+00,0.3829E+00,0.3778E+00,0.3727E+00,0.3675E+00,
     +0.3623E+00,0.3570E+00,0.3516E+00,0.3462E+00,0.3406E+00,0.3350E+00,
     +0.3291E+00,0.3232E+00,0.3170E+00,0.3106E+00,0.3040E+00,0.2972E+00,
     +0.2901E+00,0.2827E+00,0.2750E+00,0.2670E+00,0.2586E+00,0.2499E+00,
     +0.2408E+00,0.2314E+00,0.2215E+00,0.2114E+00,0.2009E+00,0.1900E+00,
     +0.1790E+00,0.1677E+00,0.1562E+00,0.1447E+00,0.1332E+00,0.1217E+00,
     +0.1105E+00,0.9952E-01,0.8895E-01,0.7886E-01,0.6932E-01,0.6039E-01,
     +0.5209E-01,0.4443E-01,0.3741E-01,0.3100E-01,0.2517E-01,0.1991E-01,
     +0.1521E-01,0.1110E-01,0.7642E-02,0.4873E-02,0.2818E-02,0.1439E-02,
     +0.8946E-03,0.5421E-03,0.3222E-03,0.1898E-03,0.1125E-03,0.6811E-04,
     +0.4240E-04,0.2693E-04,0.1704E-04,0.1035E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.4489E+00,0.4406E+00,0.4324E+00,0.4243E+00,0.4164E+00,0.4086E+00,
     +0.4009E+00,0.3934E+00,0.3860E+00,0.3788E+00,0.3716E+00,0.3646E+00,
     +0.3577E+00,0.3510E+00,0.3443E+00,0.3378E+00,0.3314E+00,0.3251E+00,
     +0.3189E+00,0.3128E+00,0.3068E+00,0.3010E+00,0.2952E+00,0.2895E+00,
     +0.2839E+00,0.2785E+00,0.2731E+00,0.2678E+00,0.2626E+00,0.2575E+00,
     +0.2524E+00,0.2475E+00,0.2426E+00,0.2378E+00,0.2331E+00,0.2284E+00,
     +0.2239E+00,0.2193E+00,0.2149E+00,0.2104E+00,0.2061E+00,0.2017E+00,
     +0.1975E+00,0.1932E+00,0.1890E+00,0.1847E+00,0.1805E+00,0.1763E+00,
     +0.1721E+00,0.1679E+00,0.1637E+00,0.1594E+00,0.1551E+00,0.1507E+00,
     +0.1463E+00,0.1417E+00,0.1372E+00,0.1325E+00,0.1277E+00,0.1229E+00,
     +0.1179E+00,0.1128E+00,0.1076E+00,0.1023E+00,0.9691E-01,0.9142E-01,
     +0.8586E-01,0.8024E-01,0.7459E-01,0.6894E-01,0.6333E-01,0.5779E-01,
     +0.5236E-01,0.4709E-01,0.4202E-01,0.3718E-01,0.3260E-01,0.2832E-01,
     +0.2435E-01,0.2069E-01,0.1735E-01,0.1431E-01,0.1156E-01,0.9108E-02,
     +0.6939E-02,0.5063E-02,0.3496E-02,0.2252E-02,0.1330E-02,0.7088E-03,
     +0.4601E-03,0.2960E-03,0.1903E-03,0.1235E-03,0.8154E-04,0.5484E-04,
     +0.3729E-04,0.2520E-04,0.1654E-04,0.1023E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.3324E+00,0.3241E+00,0.3159E+00,0.3078E+00,0.2999E+00,0.2922E+00,
     +0.2845E+00,0.2770E+00,0.2696E+00,0.2624E+00,0.2553E+00,0.2483E+00,
     +0.2415E+00,0.2347E+00,0.2281E+00,0.2217E+00,0.2153E+00,0.2090E+00,
     +0.2029E+00,0.1969E+00,0.1910E+00,0.1852E+00,0.1795E+00,0.1739E+00,
     +0.1685E+00,0.1631E+00,0.1579E+00,0.1527E+00,0.1477E+00,0.1427E+00,
     +0.1379E+00,0.1332E+00,0.1285E+00,0.1240E+00,0.1196E+00,0.1152E+00,
     +0.1110E+00,0.1068E+00,0.1028E+00,0.9884E-01,0.9499E-01,0.9122E-01,
     +0.8756E-01,0.8398E-01,0.8049E-01,0.7709E-01,0.7378E-01,0.7056E-01,
     +0.6743E-01,0.6438E-01,0.6141E-01,0.5853E-01,0.5572E-01,0.5299E-01,
     +0.5034E-01,0.4777E-01,0.4527E-01,0.4283E-01,0.4047E-01,0.3817E-01,
     +0.3594E-01,0.3377E-01,0.3166E-01,0.2961E-01,0.2761E-01,0.2568E-01,
     +0.2379E-01,0.2196E-01,0.2018E-01,0.1846E-01,0.1679E-01,0.1518E-01,
     +0.1363E-01,0.1215E-01,0.1073E-01,0.9391E-02,0.8127E-02,0.6948E-02,
     +0.5859E-02,0.4866E-02,0.3972E-02,0.3181E-02,0.2495E-02,0.1911E-02,
     +0.1427E-02,0.1037E-02,0.7328E-03,0.5039E-03,0.3380E-03,0.2219E-03,
     +0.1705E-03,0.1319E-03,0.1024E-03,0.7928E-04,0.6088E-04,0.4600E-04,
     +0.3388E-04,0.2405E-04,0.1621E-04,0.1015E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.1273E+00,0.1239E+00,0.1205E+00,0.1173E+00,0.1141E+00,0.1109E+00,
     +0.1079E+00,0.1048E+00,0.1019E+00,0.9898E-01,0.9614E-01,0.9336E-01,
     +0.9064E-01,0.8797E-01,0.8535E-01,0.8280E-01,0.8029E-01,0.7783E-01,
     +0.7543E-01,0.7308E-01,0.7077E-01,0.6852E-01,0.6631E-01,0.6415E-01,
     +0.6204E-01,0.5997E-01,0.5795E-01,0.5598E-01,0.5405E-01,0.5216E-01,
     +0.5032E-01,0.4852E-01,0.4676E-01,0.4504E-01,0.4336E-01,0.4172E-01,
     +0.4013E-01,0.3857E-01,0.3705E-01,0.3557E-01,0.3413E-01,0.3272E-01,
     +0.3135E-01,0.3002E-01,0.2872E-01,0.2746E-01,0.2624E-01,0.2504E-01,
     +0.2388E-01,0.2276E-01,0.2166E-01,0.2060E-01,0.1957E-01,0.1856E-01,
     +0.1759E-01,0.1665E-01,0.1573E-01,0.1485E-01,0.1399E-01,0.1315E-01,
     +0.1234E-01,0.1156E-01,0.1080E-01,0.1006E-01,0.9349E-02,0.8659E-02,
     +0.7992E-02,0.7347E-02,0.6724E-02,0.6124E-02,0.5547E-02,0.4993E-02,
     +0.4464E-02,0.3960E-02,0.3483E-02,0.3033E-02,0.2613E-02,0.2224E-02,
     +0.1867E-02,0.1544E-02,0.1255E-02,0.1001E-02,0.7822E-03,0.5971E-03,
     +0.4445E-03,0.3222E-03,0.2272E-03,0.1560E-03,0.1045E-03,0.6839E-04,
     +0.5241E-04,0.4041E-04,0.3121E-04,0.2404E-04,0.1834E-04,0.1375E-04,
     +0.1004E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.1389E-01,0.1467E-01,0.1550E-01,0.1637E-01,0.1730E-01,0.1828E-01,
     +0.1931E-01,0.2040E-01,0.2155E-01,0.2276E-01,0.2404E-01,0.2540E-01,
     +0.2683E-01,0.2834E-01,0.2993E-01,0.3162E-01,0.3339E-01,0.3527E-01,
     +0.3725E-01,0.3934E-01,0.4154E-01,0.4387E-01,0.4633E-01,0.4892E-01,
     +0.5165E-01,0.5454E-01,0.5758E-01,0.6079E-01,0.6417E-01,0.6774E-01,
     +0.7151E-01,0.7547E-01,0.7965E-01,0.8406E-01,0.8870E-01,0.9359E-01,
     +0.9873E-01,0.1042E+00,0.1099E+00,0.1159E+00,0.1222E+00,0.1288E+00,
     +0.1358E+00,0.1431E+00,0.1508E+00,0.1589E+00,0.1673E+00,0.1762E+00,
     +0.1855E+00,0.1952E+00,0.2054E+00,0.2160E+00,0.2271E+00,0.2386E+00,
     +0.2506E+00,0.2631E+00,0.2760E+00,0.2894E+00,0.3032E+00,0.3175E+00,
     +0.3321E+00,0.3470E+00,0.3623E+00,0.3777E+00,0.3934E+00,0.4090E+00,
     +0.4246E+00,0.4400E+00,0.4550E+00,0.4694E+00,0.4830E+00,0.4956E+00,
     +0.5068E+00,0.5162E+00,0.5236E+00,0.5285E+00,0.5305E+00,0.5290E+00,
     +0.5237E+00,0.5140E+00,0.4996E+00,0.4800E+00,0.4552E+00,0.4249E+00,
     +0.3894E+00,0.3492E+00,0.3051E+00,0.2584E+00,0.2106E+00,0.1636E+00,
     +0.1366E+00,0.1126E+00,0.9141E-01,0.7299E-01,0.5716E-01,0.4374E-01,
     +0.3252E-01,0.2331E-01,0.1593E-01,0.1020E-01,0.5953E-02,0.3011E-02,
     +0.1194E-02,0.2850E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.7917E-02,0.8364E-02,0.8836E-02,0.9335E-02,0.9862E-02,0.1042E-01,
     +0.1101E-01,0.1163E-01,0.1228E-01,0.1297E-01,0.1370E-01,0.1447E-01,
     +0.1529E-01,0.1615E-01,0.1705E-01,0.1801E-01,0.1902E-01,0.2009E-01,
     +0.2121E-01,0.2240E-01,0.2365E-01,0.2497E-01,0.2637E-01,0.2784E-01,
     +0.2939E-01,0.3103E-01,0.3275E-01,0.3457E-01,0.3649E-01,0.3851E-01,
     +0.4064E-01,0.4288E-01,0.4524E-01,0.4773E-01,0.5035E-01,0.5310E-01,
     +0.5600E-01,0.5905E-01,0.6226E-01,0.6563E-01,0.6916E-01,0.7288E-01,
     +0.7677E-01,0.8086E-01,0.8514E-01,0.8963E-01,0.9432E-01,0.9922E-01,
     +0.1043E+00,0.1097E+00,0.1153E+00,0.1210E+00,0.1271E+00,0.1333E+00,
     +0.1397E+00,0.1464E+00,0.1533E+00,0.1603E+00,0.1675E+00,0.1749E+00,
     +0.1824E+00,0.1899E+00,0.1975E+00,0.2051E+00,0.2126E+00,0.2199E+00,
     +0.2270E+00,0.2337E+00,0.2400E+00,0.2458E+00,0.2508E+00,0.2549E+00,
     +0.2579E+00,0.2597E+00,0.2600E+00,0.2587E+00,0.2555E+00,0.2503E+00,
     +0.2428E+00,0.2329E+00,0.2206E+00,0.2059E+00,0.1889E+00,0.1698E+00,
     +0.1490E+00,0.1270E+00,0.1047E+00,0.8279E-01,0.6220E-01,0.4381E-01,
     +0.3413E-01,0.2611E-01,0.1957E-01,0.1434E-01,0.1022E-01,0.7057E-02,
     +0.4681E-02,0.2952E-02,0.1744E-02,0.9422E-03,0.4485E-03,0.1760E-03,
     +0.4972E-04,0.0000E+00/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.2968E+02,0.2896E+02,0.2825E+02,0.2756E+02,0.2688E+02,0.2621E+02,
     +0.2556E+02,0.2492E+02,0.2429E+02,0.2368E+02,0.2308E+02,0.2249E+02,
     +0.2191E+02,0.2135E+02,0.2079E+02,0.2025E+02,0.1972E+02,0.1920E+02,
     +0.1869E+02,0.1819E+02,0.1770E+02,0.1722E+02,0.1675E+02,0.1629E+02,
     +0.1584E+02,0.1540E+02,0.1497E+02,0.1455E+02,0.1414E+02,0.1373E+02,
     +0.1334E+02,0.1295E+02,0.1257E+02,0.1220E+02,0.1184E+02,0.1149E+02,
     +0.1114E+02,0.1080E+02,0.1047E+02,0.1014E+02,0.9824E+01,0.9512E+01,
     +0.9206E+01,0.8906E+01,0.8612E+01,0.8323E+01,0.8040E+01,0.7762E+01,
     +0.7489E+01,0.7220E+01,0.6956E+01,0.6695E+01,0.6439E+01,0.6186E+01,
     +0.5936E+01,0.5689E+01,0.5444E+01,0.5203E+01,0.4963E+01,0.4725E+01,
     +0.4490E+01,0.4256E+01,0.4023E+01,0.3793E+01,0.3564E+01,0.3337E+01,
     +0.3112E+01,0.2890E+01,0.2671E+01,0.2455E+01,0.2243E+01,0.2035E+01,
     +0.1834E+01,0.1639E+01,0.1451E+01,0.1272E+01,0.1102E+01,0.9425E+00,
     +0.7947E+00,0.6593E+00,0.5368E+00,0.4280E+00,0.3330E+00,0.2518E+00,
     +0.1841E+00,0.1293E+00,0.8647E-01,0.5438E-01,0.3150E-01,0.1617E-01,
     +0.9860E-02,0.5523E-02,0.2590E-02,0.6516E-03,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.4271E+01,0.4170E+01,0.4072E+01,0.3976E+01,0.3882E+01,0.3789E+01,
     +0.3699E+01,0.3611E+01,0.3525E+01,0.3440E+01,0.3358E+01,0.3277E+01,
     +0.3198E+01,0.3120E+01,0.3045E+01,0.2971E+01,0.2898E+01,0.2827E+01,
     +0.2758E+01,0.2690E+01,0.2624E+01,0.2559E+01,0.2496E+01,0.2434E+01,
     +0.2373E+01,0.2314E+01,0.2256E+01,0.2199E+01,0.2144E+01,0.2090E+01,
     +0.2037E+01,0.1985E+01,0.1934E+01,0.1884E+01,0.1836E+01,0.1788E+01,
     +0.1741E+01,0.1695E+01,0.1651E+01,0.1606E+01,0.1563E+01,0.1521E+01,
     +0.1479E+01,0.1438E+01,0.1397E+01,0.1358E+01,0.1318E+01,0.1279E+01,
     +0.1240E+01,0.1202E+01,0.1164E+01,0.1126E+01,0.1089E+01,0.1051E+01,
     +0.1013E+01,0.9758E+00,0.9381E+00,0.9001E+00,0.8620E+00,0.8237E+00,
     +0.7851E+00,0.7463E+00,0.7072E+00,0.6679E+00,0.6285E+00,0.5889E+00,
     +0.5494E+00,0.5101E+00,0.4710E+00,0.4324E+00,0.3946E+00,0.3576E+00,
     +0.3218E+00,0.2874E+00,0.2546E+00,0.2236E+00,0.1946E+00,0.1676E+00,
     +0.1428E+00,0.1202E+00,0.9971E-01,0.8129E-01,0.6487E-01,0.5039E-01,
     +0.3783E-01,0.2720E-01,0.1851E-01,0.1177E-01,0.6901E-02,0.3687E-02,
     +0.2417E-02,0.1580E-02,0.1039E-02,0.6908E-03,0.4662E-03,0.3179E-03,
     +0.2166E-03,0.1449E-03,0.9317E-04,0.5595E-04,0.3021E-04,0.1379E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.1046E+01,0.1025E+01,0.1004E+01,0.9837E+00,0.9639E+00,0.9445E+00,
     +0.9255E+00,0.9070E+00,0.8888E+00,0.8710E+00,0.8536E+00,0.8366E+00,
     +0.8199E+00,0.8035E+00,0.7875E+00,0.7719E+00,0.7565E+00,0.7416E+00,
     +0.7269E+00,0.7125E+00,0.6984E+00,0.6846E+00,0.6711E+00,0.6579E+00,
     +0.6450E+00,0.6323E+00,0.6198E+00,0.6077E+00,0.5957E+00,0.5840E+00,
     +0.5725E+00,0.5612E+00,0.5501E+00,0.5392E+00,0.5285E+00,0.5180E+00,
     +0.5076E+00,0.4973E+00,0.4872E+00,0.4773E+00,0.4674E+00,0.4576E+00,
     +0.4479E+00,0.4382E+00,0.4286E+00,0.4190E+00,0.4094E+00,0.3998E+00,
     +0.3902E+00,0.3805E+00,0.3707E+00,0.3608E+00,0.3508E+00,0.3406E+00,
     +0.3303E+00,0.3197E+00,0.3090E+00,0.2981E+00,0.2869E+00,0.2754E+00,
     +0.2637E+00,0.2518E+00,0.2396E+00,0.2272E+00,0.2146E+00,0.2018E+00,
     +0.1888E+00,0.1759E+00,0.1629E+00,0.1499E+00,0.1371E+00,0.1246E+00,
     +0.1124E+00,0.1006E+00,0.8938E-01,0.7872E-01,0.6871E-01,0.5940E-01,
     +0.5082E-01,0.4295E-01,0.3579E-01,0.2932E-01,0.2350E-01,0.1833E-01,
     +0.1379E-01,0.9912E-02,0.6718E-02,0.4226E-02,0.2423E-02,0.1242E-02,
     +0.7821E-03,0.4861E-03,0.3007E-03,0.1872E-03,0.1184E-03,0.7637E-04,
     +0.4995E-04,0.3258E-04,0.2066E-04,0.1234E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.8710E+00,0.8499E+00,0.8293E+00,0.8091E+00,0.7894E+00,0.7700E+00,
     +0.7511E+00,0.7326E+00,0.7145E+00,0.6967E+00,0.6794E+00,0.6624E+00,
     +0.6457E+00,0.6295E+00,0.6136E+00,0.5980E+00,0.5828E+00,0.5679E+00,
     +0.5533E+00,0.5390E+00,0.5251E+00,0.5114E+00,0.4981E+00,0.4851E+00,
     +0.4723E+00,0.4599E+00,0.4476E+00,0.4357E+00,0.4241E+00,0.4127E+00,
     +0.4015E+00,0.3906E+00,0.3799E+00,0.3695E+00,0.3593E+00,0.3493E+00,
     +0.3395E+00,0.3300E+00,0.3206E+00,0.3114E+00,0.3024E+00,0.2936E+00,
     +0.2849E+00,0.2764E+00,0.2681E+00,0.2598E+00,0.2518E+00,0.2438E+00,
     +0.2359E+00,0.2281E+00,0.2204E+00,0.2128E+00,0.2053E+00,0.1978E+00,
     +0.1903E+00,0.1828E+00,0.1754E+00,0.1680E+00,0.1606E+00,0.1532E+00,
     +0.1458E+00,0.1383E+00,0.1309E+00,0.1234E+00,0.1160E+00,0.1085E+00,
     +0.1011E+00,0.9379E-01,0.8652E-01,0.7936E-01,0.7234E-01,0.6551E-01,
     +0.5890E-01,0.5255E-01,0.4651E-01,0.4080E-01,0.3546E-01,0.3051E-01,
     +0.2595E-01,0.2180E-01,0.1805E-01,0.1468E-01,0.1169E-01,0.9069E-02,
     +0.6801E-02,0.4891E-02,0.3336E-02,0.2134E-02,0.1265E-02,0.6895E-03,
     +0.4601E-03,0.3074E-03,0.2070E-03,0.1411E-03,0.9735E-04,0.6759E-04,
     +0.4667E-04,0.3150E-04,0.2036E-04,0.1227E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.7545E+00,0.7335E+00,0.7129E+00,0.6927E+00,0.6730E+00,0.6537E+00,
     +0.6348E+00,0.6163E+00,0.5982E+00,0.5805E+00,0.5631E+00,0.5462E+00,
     +0.5296E+00,0.5134E+00,0.4975E+00,0.4820E+00,0.4668E+00,0.4520E+00,
     +0.4375E+00,0.4233E+00,0.4095E+00,0.3959E+00,0.3827E+00,0.3698E+00,
     +0.3572E+00,0.3448E+00,0.3328E+00,0.3211E+00,0.3096E+00,0.2984E+00,
     +0.2875E+00,0.2768E+00,0.2664E+00,0.2563E+00,0.2465E+00,0.2368E+00,
     +0.2275E+00,0.2183E+00,0.2095E+00,0.2008E+00,0.1924E+00,0.1842E+00,
     +0.1763E+00,0.1685E+00,0.1610E+00,0.1537E+00,0.1466E+00,0.1397E+00,
     +0.1330E+00,0.1266E+00,0.1203E+00,0.1142E+00,0.1083E+00,0.1025E+00,
     +0.9696E-01,0.9158E-01,0.8637E-01,0.8132E-01,0.7643E-01,0.7170E-01,
     +0.6713E-01,0.6270E-01,0.5841E-01,0.5427E-01,0.5027E-01,0.4641E-01,
     +0.4268E-01,0.3909E-01,0.3564E-01,0.3233E-01,0.2915E-01,0.2612E-01,
     +0.2324E-01,0.2051E-01,0.1794E-01,0.1554E-01,0.1330E-01,0.1125E-01,
     +0.9387E-02,0.7710E-02,0.6224E-02,0.4930E-02,0.3824E-02,0.2899E-02,
     +0.2143E-02,0.1544E-02,0.1083E-02,0.7396E-03,0.4932E-03,0.3214E-03,
     +0.2454E-03,0.1882E-03,0.1445E-03,0.1104E-03,0.8334E-04,0.6175E-04,
     +0.4448E-04,0.3078E-04,0.2016E-04,0.1222E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.5541E+00,0.5380E+00,0.5221E+00,0.5067E+00,0.4916E+00,0.4768E+00,
     +0.4624E+00,0.4483E+00,0.4346E+00,0.4211E+00,0.4080E+00,0.3952E+00,
     +0.3826E+00,0.3704E+00,0.3585E+00,0.3468E+00,0.3354E+00,0.3243E+00,
     +0.3135E+00,0.3029E+00,0.2926E+00,0.2825E+00,0.2727E+00,0.2632E+00,
     +0.2538E+00,0.2447E+00,0.2359E+00,0.2272E+00,0.2188E+00,0.2106E+00,
     +0.2026E+00,0.1948E+00,0.1873E+00,0.1799E+00,0.1727E+00,0.1658E+00,
     +0.1590E+00,0.1524E+00,0.1460E+00,0.1397E+00,0.1337E+00,0.1278E+00,
     +0.1221E+00,0.1165E+00,0.1112E+00,0.1060E+00,0.1009E+00,0.9598E-01,
     +0.9123E-01,0.8662E-01,0.8216E-01,0.7783E-01,0.7365E-01,0.6960E-01,
     +0.6568E-01,0.6189E-01,0.5823E-01,0.5469E-01,0.5127E-01,0.4796E-01,
     +0.4477E-01,0.4170E-01,0.3873E-01,0.3587E-01,0.3312E-01,0.3047E-01,
     +0.2792E-01,0.2548E-01,0.2314E-01,0.2091E-01,0.1878E-01,0.1676E-01,
     +0.1485E-01,0.1305E-01,0.1137E-01,0.9805E-02,0.8361E-02,0.7042E-02,
     +0.5849E-02,0.4784E-02,0.3846E-02,0.3035E-02,0.2345E-02,0.1771E-02,
     +0.1306E-02,0.9378E-03,0.6561E-03,0.4472E-03,0.2975E-03,0.1931E-03,
     +0.1469E-03,0.1122E-03,0.8566E-04,0.6500E-04,0.4873E-04,0.3580E-04,
     +0.2555E-04,0.1750E-04,0.1133E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1588E-01,0.1677E-01,0.1771E-01,0.1870E-01,0.1975E-01,0.2086E-01,
     +0.2202E-01,0.2325E-01,0.2455E-01,0.2592E-01,0.2737E-01,0.2889E-01,
     +0.3050E-01,0.3220E-01,0.3399E-01,0.3588E-01,0.3788E-01,0.3998E-01,
     +0.4219E-01,0.4453E-01,0.4699E-01,0.4958E-01,0.5232E-01,0.5520E-01,
     +0.5824E-01,0.6144E-01,0.6481E-01,0.6836E-01,0.7209E-01,0.7603E-01,
     +0.8017E-01,0.8452E-01,0.8910E-01,0.9392E-01,0.9899E-01,0.1043E+00,
     +0.1099E+00,0.1158E+00,0.1220E+00,0.1284E+00,0.1352E+00,0.1423E+00,
     +0.1498E+00,0.1576E+00,0.1658E+00,0.1743E+00,0.1833E+00,0.1926E+00,
     +0.2023E+00,0.2125E+00,0.2230E+00,0.2340E+00,0.2453E+00,0.2571E+00,
     +0.2693E+00,0.2819E+00,0.2948E+00,0.3081E+00,0.3218E+00,0.3357E+00,
     +0.3498E+00,0.3642E+00,0.3786E+00,0.3931E+00,0.4075E+00,0.4216E+00,
     +0.4355E+00,0.4488E+00,0.4615E+00,0.4733E+00,0.4839E+00,0.4931E+00,
     +0.5006E+00,0.5060E+00,0.5091E+00,0.5094E+00,0.5066E+00,0.5002E+00,
     +0.4900E+00,0.4755E+00,0.4566E+00,0.4330E+00,0.4048E+00,0.3722E+00,
     +0.3356E+00,0.2956E+00,0.2533E+00,0.2099E+00,0.1670E+00,0.1263E+00,
     +0.1035E+00,0.8361E-01,0.6650E-01,0.5194E-01,0.3971E-01,0.2958E-01,
     +0.2134E-01,0.1478E-01,0.9706E-02,0.5922E-02,0.3252E-02,0.1517E-02,
     +0.5348E-03,0.1031E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.9044E-02,0.9550E-02,0.1008E-01,0.1065E-01,0.1124E-01,0.1187E-01,
     +0.1254E-01,0.1323E-01,0.1397E-01,0.1475E-01,0.1557E-01,0.1644E-01,
     +0.1735E-01,0.1832E-01,0.1933E-01,0.2040E-01,0.2153E-01,0.2272E-01,
     +0.2398E-01,0.2530E-01,0.2669E-01,0.2816E-01,0.2971E-01,0.3134E-01,
     +0.3306E-01,0.3486E-01,0.3676E-01,0.3877E-01,0.4087E-01,0.4309E-01,
     +0.4542E-01,0.4787E-01,0.5044E-01,0.5315E-01,0.5599E-01,0.5897E-01,
     +0.6210E-01,0.6538E-01,0.6882E-01,0.7243E-01,0.7621E-01,0.8016E-01,
     +0.8429E-01,0.8860E-01,0.9311E-01,0.9781E-01,0.1027E+00,0.1078E+00,
     +0.1131E+00,0.1186E+00,0.1243E+00,0.1302E+00,0.1363E+00,0.1425E+00,
     +0.1489E+00,0.1555E+00,0.1623E+00,0.1691E+00,0.1761E+00,0.1831E+00,
     +0.1901E+00,0.1971E+00,0.2041E+00,0.2109E+00,0.2174E+00,0.2237E+00,
     +0.2296E+00,0.2351E+00,0.2399E+00,0.2439E+00,0.2471E+00,0.2493E+00,
     +0.2503E+00,0.2499E+00,0.2480E+00,0.2443E+00,0.2389E+00,0.2314E+00,
     +0.2219E+00,0.2103E+00,0.1965E+00,0.1808E+00,0.1633E+00,0.1444E+00,
     +0.1244E+00,0.1040E+00,0.8393E-01,0.6480E-01,0.4740E-01,0.3239E-01,
     +0.2472E-01,0.1851E-01,0.1356E-01,0.9698E-02,0.6734E-02,0.4515E-02,
     +0.2899E-02,0.1762E-02,0.9961E-03,0.5107E-03,0.2276E-03,0.8172E-04,
     +0.2023E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.5756E+02,0.5577E+02,0.5404E+02,0.5234E+02,0.5069E+02,0.4908E+02,
     +0.4752E+02,0.4599E+02,0.4451E+02,0.4306E+02,0.4165E+02,0.4028E+02,
     +0.3895E+02,0.3765E+02,0.3638E+02,0.3515E+02,0.3395E+02,0.3279E+02,
     +0.3166E+02,0.3055E+02,0.2948E+02,0.2844E+02,0.2743E+02,0.2644E+02,
     +0.2549E+02,0.2456E+02,0.2365E+02,0.2278E+02,0.2192E+02,0.2109E+02,
     +0.2029E+02,0.1951E+02,0.1875E+02,0.1802E+02,0.1730E+02,0.1661E+02,
     +0.1594E+02,0.1528E+02,0.1465E+02,0.1404E+02,0.1344E+02,0.1286E+02,
     +0.1230E+02,0.1176E+02,0.1123E+02,0.1072E+02,0.1022E+02,0.9741E+01,
     +0.9274E+01,0.8821E+01,0.8382E+01,0.7956E+01,0.7543E+01,0.7142E+01,
     +0.6753E+01,0.6375E+01,0.6009E+01,0.5653E+01,0.5308E+01,0.4973E+01,
     +0.4649E+01,0.4334E+01,0.4030E+01,0.3735E+01,0.3450E+01,0.3174E+01,
     +0.2909E+01,0.2653E+01,0.2408E+01,0.2174E+01,0.1950E+01,0.1738E+01,
     +0.1537E+01,0.1348E+01,0.1172E+01,0.1008E+01,0.8577E+00,0.7205E+00,
     +0.5967E+00,0.4863E+00,0.3892E+00,0.3051E+00,0.2334E+00,0.1737E+00,
     +0.1250E+00,0.8635E-01,0.5671E-01,0.3484E-01,0.1945E-01,0.9246E-02,
     +0.5086E-02,0.2258E-02,0.3821E-03,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.8901E+01,0.8638E+01,0.8381E+01,0.8131E+01,0.7888E+01,0.7651E+01,
     +0.7420E+01,0.7195E+01,0.6976E+01,0.6763E+01,0.6556E+01,0.6354E+01,
     +0.6158E+01,0.5967E+01,0.5781E+01,0.5600E+01,0.5424E+01,0.5252E+01,
     +0.5086E+01,0.4924E+01,0.4766E+01,0.4613E+01,0.4464E+01,0.4319E+01,
     +0.4178E+01,0.4041E+01,0.3908E+01,0.3778E+01,0.3653E+01,0.3530E+01,
     +0.3411E+01,0.3296E+01,0.3184E+01,0.3075E+01,0.2969E+01,0.2865E+01,
     +0.2765E+01,0.2668E+01,0.2573E+01,0.2481E+01,0.2391E+01,0.2304E+01,
     +0.2219E+01,0.2136E+01,0.2055E+01,0.1976E+01,0.1899E+01,0.1824E+01,
     +0.1751E+01,0.1679E+01,0.1609E+01,0.1541E+01,0.1473E+01,0.1407E+01,
     +0.1342E+01,0.1278E+01,0.1216E+01,0.1154E+01,0.1093E+01,0.1033E+01,
     +0.9737E+00,0.9154E+00,0.8579E+00,0.8013E+00,0.7457E+00,0.6910E+00,
     +0.6375E+00,0.5853E+00,0.5345E+00,0.4853E+00,0.4378E+00,0.3923E+00,
     +0.3490E+00,0.3080E+00,0.2695E+00,0.2338E+00,0.2008E+00,0.1706E+00,
     +0.1432E+00,0.1186E+00,0.9672E-01,0.7741E-01,0.6058E-01,0.4610E-01,
     +0.3389E-01,0.2388E-01,0.1597E-01,0.1003E-01,0.5864E-02,0.3180E-02,
     +0.2127E-02,0.1429E-02,0.9677E-03,0.6617E-03,0.4552E-03,0.3123E-03,
     +0.2110E-03,0.1382E-03,0.8596E-04,0.4946E-04,0.2534E-04,0.1085E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.1970E+01,0.1916E+01,0.1864E+01,0.1813E+01,0.1764E+01,0.1715E+01,
     +0.1668E+01,0.1622E+01,0.1578E+01,0.1534E+01,0.1492E+01,0.1451E+01,
     +0.1410E+01,0.1371E+01,0.1333E+01,0.1296E+01,0.1260E+01,0.1225E+01,
     +0.1191E+01,0.1158E+01,0.1125E+01,0.1094E+01,0.1063E+01,0.1033E+01,
     +0.1004E+01,0.9759E+00,0.9484E+00,0.9216E+00,0.8956E+00,0.8702E+00,
     +0.8455E+00,0.8214E+00,0.7979E+00,0.7751E+00,0.7528E+00,0.7311E+00,
     +0.7099E+00,0.6892E+00,0.6689E+00,0.6492E+00,0.6299E+00,0.6110E+00,
     +0.5924E+00,0.5743E+00,0.5564E+00,0.5389E+00,0.5216E+00,0.5046E+00,
     +0.4878E+00,0.4712E+00,0.4548E+00,0.4385E+00,0.4223E+00,0.4062E+00,
     +0.3902E+00,0.3742E+00,0.3583E+00,0.3423E+00,0.3264E+00,0.3104E+00,
     +0.2945E+00,0.2785E+00,0.2625E+00,0.2466E+00,0.2307E+00,0.2149E+00,
     +0.1992E+00,0.1838E+00,0.1686E+00,0.1537E+00,0.1393E+00,0.1254E+00,
     +0.1120E+00,0.9927E-01,0.8728E-01,0.7606E-01,0.6565E-01,0.5609E-01,
     +0.4738E-01,0.3949E-01,0.3241E-01,0.2611E-01,0.2055E-01,0.1571E-01,
     +0.1157E-01,0.8137E-02,0.5398E-02,0.3331E-02,0.1885E-02,0.9672E-03,
     +0.6168E-03,0.3921E-03,0.2505E-03,0.1619E-03,0.1061E-03,0.7018E-04,
     +0.4629E-04,0.2990E-04,0.1848E-04,0.1061E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.1796E+01,0.1742E+01,0.1690E+01,0.1639E+01,0.1589E+01,0.1541E+01,
     +0.1494E+01,0.1448E+01,0.1404E+01,0.1360E+01,0.1318E+01,0.1277E+01,
     +0.1237E+01,0.1198E+01,0.1160E+01,0.1123E+01,0.1087E+01,0.1052E+01,
     +0.1018E+01,0.9848E+00,0.9526E+00,0.9213E+00,0.8908E+00,0.8612E+00,
     +0.8324E+00,0.8045E+00,0.7773E+00,0.7508E+00,0.7251E+00,0.7001E+00,
     +0.6759E+00,0.6523E+00,0.6294E+00,0.6071E+00,0.5854E+00,0.5644E+00,
     +0.5439E+00,0.5240E+00,0.5047E+00,0.4859E+00,0.4677E+00,0.4499E+00,
     +0.4326E+00,0.4158E+00,0.3995E+00,0.3835E+00,0.3680E+00,0.3529E+00,
     +0.3381E+00,0.3237E+00,0.3097E+00,0.2959E+00,0.2825E+00,0.2693E+00,
     +0.2564E+00,0.2438E+00,0.2314E+00,0.2193E+00,0.2074E+00,0.1956E+00,
     +0.1841E+00,0.1728E+00,0.1617E+00,0.1508E+00,0.1402E+00,0.1297E+00,
     +0.1195E+00,0.1096E+00,0.9996E-01,0.9065E-01,0.8169E-01,0.7312E-01,
     +0.6498E-01,0.5728E-01,0.5007E-01,0.4337E-01,0.3719E-01,0.3154E-01,
     +0.2643E-01,0.2185E-01,0.1778E-01,0.1420E-01,0.1109E-01,0.8427E-02,
     +0.6192E-02,0.4367E-02,0.2930E-02,0.1854E-02,0.1098E-02,0.6075E-03,
     +0.4131E-03,0.2825E-03,0.1949E-03,0.1355E-03,0.9450E-04,0.6553E-04,
     +0.4463E-04,0.2938E-04,0.1834E-04,0.1059E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1679E+01,0.1626E+01,0.1573E+01,0.1523E+01,0.1473E+01,0.1425E+01,
     +0.1378E+01,0.1332E+01,0.1287E+01,0.1244E+01,0.1202E+01,0.1161E+01,
     +0.1121E+01,0.1082E+01,0.1044E+01,0.1007E+01,0.9712E+00,0.9364E+00,
     +0.9024E+00,0.8695E+00,0.8374E+00,0.8062E+00,0.7759E+00,0.7465E+00,
     +0.7179E+00,0.6901E+00,0.6631E+00,0.6369E+00,0.6114E+00,0.5867E+00,
     +0.5627E+00,0.5395E+00,0.5169E+00,0.4950E+00,0.4738E+00,0.4532E+00,
     +0.4332E+00,0.4139E+00,0.3952E+00,0.3771E+00,0.3595E+00,0.3425E+00,
     +0.3261E+00,0.3102E+00,0.2948E+00,0.2799E+00,0.2656E+00,0.2517E+00,
     +0.2383E+00,0.2254E+00,0.2129E+00,0.2008E+00,0.1892E+00,0.1780E+00,
     +0.1673E+00,0.1569E+00,0.1469E+00,0.1373E+00,0.1280E+00,0.1191E+00,
     +0.1106E+00,0.1024E+00,0.9455E-01,0.8703E-01,0.7983E-01,0.7295E-01,
     +0.6639E-01,0.6015E-01,0.5422E-01,0.4860E-01,0.4330E-01,0.3832E-01,
     +0.3365E-01,0.2930E-01,0.2528E-01,0.2159E-01,0.1822E-01,0.1518E-01,
     +0.1248E-01,0.1009E-01,0.8025E-02,0.6261E-02,0.4784E-02,0.3574E-02,
     +0.2607E-02,0.1854E-02,0.1285E-02,0.8687E-03,0.5727E-03,0.3677E-03,
     +0.2773E-03,0.2095E-03,0.1578E-03,0.1179E-03,0.8676E-04,0.6243E-04,
     +0.4352E-04,0.2904E-04,0.1825E-04,0.1057E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1486E+01,0.1437E+01,0.1390E+01,0.1343E+01,0.1298E+01,0.1255E+01,
     +0.1212E+01,0.1170E+01,0.1130E+01,0.1091E+01,0.1053E+01,0.1016E+01,
     +0.9796E+00,0.9446E+00,0.9105E+00,0.8774E+00,0.8452E+00,0.8140E+00,
     +0.7836E+00,0.7542E+00,0.7255E+00,0.6977E+00,0.6708E+00,0.6446E+00,
     +0.6192E+00,0.5945E+00,0.5706E+00,0.5474E+00,0.5249E+00,0.5031E+00,
     +0.4819E+00,0.4615E+00,0.4416E+00,0.4224E+00,0.4038E+00,0.3857E+00,
     +0.3683E+00,0.3514E+00,0.3351E+00,0.3193E+00,0.3040E+00,0.2892E+00,
     +0.2749E+00,0.2611E+00,0.2478E+00,0.2350E+00,0.2226E+00,0.2106E+00,
     +0.1991E+00,0.1879E+00,0.1772E+00,0.1669E+00,0.1569E+00,0.1474E+00,
     +0.1382E+00,0.1293E+00,0.1208E+00,0.1126E+00,0.1048E+00,0.9728E-01,
     +0.9007E-01,0.8318E-01,0.7659E-01,0.7029E-01,0.6429E-01,0.5857E-01,
     +0.5313E-01,0.4797E-01,0.4310E-01,0.3850E-01,0.3417E-01,0.3013E-01,
     +0.2636E-01,0.2286E-01,0.1965E-01,0.1671E-01,0.1405E-01,0.1166E-01,
     +0.9542E-02,0.7688E-02,0.6089E-02,0.4732E-02,0.3603E-02,0.2683E-02,
     +0.1950E-02,0.1383E-02,0.9561E-03,0.6443E-03,0.4232E-03,0.2703E-03,
     +0.2028E-03,0.1524E-03,0.1140E-03,0.8453E-04,0.6168E-04,0.4396E-04,
     +0.3032E-04,0.2000E-04,0.1241E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1765E-01,0.1864E-01,0.1967E-01,0.2077E-01,0.2192E-01,0.2314E-01,
     +0.2442E-01,0.2578E-01,0.2721E-01,0.2871E-01,0.3030E-01,0.3197E-01,
     +0.3374E-01,0.3560E-01,0.3756E-01,0.3962E-01,0.4180E-01,0.4409E-01,
     +0.4650E-01,0.4905E-01,0.5172E-01,0.5454E-01,0.5751E-01,0.6063E-01,
     +0.6392E-01,0.6738E-01,0.7102E-01,0.7485E-01,0.7887E-01,0.8310E-01,
     +0.8754E-01,0.9221E-01,0.9711E-01,0.1023E+00,0.1077E+00,0.1133E+00,
     +0.1193E+00,0.1255E+00,0.1320E+00,0.1389E+00,0.1460E+00,0.1535E+00,
     +0.1613E+00,0.1694E+00,0.1780E+00,0.1868E+00,0.1961E+00,0.2057E+00,
     +0.2157E+00,0.2260E+00,0.2368E+00,0.2479E+00,0.2594E+00,0.2712E+00,
     +0.2834E+00,0.2959E+00,0.3087E+00,0.3218E+00,0.3351E+00,0.3486E+00,
     +0.3621E+00,0.3757E+00,0.3893E+00,0.4027E+00,0.4159E+00,0.4287E+00,
     +0.4409E+00,0.4524E+00,0.4630E+00,0.4725E+00,0.4806E+00,0.4871E+00,
     +0.4916E+00,0.4940E+00,0.4937E+00,0.4906E+00,0.4843E+00,0.4745E+00,
     +0.4610E+00,0.4434E+00,0.4217E+00,0.3959E+00,0.3661E+00,0.3327E+00,
     +0.2962E+00,0.2573E+00,0.2172E+00,0.1770E+00,0.1382E+00,0.1023E+00,
     +0.8263E-01,0.6577E-01,0.5147E-01,0.3951E-01,0.2964E-01,0.2163E-01,
     +0.1524E-01,0.1028E-01,0.6535E-02,0.3836E-02,0.2005E-02,0.8751E-03,
     +0.2781E-03,0.4319E-04/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.1004E-01,0.1060E-01,0.1119E-01,0.1181E-01,0.1247E-01,0.1316E-01,
     +0.1389E-01,0.1465E-01,0.1546E-01,0.1632E-01,0.1721E-01,0.1816E-01,
     +0.1916E-01,0.2021E-01,0.2132E-01,0.2249E-01,0.2372E-01,0.2502E-01,
     +0.2638E-01,0.2781E-01,0.2933E-01,0.3092E-01,0.3259E-01,0.3435E-01,
     +0.3620E-01,0.3815E-01,0.4019E-01,0.4234E-01,0.4460E-01,0.4697E-01,
     +0.4946E-01,0.5207E-01,0.5481E-01,0.5769E-01,0.6070E-01,0.6386E-01,
     +0.6716E-01,0.7062E-01,0.7423E-01,0.7801E-01,0.8195E-01,0.8607E-01,
     +0.9036E-01,0.9483E-01,0.9948E-01,0.1043E+00,0.1093E+00,0.1145E+00,
     +0.1199E+00,0.1255E+00,0.1312E+00,0.1371E+00,0.1432E+00,0.1494E+00,
     +0.1557E+00,0.1622E+00,0.1687E+00,0.1753E+00,0.1819E+00,0.1885E+00,
     +0.1951E+00,0.2016E+00,0.2079E+00,0.2140E+00,0.2197E+00,0.2251E+00,
     +0.2300E+00,0.2343E+00,0.2378E+00,0.2406E+00,0.2423E+00,0.2430E+00,
     +0.2424E+00,0.2404E+00,0.2369E+00,0.2316E+00,0.2247E+00,0.2158E+00,
     +0.2051E+00,0.1924E+00,0.1780E+00,0.1620E+00,0.1446E+00,0.1262E+00,
     +0.1072E+00,0.8833E-01,0.7008E-01,0.5313E-01,0.3808E-01,0.2542E-01,
     +0.1909E-01,0.1406E-01,0.1013E-01,0.7104E-02,0.4833E-02,0.3168E-02,
     +0.1982E-02,0.1170E-02,0.6388E-03,0.3139E-03,0.1325E-03,0.4408E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.8721E+02,0.8408E+02,0.8106E+02,0.7812E+02,0.7527E+02,0.7251E+02,
     +0.6984E+02,0.6724E+02,0.6473E+02,0.6229E+02,0.5993E+02,0.5764E+02,
     +0.5543E+02,0.5328E+02,0.5120E+02,0.4919E+02,0.4725E+02,0.4537E+02,
     +0.4354E+02,0.4178E+02,0.4008E+02,0.3843E+02,0.3684E+02,0.3530E+02,
     +0.3381E+02,0.3237E+02,0.3098E+02,0.2964E+02,0.2834E+02,0.2709E+02,
     +0.2589E+02,0.2472E+02,0.2360E+02,0.2251E+02,0.2147E+02,0.2046E+02,
     +0.1949E+02,0.1855E+02,0.1765E+02,0.1678E+02,0.1594E+02,0.1514E+02,
     +0.1436E+02,0.1362E+02,0.1290E+02,0.1221E+02,0.1154E+02,0.1090E+02,
     +0.1029E+02,0.9699E+01,0.9131E+01,0.8586E+01,0.8063E+01,0.7560E+01,
     +0.7078E+01,0.6615E+01,0.6171E+01,0.5746E+01,0.5338E+01,0.4948E+01,
     +0.4575E+01,0.4218E+01,0.3877E+01,0.3552E+01,0.3243E+01,0.2949E+01,
     +0.2670E+01,0.2407E+01,0.2158E+01,0.1924E+01,0.1704E+01,0.1500E+01,
     +0.1310E+01,0.1135E+01,0.9737E+00,0.8273E+00,0.6950E+00,0.5766E+00,
     +0.4717E+00,0.3797E+00,0.3003E+00,0.2326E+00,0.1758E+00,0.1292E+00,
     +0.9178E-01,0.6250E-01,0.4031E-01,0.2414E-01,0.1290E-01,0.5559E-02,
     +0.2624E-02,0.6741E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1454E+02,0.1405E+02,0.1357E+02,0.1311E+02,0.1266E+02,0.1223E+02,
     +0.1181E+02,0.1140E+02,0.1100E+02,0.1062E+02,0.1025E+02,0.9887E+01,
     +0.9537E+01,0.9198E+01,0.8869E+01,0.8550E+01,0.8241E+01,0.7942E+01,
     +0.7652E+01,0.7371E+01,0.7099E+01,0.6836E+01,0.6581E+01,0.6334E+01,
     +0.6095E+01,0.5864E+01,0.5640E+01,0.5423E+01,0.5214E+01,0.5011E+01,
     +0.4815E+01,0.4625E+01,0.4441E+01,0.4264E+01,0.4092E+01,0.3926E+01,
     +0.3765E+01,0.3610E+01,0.3460E+01,0.3314E+01,0.3174E+01,0.3038E+01,
     +0.2906E+01,0.2779E+01,0.2655E+01,0.2536E+01,0.2420E+01,0.2308E+01,
     +0.2199E+01,0.2094E+01,0.1992E+01,0.1892E+01,0.1796E+01,0.1702E+01,
     +0.1611E+01,0.1523E+01,0.1436E+01,0.1352E+01,0.1271E+01,0.1191E+01,
     +0.1114E+01,0.1038E+01,0.9652E+00,0.8940E+00,0.8249E+00,0.7580E+00,
     +0.6934E+00,0.6311E+00,0.5713E+00,0.5142E+00,0.4598E+00,0.4083E+00,
     +0.3600E+00,0.3148E+00,0.2729E+00,0.2343E+00,0.1992E+00,0.1675E+00,
     +0.1390E+00,0.1138E+00,0.9164E-01,0.7237E-01,0.5584E-01,0.4188E-01,
     +0.3034E-01,0.2107E-01,0.1391E-01,0.8656E-02,0.5041E-02,0.2744E-02,
     +0.1847E-02,0.1250E-02,0.8525E-03,0.5845E-03,0.4007E-03,0.2722E-03,
     +0.1809E-03,0.1158E-03,0.7003E-04,0.3896E-04,0.1919E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.2996E+01,0.2901E+01,0.2809E+01,0.2720E+01,0.2633E+01,0.2549E+01,
     +0.2467E+01,0.2388E+01,0.2311E+01,0.2236E+01,0.2164E+01,0.2093E+01,
     +0.2025E+01,0.1959E+01,0.1895E+01,0.1833E+01,0.1772E+01,0.1714E+01,
     +0.1657E+01,0.1602E+01,0.1549E+01,0.1498E+01,0.1448E+01,0.1399E+01,
     +0.1352E+01,0.1307E+01,0.1263E+01,0.1220E+01,0.1178E+01,0.1138E+01,
     +0.1099E+01,0.1062E+01,0.1025E+01,0.9897E+00,0.9554E+00,0.9220E+00,
     +0.8897E+00,0.8584E+00,0.8279E+00,0.7983E+00,0.7696E+00,0.7417E+00,
     +0.7145E+00,0.6880E+00,0.6623E+00,0.6371E+00,0.6126E+00,0.5886E+00,
     +0.5652E+00,0.5423E+00,0.5198E+00,0.4978E+00,0.4761E+00,0.4548E+00,
     +0.4338E+00,0.4132E+00,0.3928E+00,0.3726E+00,0.3528E+00,0.3332E+00,
     +0.3138E+00,0.2946E+00,0.2757E+00,0.2571E+00,0.2388E+00,0.2209E+00,
     +0.2033E+00,0.1861E+00,0.1695E+00,0.1534E+00,0.1380E+00,0.1232E+00,
     +0.1092E+00,0.9608E-01,0.8379E-01,0.7241E-01,0.6197E-01,0.5246E-01,
     +0.4388E-01,0.3619E-01,0.2937E-01,0.2336E-01,0.1814E-01,0.1367E-01,
     +0.9915E-02,0.6862E-02,0.4481E-02,0.2727E-02,0.1528E-02,0.7821E-03,
     +0.5010E-03,0.3213E-03,0.2077E-03,0.1357E-03,0.8949E-04,0.5915E-04,
     +0.3865E-04,0.2453E-04,0.1479E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.2822E+01,0.2727E+01,0.2635E+01,0.2546E+01,0.2459E+01,0.2375E+01,
     +0.2293E+01,0.2214E+01,0.2137E+01,0.2062E+01,0.1990E+01,0.1920E+01,
     +0.1852E+01,0.1786E+01,0.1722E+01,0.1660E+01,0.1600E+01,0.1541E+01,
     +0.1485E+01,0.1430E+01,0.1377E+01,0.1326E+01,0.1276E+01,0.1228E+01,
     +0.1181E+01,0.1136E+01,0.1092E+01,0.1050E+01,0.1009E+01,0.9694E+00,
     +0.9311E+00,0.8939E+00,0.8580E+00,0.8233E+00,0.7897E+00,0.7571E+00,
     +0.7257E+00,0.6953E+00,0.6659E+00,0.6374E+00,0.6099E+00,0.5833E+00,
     +0.5575E+00,0.5326E+00,0.5085E+00,0.4851E+00,0.4625E+00,0.4406E+00,
     +0.4194E+00,0.3989E+00,0.3790E+00,0.3597E+00,0.3410E+00,0.3228E+00,
     +0.3052E+00,0.2881E+00,0.2714E+00,0.2553E+00,0.2396E+00,0.2243E+00,
     +0.2095E+00,0.1951E+00,0.1811E+00,0.1676E+00,0.1545E+00,0.1418E+00,
     +0.1296E+00,0.1178E+00,0.1066E+00,0.9584E-01,0.8563E-01,0.7598E-01,
     +0.6692E-01,0.5846E-01,0.5062E-01,0.4343E-01,0.3687E-01,0.3095E-01,
     +0.2565E-01,0.2096E-01,0.1685E-01,0.1328E-01,0.1023E-01,0.7667E-02,
     +0.5555E-02,0.3864E-02,0.2561E-02,0.1606E-02,0.9471E-03,0.5255E-03,
     +0.3590E-03,0.2467E-03,0.1707E-03,0.1186E-03,0.8221E-04,0.5632E-04,
     +0.3768E-04,0.2424E-04,0.1471E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.2705E+01,0.2611E+01,0.2519E+01,0.2429E+01,0.2343E+01,0.2259E+01,
     +0.2177E+01,0.2098E+01,0.2021E+01,0.1946E+01,0.1874E+01,0.1804E+01,
     +0.1736E+01,0.1670E+01,0.1606E+01,0.1544E+01,0.1484E+01,0.1426E+01,
     +0.1370E+01,0.1315E+01,0.1262E+01,0.1211E+01,0.1162E+01,0.1114E+01,
     +0.1067E+01,0.1022E+01,0.9788E+00,0.9368E+00,0.8961E+00,0.8568E+00,
     +0.8187E+00,0.7820E+00,0.7465E+00,0.7122E+00,0.6791E+00,0.6471E+00,
     +0.6163E+00,0.5865E+00,0.5578E+00,0.5300E+00,0.5033E+00,0.4776E+00,
     +0.4528E+00,0.4289E+00,0.4059E+00,0.3837E+00,0.3624E+00,0.3419E+00,
     +0.3222E+00,0.3033E+00,0.2851E+00,0.2676E+00,0.2509E+00,0.2348E+00,
     +0.2194E+00,0.2047E+00,0.1905E+00,0.1770E+00,0.1641E+00,0.1518E+00,
     +0.1400E+00,0.1288E+00,0.1181E+00,0.1079E+00,0.9828E-01,0.8914E-01,
     +0.8050E-01,0.7234E-01,0.6467E-01,0.5748E-01,0.5076E-01,0.4451E-01,
     +0.3872E-01,0.3340E-01,0.2853E-01,0.2412E-01,0.2015E-01,0.1662E-01,
     +0.1351E-01,0.1081E-01,0.8504E-02,0.6563E-02,0.4962E-02,0.3669E-02,
     +0.2650E-02,0.1867E-02,0.1282E-02,0.8586E-03,0.5600E-03,0.3545E-03,
     +0.2643E-03,0.1970E-03,0.1461E-03,0.1072E-03,0.7736E-04,0.5444E-04,
     +0.3702E-04,0.2404E-04,0.1466E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.2518E+01,0.2428E+01,0.2340E+01,0.2255E+01,0.2173E+01,0.2093E+01,
     +0.2016E+01,0.1941E+01,0.1868E+01,0.1798E+01,0.1730E+01,0.1664E+01,
     +0.1599E+01,0.1537E+01,0.1477E+01,0.1419E+01,0.1363E+01,0.1308E+01,
     +0.1255E+01,0.1204E+01,0.1154E+01,0.1107E+01,0.1060E+01,0.1015E+01,
     +0.9721E+00,0.9302E+00,0.8897E+00,0.8506E+00,0.8128E+00,0.7763E+00,
     +0.7411E+00,0.7071E+00,0.6742E+00,0.6425E+00,0.6120E+00,0.5825E+00,
     +0.5540E+00,0.5266E+00,0.5002E+00,0.4748E+00,0.4503E+00,0.4267E+00,
     +0.4040E+00,0.3821E+00,0.3611E+00,0.3409E+00,0.3215E+00,0.3029E+00,
     +0.2850E+00,0.2678E+00,0.2513E+00,0.2355E+00,0.2204E+00,0.2059E+00,
     +0.1920E+00,0.1787E+00,0.1660E+00,0.1539E+00,0.1424E+00,0.1313E+00,
     +0.1209E+00,0.1109E+00,0.1014E+00,0.9244E-01,0.8394E-01,0.7591E-01,
     +0.6834E-01,0.6123E-01,0.5456E-01,0.4832E-01,0.4253E-01,0.3716E-01,
     +0.3221E-01,0.2768E-01,0.2355E-01,0.1983E-01,0.1651E-01,0.1356E-01,
     +0.1098E-01,0.8754E-02,0.6860E-02,0.5275E-02,0.3974E-02,0.2929E-02,
     +0.2108E-02,0.1481E-02,0.1014E-02,0.6764E-03,0.4392E-03,0.2762E-03,
     +0.2048E-03,0.1516E-03,0.1116E-03,0.8121E-04,0.5804E-04,0.4042E-04,
     +0.2717E-04,0.1742E-04,0.1048E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.5005E+00,0.4803E+00,0.4608E+00,0.4420E+00,0.4238E+00,0.4063E+00,
     +0.3893E+00,0.3730E+00,0.3572E+00,0.3420E+00,0.3273E+00,0.3132E+00,
     +0.2995E+00,0.2864E+00,0.2737E+00,0.2615E+00,0.2498E+00,0.2384E+00,
     +0.2275E+00,0.2170E+00,0.2069E+00,0.1972E+00,0.1879E+00,0.1789E+00,
     +0.1703E+00,0.1620E+00,0.1540E+00,0.1463E+00,0.1390E+00,0.1319E+00,
     +0.1251E+00,0.1186E+00,0.1124E+00,0.1064E+00,0.1006E+00,0.9516E-01,
     +0.8989E-01,0.8485E-01,0.8003E-01,0.7542E-01,0.7101E-01,0.6679E-01,
     +0.6276E-01,0.5892E-01,0.5525E-01,0.5174E-01,0.4840E-01,0.4522E-01,
     +0.4219E-01,0.3931E-01,0.3657E-01,0.3396E-01,0.3149E-01,0.2914E-01,
     +0.2692E-01,0.2481E-01,0.2282E-01,0.2094E-01,0.1916E-01,0.1749E-01,
     +0.1591E-01,0.1444E-01,0.1305E-01,0.1175E-01,0.1054E-01,0.9416E-02,
     +0.8369E-02,0.7401E-02,0.6507E-02,0.5686E-02,0.4936E-02,0.4252E-02,
     +0.3634E-02,0.3079E-02,0.2583E-02,0.2143E-02,0.1758E-02,0.1424E-02,
     +0.1137E-02,0.8934E-03,0.6905E-03,0.5239E-03,0.3895E-03,0.2834E-03,
     +0.2014E-03,0.1395E-03,0.9409E-04,0.6159E-04,0.3897E-04,0.2364E-04,
     +0.1704E-04,0.1221E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1929E-01,0.2036E-01,0.2148E-01,0.2267E-01,0.2392E-01,0.2524E-01,
     +0.2663E-01,0.2809E-01,0.2964E-01,0.3126E-01,0.3298E-01,0.3478E-01,
     +0.3668E-01,0.3868E-01,0.4079E-01,0.4301E-01,0.4535E-01,0.4781E-01,
     +0.5040E-01,0.5313E-01,0.5599E-01,0.5901E-01,0.6218E-01,0.6551E-01,
     +0.6902E-01,0.7270E-01,0.7657E-01,0.8063E-01,0.8490E-01,0.8938E-01,
     +0.9407E-01,0.9900E-01,0.1042E+00,0.1096E+00,0.1153E+00,0.1212E+00,
     +0.1274E+00,0.1339E+00,0.1407E+00,0.1479E+00,0.1553E+00,0.1630E+00,
     +0.1711E+00,0.1795E+00,0.1883E+00,0.1974E+00,0.2068E+00,0.2166E+00,
     +0.2268E+00,0.2373E+00,0.2481E+00,0.2593E+00,0.2708E+00,0.2826E+00,
     +0.2947E+00,0.3070E+00,0.3196E+00,0.3323E+00,0.3452E+00,0.3581E+00,
     +0.3711E+00,0.3839E+00,0.3966E+00,0.4090E+00,0.4210E+00,0.4325E+00,
     +0.4432E+00,0.4531E+00,0.4619E+00,0.4694E+00,0.4754E+00,0.4796E+00,
     +0.4817E+00,0.4815E+00,0.4786E+00,0.4729E+00,0.4640E+00,0.4516E+00,
     +0.4357E+00,0.4160E+00,0.3925E+00,0.3654E+00,0.3349E+00,0.3014E+00,
     +0.2655E+00,0.2280E+00,0.1901E+00,0.1528E+00,0.1175E+00,0.8547E-01,
     +0.6822E-01,0.5362E-01,0.4141E-01,0.3133E-01,0.2314E-01,0.1659E-01,
     +0.1147E-01,0.7560E-02,0.4682E-02,0.2660E-02,0.1334E-02,0.5493E-03,
     +0.1587E-03,0.1942E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1096E-01,0.1157E-01,0.1221E-01,0.1288E-01,0.1359E-01,0.1433E-01,
     +0.1512E-01,0.1595E-01,0.1682E-01,0.1774E-01,0.1871E-01,0.1973E-01,
     +0.2081E-01,0.2194E-01,0.2313E-01,0.2438E-01,0.2570E-01,0.2708E-01,
     +0.2854E-01,0.3008E-01,0.3169E-01,0.3339E-01,0.3517E-01,0.3704E-01,
     +0.3900E-01,0.4107E-01,0.4324E-01,0.4551E-01,0.4790E-01,0.5040E-01,
     +0.5302E-01,0.5577E-01,0.5864E-01,0.6165E-01,0.6480E-01,0.6810E-01,
     +0.7154E-01,0.7513E-01,0.7888E-01,0.8279E-01,0.8686E-01,0.9110E-01,
     +0.9550E-01,0.1001E+00,0.1048E+00,0.1097E+00,0.1148E+00,0.1201E+00,
     +0.1255E+00,0.1311E+00,0.1368E+00,0.1427E+00,0.1486E+00,0.1548E+00,
     +0.1609E+00,0.1672E+00,0.1735E+00,0.1798E+00,0.1861E+00,0.1924E+00,
     +0.1985E+00,0.2044E+00,0.2101E+00,0.2155E+00,0.2206E+00,0.2251E+00,
     +0.2291E+00,0.2324E+00,0.2349E+00,0.2366E+00,0.2372E+00,0.2366E+00,
     +0.2348E+00,0.2315E+00,0.2268E+00,0.2204E+00,0.2123E+00,0.2025E+00,
     +0.1910E+00,0.1778E+00,0.1631E+00,0.1470E+00,0.1299E+00,0.1122E+00,
     +0.9429E-01,0.7672E-01,0.6005E-01,0.4485E-01,0.3161E-01,0.2071E-01,
     +0.1535E-01,0.1115E-01,0.7914E-02,0.5466E-02,0.3656E-02,0.2352E-02,
     +0.1441E-02,0.8297E-03,0.4402E-03,0.2087E-03,0.8399E-04,0.2611E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1167E+03,0.1121E+03,0.1076E+03,0.1033E+03,0.9914E+02,0.9512E+02,
     +0.9124E+02,0.8749E+02,0.8387E+02,0.8038E+02,0.7701E+02,0.7376E+02,
     +0.7062E+02,0.6759E+02,0.6468E+02,0.6187E+02,0.5916E+02,0.5655E+02,
     +0.5403E+02,0.5161E+02,0.4927E+02,0.4703E+02,0.4487E+02,0.4279E+02,
     +0.4079E+02,0.3886E+02,0.3701E+02,0.3523E+02,0.3352E+02,0.3188E+02,
     +0.3030E+02,0.2879E+02,0.2734E+02,0.2594E+02,0.2460E+02,0.2332E+02,
     +0.2209E+02,0.2091E+02,0.1978E+02,0.1869E+02,0.1766E+02,0.1666E+02,
     +0.1571E+02,0.1480E+02,0.1393E+02,0.1310E+02,0.1231E+02,0.1155E+02,
     +0.1083E+02,0.1014E+02,0.9478E+01,0.8849E+01,0.8250E+01,0.7679E+01,
     +0.7136E+01,0.6618E+01,0.6127E+01,0.5660E+01,0.5217E+01,0.4796E+01,
     +0.4398E+01,0.4021E+01,0.3665E+01,0.3329E+01,0.3012E+01,0.2715E+01,
     +0.2436E+01,0.2176E+01,0.1933E+01,0.1707E+01,0.1499E+01,0.1306E+01,
     +0.1130E+01,0.9698E+00,0.8246E+00,0.6940E+00,0.5776E+00,0.4747E+00,
     +0.3847E+00,0.3069E+00,0.2404E+00,0.1845E+00,0.1381E+00,0.1005E+00,
     +0.7055E-01,0.4738E-01,0.3001E-01,0.1748E-01,0.8883E-02,0.3378E-02,
     +0.1231E-02,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.2113E+02,0.2035E+02,0.1960E+02,0.1887E+02,0.1817E+02,0.1748E+02,
     +0.1682E+02,0.1619E+02,0.1557E+02,0.1497E+02,0.1440E+02,0.1384E+02,
     +0.1330E+02,0.1278E+02,0.1228E+02,0.1180E+02,0.1133E+02,0.1087E+02,
     +0.1044E+02,0.1002E+02,0.9608E+01,0.9215E+01,0.8836E+01,0.8470E+01,
     +0.8118E+01,0.7777E+01,0.7449E+01,0.7132E+01,0.6827E+01,0.6533E+01,
     +0.6250E+01,0.5977E+01,0.5713E+01,0.5460E+01,0.5216E+01,0.4980E+01,
     +0.4754E+01,0.4535E+01,0.4325E+01,0.4123E+01,0.3928E+01,0.3740E+01,
     +0.3559E+01,0.3385E+01,0.3218E+01,0.3056E+01,0.2901E+01,0.2751E+01,
     +0.2606E+01,0.2467E+01,0.2333E+01,0.2204E+01,0.2079E+01,0.1958E+01,
     +0.1842E+01,0.1730E+01,0.1622E+01,0.1517E+01,0.1417E+01,0.1319E+01,
     +0.1225E+01,0.1135E+01,0.1048E+01,0.9639E+00,0.8833E+00,0.8061E+00,
     +0.7322E+00,0.6618E+00,0.5949E+00,0.5315E+00,0.4719E+00,0.4160E+00,
     +0.3640E+00,0.3159E+00,0.2717E+00,0.2315E+00,0.1952E+00,0.1627E+00,
     +0.1338E+00,0.1085E+00,0.8650E-01,0.6760E-01,0.5158E-01,0.3825E-01,
     +0.2740E-01,0.1882E-01,0.1230E-01,0.7590E-02,0.4400E-02,0.2394E-02,
     +0.1614E-02,0.1094E-02,0.7453E-03,0.5091E-03,0.3464E-03,0.2325E-03,
     +0.1520E-03,0.9540E-04,0.5634E-04,0.3050E-04,0.1455E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.4082E+01,0.3939E+01,0.3801E+01,0.3668E+01,0.3538E+01,0.3413E+01,
     +0.3292E+01,0.3175E+01,0.3061E+01,0.2952E+01,0.2846E+01,0.2743E+01,
     +0.2644E+01,0.2548E+01,0.2455E+01,0.2365E+01,0.2278E+01,0.2195E+01,
     +0.2114E+01,0.2035E+01,0.1960E+01,0.1887E+01,0.1816E+01,0.1748E+01,
     +0.1682E+01,0.1619E+01,0.1557E+01,0.1498E+01,0.1441E+01,0.1386E+01,
     +0.1332E+01,0.1281E+01,0.1231E+01,0.1183E+01,0.1137E+01,0.1092E+01,
     +0.1049E+01,0.1007E+01,0.9663E+00,0.9273E+00,0.8895E+00,0.8529E+00,
     +0.8176E+00,0.7833E+00,0.7501E+00,0.7179E+00,0.6867E+00,0.6564E+00,
     +0.6270E+00,0.5984E+00,0.5705E+00,0.5434E+00,0.5169E+00,0.4911E+00,
     +0.4659E+00,0.4412E+00,0.4171E+00,0.3935E+00,0.3705E+00,0.3479E+00,
     +0.3258E+00,0.3041E+00,0.2830E+00,0.2624E+00,0.2423E+00,0.2227E+00,
     +0.2038E+00,0.1855E+00,0.1679E+00,0.1511E+00,0.1350E+00,0.1199E+00,
     +0.1056E+00,0.9228E-01,0.7995E-01,0.6863E-01,0.5832E-01,0.4901E-01,
     +0.4067E-01,0.3326E-01,0.2674E-01,0.2106E-01,0.1618E-01,0.1205E-01,
     +0.8636E-02,0.5902E-02,0.3806E-02,0.2290E-02,0.1272E-02,0.6489E-03,
     +0.4162E-03,0.2678E-03,0.1737E-03,0.1138E-03,0.7495E-04,0.4922E-04,
     +0.3179E-04,0.1984E-04,0.1171E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.3908E+01,0.3765E+01,0.3627E+01,0.3494E+01,0.3365E+01,0.3240E+01,
     +0.3118E+01,0.3001E+01,0.2888E+01,0.2778E+01,0.2672E+01,0.2570E+01,
     +0.2471E+01,0.2375E+01,0.2282E+01,0.2193E+01,0.2106E+01,0.2023E+01,
     +0.1942E+01,0.1864E+01,0.1788E+01,0.1716E+01,0.1645E+01,0.1578E+01,
     +0.1512E+01,0.1449E+01,0.1388E+01,0.1329E+01,0.1273E+01,0.1218E+01,
     +0.1165E+01,0.1114E+01,0.1065E+01,0.1018E+01,0.9725E+00,0.9286E+00,
     +0.8863E+00,0.8455E+00,0.8063E+00,0.7684E+00,0.7320E+00,0.6969E+00,
     +0.6631E+00,0.6305E+00,0.5991E+00,0.5689E+00,0.5398E+00,0.5117E+00,
     +0.4847E+00,0.4586E+00,0.4335E+00,0.4092E+00,0.3859E+00,0.3634E+00,
     +0.3416E+00,0.3207E+00,0.3005E+00,0.2810E+00,0.2621E+00,0.2440E+00,
     +0.2265E+00,0.2097E+00,0.1935E+00,0.1779E+00,0.1630E+00,0.1487E+00,
     +0.1350E+00,0.1219E+00,0.1096E+00,0.9785E-01,0.8683E-01,0.7652E-01,
     +0.6692E-01,0.5804E-01,0.4989E-01,0.4248E-01,0.3578E-01,0.2979E-01,
     +0.2448E-01,0.1982E-01,0.1578E-01,0.1232E-01,0.9392E-02,0.6962E-02,
     +0.4989E-02,0.3434E-02,0.2254E-02,0.1402E-02,0.8224E-03,0.4555E-03,
     +0.3111E-03,0.2137E-03,0.1475E-03,0.1019E-03,0.7001E-04,0.4736E-04,
     +0.3117E-04,0.1966E-04,0.1167E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.3792E+01,0.3649E+01,0.3511E+01,0.3378E+01,0.3249E+01,0.3124E+01,
     +0.3003E+01,0.2885E+01,0.2772E+01,0.2663E+01,0.2557E+01,0.2454E+01,
     +0.2355E+01,0.2260E+01,0.2167E+01,0.2078E+01,0.1991E+01,0.1908E+01,
     +0.1827E+01,0.1749E+01,0.1674E+01,0.1602E+01,0.1531E+01,0.1464E+01,
     +0.1399E+01,0.1336E+01,0.1275E+01,0.1217E+01,0.1160E+01,0.1106E+01,
     +0.1054E+01,0.1003E+01,0.9547E+00,0.9080E+00,0.8630E+00,0.8197E+00,
     +0.7780E+00,0.7380E+00,0.6995E+00,0.6625E+00,0.6269E+00,0.5928E+00,
     +0.5600E+00,0.5286E+00,0.4984E+00,0.4695E+00,0.4418E+00,0.4152E+00,
     +0.3897E+00,0.3654E+00,0.3421E+00,0.3198E+00,0.2985E+00,0.2782E+00,
     +0.2588E+00,0.2403E+00,0.2227E+00,0.2059E+00,0.1900E+00,0.1748E+00,
     +0.1604E+00,0.1468E+00,0.1338E+00,0.1216E+00,0.1101E+00,0.9930E-01,
     +0.8912E-01,0.7959E-01,0.7069E-01,0.6241E-01,0.5473E-01,0.4765E-01,
     +0.4116E-01,0.3523E-01,0.2987E-01,0.2505E-01,0.2077E-01,0.1699E-01,
     +0.1370E-01,0.1087E-01,0.8482E-02,0.6492E-02,0.4869E-02,0.3571E-02,
     +0.2559E-02,0.1789E-02,0.1219E-02,0.8094E-03,0.5227E-03,0.3266E-03,
     +0.2410E-03,0.1776E-03,0.1300E-03,0.9400E-04,0.6672E-04,0.4612E-04,
     +0.3075E-04,0.1954E-04,0.1164E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.3609E+01,0.3471E+01,0.3337E+01,0.3208E+01,0.3083E+01,0.2963E+01,
     +0.2846E+01,0.2733E+01,0.2624E+01,0.2518E+01,0.2416E+01,0.2318E+01,
     +0.2222E+01,0.2130E+01,0.2041E+01,0.1956E+01,0.1873E+01,0.1793E+01,
     +0.1716E+01,0.1641E+01,0.1569E+01,0.1500E+01,0.1433E+01,0.1369E+01,
     +0.1306E+01,0.1247E+01,0.1189E+01,0.1133E+01,0.1080E+01,0.1028E+01,
     +0.9786E+00,0.9308E+00,0.8849E+00,0.8407E+00,0.7982E+00,0.7573E+00,
     +0.7180E+00,0.6803E+00,0.6441E+00,0.6093E+00,0.5759E+00,0.5439E+00,
     +0.5131E+00,0.4837E+00,0.4555E+00,0.4284E+00,0.4026E+00,0.3778E+00,
     +0.3541E+00,0.3315E+00,0.3098E+00,0.2892E+00,0.2695E+00,0.2507E+00,
     +0.2327E+00,0.2157E+00,0.1995E+00,0.1841E+00,0.1694E+00,0.1555E+00,
     +0.1424E+00,0.1300E+00,0.1182E+00,0.1072E+00,0.9676E-01,0.8699E-01,
     +0.7784E-01,0.6931E-01,0.6136E-01,0.5400E-01,0.4720E-01,0.4095E-01,
     +0.3524E-01,0.3006E-01,0.2539E-01,0.2122E-01,0.1752E-01,0.1428E-01,
     +0.1147E-01,0.9071E-02,0.7050E-02,0.5377E-02,0.4018E-02,0.2937E-02,
     +0.2097E-02,0.1462E-02,0.9926E-03,0.6564E-03,0.4216E-03,0.2614E-03,
     +0.1917E-03,0.1402E-03,0.1018E-03,0.7295E-04,0.5125E-04,0.3503E-04,
     +0.2308E-04,0.1447E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.1657E+01,0.1587E+01,0.1520E+01,0.1455E+01,0.1392E+01,0.1332E+01,
     +0.1274E+01,0.1218E+01,0.1164E+01,0.1112E+01,0.1062E+01,0.1014E+01,
     +0.9679E+00,0.9234E+00,0.8807E+00,0.8396E+00,0.8001E+00,0.7621E+00,
     +0.7257E+00,0.6906E+00,0.6570E+00,0.6247E+00,0.5938E+00,0.5640E+00,
     +0.5355E+00,0.5082E+00,0.4820E+00,0.4569E+00,0.4328E+00,0.4098E+00,
     +0.3877E+00,0.3666E+00,0.3464E+00,0.3271E+00,0.3086E+00,0.2910E+00,
     +0.2741E+00,0.2581E+00,0.2427E+00,0.2280E+00,0.2141E+00,0.2008E+00,
     +0.1881E+00,0.1760E+00,0.1645E+00,0.1536E+00,0.1432E+00,0.1333E+00,
     +0.1240E+00,0.1151E+00,0.1067E+00,0.9872E-01,0.9118E-01,0.8406E-01,
     +0.7734E-01,0.7100E-01,0.6502E-01,0.5941E-01,0.5413E-01,0.4918E-01,
     +0.4454E-01,0.4021E-01,0.3617E-01,0.3241E-01,0.2892E-01,0.2569E-01,
     +0.2271E-01,0.1996E-01,0.1745E-01,0.1516E-01,0.1307E-01,0.1119E-01,
     +0.9501E-02,0.7993E-02,0.6659E-02,0.5487E-02,0.4468E-02,0.3591E-02,
     +0.2845E-02,0.2219E-02,0.1702E-02,0.1281E-02,0.9448E-03,0.6818E-03,
     +0.4804E-03,0.3299E-03,0.2202E-03,0.1425E-03,0.8886E-04,0.5290E-04,
     +0.3759E-04,0.2653E-04,0.1851E-04,0.1270E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.2081E-01,0.2195E-01,0.2316E-01,0.2443E-01,0.2577E-01,0.2718E-01,
     +0.2867E-01,0.3023E-01,0.3188E-01,0.3362E-01,0.3544E-01,0.3737E-01,
     +0.3939E-01,0.4152E-01,0.4377E-01,0.4613E-01,0.4861E-01,0.5122E-01,
     +0.5397E-01,0.5685E-01,0.5989E-01,0.6307E-01,0.6642E-01,0.6994E-01,
     +0.7363E-01,0.7751E-01,0.8158E-01,0.8585E-01,0.9033E-01,0.9502E-01,
     +0.9994E-01,0.1051E+00,0.1105E+00,0.1161E+00,0.1220E+00,0.1282E+00,
     +0.1347E+00,0.1414E+00,0.1484E+00,0.1558E+00,0.1634E+00,0.1714E+00,
     +0.1797E+00,0.1883E+00,0.1972E+00,0.2065E+00,0.2161E+00,0.2260E+00,
     +0.2362E+00,0.2468E+00,0.2577E+00,0.2688E+00,0.2803E+00,0.2920E+00,
     +0.3039E+00,0.3160E+00,0.3283E+00,0.3406E+00,0.3531E+00,0.3655E+00,
     +0.3778E+00,0.3899E+00,0.4018E+00,0.4132E+00,0.4241E+00,0.4344E+00,
     +0.4438E+00,0.4522E+00,0.4593E+00,0.4651E+00,0.4692E+00,0.4714E+00,
     +0.4715E+00,0.4692E+00,0.4642E+00,0.4564E+00,0.4454E+00,0.4311E+00,
     +0.4134E+00,0.3922E+00,0.3676E+00,0.3398E+00,0.3090E+00,0.2757E+00,
     +0.2407E+00,0.2048E+00,0.1689E+00,0.1342E+00,0.1018E+00,0.7294E-01,
     +0.5762E-01,0.4480E-01,0.3420E-01,0.2556E-01,0.1863E-01,0.1316E-01,
     +0.8939E-02,0.5779E-02,0.3497E-02,0.1931E-02,0.9331E-03,0.3643E-03,
     +0.9588E-04,0.0000E+00/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1182E-01,0.1246E-01,0.1315E-01,0.1387E-01,0.1462E-01,0.1542E-01,
     +0.1626E-01,0.1714E-01,0.1808E-01,0.1906E-01,0.2009E-01,0.2117E-01,
     +0.2231E-01,0.2351E-01,0.2478E-01,0.2611E-01,0.2750E-01,0.2897E-01,
     +0.3051E-01,0.3214E-01,0.3384E-01,0.3563E-01,0.3750E-01,0.3947E-01,
     +0.4154E-01,0.4371E-01,0.4598E-01,0.4836E-01,0.5085E-01,0.5346E-01,
     +0.5620E-01,0.5906E-01,0.6205E-01,0.6517E-01,0.6844E-01,0.7184E-01,
     +0.7539E-01,0.7910E-01,0.8295E-01,0.8696E-01,0.9113E-01,0.9546E-01,
     +0.9994E-01,0.1046E+00,0.1094E+00,0.1144E+00,0.1195E+00,0.1248E+00,
     +0.1302E+00,0.1357E+00,0.1414E+00,0.1472E+00,0.1531E+00,0.1591E+00,
     +0.1651E+00,0.1712E+00,0.1773E+00,0.1833E+00,0.1893E+00,0.1951E+00,
     +0.2008E+00,0.2063E+00,0.2114E+00,0.2162E+00,0.2206E+00,0.2244E+00,
     +0.2276E+00,0.2300E+00,0.2317E+00,0.2324E+00,0.2320E+00,0.2304E+00,
     +0.2276E+00,0.2233E+00,0.2176E+00,0.2104E+00,0.2015E+00,0.1910E+00,
     +0.1790E+00,0.1655E+00,0.1507E+00,0.1348E+00,0.1181E+00,0.1011E+00,
     +0.8411E-01,0.6772E-01,0.5240E-01,0.3864E-01,0.2684E-01,0.1730E-01,
     +0.1268E-01,0.9102E-02,0.6380E-02,0.4348E-02,0.2866E-02,0.1814E-02,
     +0.1091E-02,0.6150E-03,0.3180E-03,0.1460E-03,0.5632E-04,0.1641E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1461E+03,0.1398E+03,0.1338E+03,0.1281E+03,0.1225E+03,0.1171E+03,
     +0.1120E+03,0.1070E+03,0.1022E+03,0.9766E+02,0.9324E+02,0.8899E+02,
     +0.8491E+02,0.8098E+02,0.7721E+02,0.7359E+02,0.7011E+02,0.6677E+02,
     +0.6356E+02,0.6049E+02,0.5753E+02,0.5470E+02,0.5199E+02,0.4938E+02,
     +0.4689E+02,0.4450E+02,0.4221E+02,0.4002E+02,0.3792E+02,0.3591E+02,
     +0.3399E+02,0.3215E+02,0.3040E+02,0.2872E+02,0.2712E+02,0.2559E+02,
     +0.2413E+02,0.2273E+02,0.2140E+02,0.2014E+02,0.1893E+02,0.1778E+02,
     +0.1668E+02,0.1564E+02,0.1464E+02,0.1370E+02,0.1280E+02,0.1195E+02,
     +0.1114E+02,0.1037E+02,0.9642E+01,0.8952E+01,0.8297E+01,0.7678E+01,
     +0.7092E+01,0.6538E+01,0.6015E+01,0.5522E+01,0.5057E+01,0.4619E+01,
     +0.4207E+01,0.3821E+01,0.3459E+01,0.3120E+01,0.2804E+01,0.2509E+01,
     +0.2236E+01,0.1982E+01,0.1748E+01,0.1533E+01,0.1336E+01,0.1156E+01,
     +0.9924E+00,0.8452E+00,0.7133E+00,0.5959E+00,0.4923E+00,0.4016E+00,
     +0.3231E+00,0.2558E+00,0.1989E+00,0.1514E+00,0.1125E+00,0.8109E-01,
     +0.5636E-01,0.3738E-01,0.2327E-01,0.1321E-01,0.6393E-02,0.2113E-02,
     +0.4878E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.2791E+02,0.2681E+02,0.2576E+02,0.2473E+02,0.2375E+02,0.2280E+02,
     +0.2188E+02,0.2099E+02,0.2014E+02,0.1932E+02,0.1852E+02,0.1776E+02,
     +0.1702E+02,0.1631E+02,0.1562E+02,0.1496E+02,0.1432E+02,0.1371E+02,
     +0.1312E+02,0.1255E+02,0.1200E+02,0.1148E+02,0.1097E+02,0.1048E+02,
     +0.1002E+02,0.9565E+01,0.9131E+01,0.8714E+01,0.8314E+01,0.7929E+01,
     +0.7559E+01,0.7203E+01,0.6862E+01,0.6534E+01,0.6219E+01,0.5917E+01,
     +0.5627E+01,0.5348E+01,0.5081E+01,0.4825E+01,0.4579E+01,0.4342E+01,
     +0.4116E+01,0.3899E+01,0.3690E+01,0.3490E+01,0.3298E+01,0.3114E+01,
     +0.2938E+01,0.2768E+01,0.2606E+01,0.2450E+01,0.2300E+01,0.2157E+01,
     +0.2019E+01,0.1887E+01,0.1760E+01,0.1638E+01,0.1522E+01,0.1410E+01,
     +0.1303E+01,0.1200E+01,0.1102E+01,0.1008E+01,0.9191E+00,0.8341E+00,
     +0.7534E+00,0.6771E+00,0.6051E+00,0.5376E+00,0.4744E+00,0.4158E+00,
     +0.3616E+00,0.3118E+00,0.2665E+00,0.2256E+00,0.1889E+00,0.1564E+00,
     +0.1277E+00,0.1027E+00,0.8124E-01,0.6294E-01,0.4760E-01,0.3497E-01,
     +0.2481E-01,0.1688E-01,0.1094E-01,0.6703E-02,0.3865E-02,0.2097E-02,
     +0.1412E-02,0.9551E-03,0.6487E-03,0.4406E-03,0.2972E-03,0.1972E-03,
     +0.1271E-03,0.7842E-04,0.4541E-04,0.2404E-04,0.1117E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.5202E+01,0.5006E+01,0.4818E+01,0.4635E+01,0.4459E+01,0.4289E+01,
     +0.4125E+01,0.3967E+01,0.3814E+01,0.3667E+01,0.3524E+01,0.3387E+01,
     +0.3255E+01,0.3127E+01,0.3004E+01,0.2885E+01,0.2771E+01,0.2660E+01,
     +0.2554E+01,0.2451E+01,0.2353E+01,0.2258E+01,0.2166E+01,0.2078E+01,
     +0.1993E+01,0.1911E+01,0.1832E+01,0.1756E+01,0.1683E+01,0.1613E+01,
     +0.1545E+01,0.1480E+01,0.1417E+01,0.1357E+01,0.1299E+01,0.1243E+01,
     +0.1189E+01,0.1137E+01,0.1087E+01,0.1039E+01,0.9929E+00,0.9482E+00,
     +0.9052E+00,0.8637E+00,0.8237E+00,0.7851E+00,0.7478E+00,0.7117E+00,
     +0.6769E+00,0.6432E+00,0.6106E+00,0.5789E+00,0.5483E+00,0.5186E+00,
     +0.4897E+00,0.4617E+00,0.4345E+00,0.4080E+00,0.3823E+00,0.3573E+00,
     +0.3330E+00,0.3095E+00,0.2866E+00,0.2644E+00,0.2430E+00,0.2223E+00,
     +0.2024E+00,0.1833E+00,0.1651E+00,0.1478E+00,0.1314E+00,0.1160E+00,
     +0.1017E+00,0.8839E-01,0.7617E-01,0.6501E-01,0.5492E-01,0.4586E-01,
     +0.3780E-01,0.3070E-01,0.2449E-01,0.1913E-01,0.1456E-01,0.1074E-01,
     +0.7620E-02,0.5153E-02,0.3289E-02,0.1960E-02,0.1080E-02,0.5487E-03,
     +0.3518E-03,0.2265E-03,0.1470E-03,0.9618E-04,0.6311E-04,0.4114E-04,
     +0.2627E-04,0.1616E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.5028E+01,0.4832E+01,0.4644E+01,0.4462E+01,0.4286E+01,0.4116E+01,
     +0.3952E+01,0.3794E+01,0.3641E+01,0.3494E+01,0.3352E+01,0.3214E+01,
     +0.3082E+01,0.2955E+01,0.2832E+01,0.2713E+01,0.2599E+01,0.2489E+01,
     +0.2383E+01,0.2280E+01,0.2182E+01,0.2087E+01,0.1996E+01,0.1908E+01,
     +0.1823E+01,0.1742E+01,0.1664E+01,0.1588E+01,0.1516E+01,0.1446E+01,
     +0.1379E+01,0.1315E+01,0.1253E+01,0.1193E+01,0.1136E+01,0.1081E+01,
     +0.1028E+01,0.9777E+00,0.9290E+00,0.8823E+00,0.8374E+00,0.7944E+00,
     +0.7530E+00,0.7133E+00,0.6753E+00,0.6387E+00,0.6036E+00,0.5700E+00,
     +0.5377E+00,0.5067E+00,0.4769E+00,0.4483E+00,0.4209E+00,0.3946E+00,
     +0.3694E+00,0.3452E+00,0.3219E+00,0.2996E+00,0.2783E+00,0.2578E+00,
     +0.2381E+00,0.2194E+00,0.2014E+00,0.1842E+00,0.1679E+00,0.1524E+00,
     +0.1376E+00,0.1236E+00,0.1105E+00,0.9815E-01,0.8661E-01,0.7588E-01,
     +0.6598E-01,0.5689E-01,0.4860E-01,0.4112E-01,0.3441E-01,0.2846E-01,
     +0.2322E-01,0.1867E-01,0.1475E-01,0.1142E-01,0.8629E-02,0.6340E-02,
     +0.4502E-02,0.3071E-02,0.1999E-02,0.1234E-02,0.7202E-03,0.3974E-03,
     +0.2708E-03,0.1855E-03,0.1275E-03,0.8753E-04,0.5959E-04,0.3984E-04,
     +0.2585E-04,0.1604E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.4912E+01,0.4716E+01,0.4528E+01,0.4346E+01,0.4170E+01,0.4000E+01,
     +0.3836E+01,0.3678E+01,0.3525E+01,0.3378E+01,0.3236E+01,0.3099E+01,
     +0.2967E+01,0.2839E+01,0.2717E+01,0.2598E+01,0.2484E+01,0.2374E+01,
     +0.2268E+01,0.2166E+01,0.2068E+01,0.1973E+01,0.1882E+01,0.1795E+01,
     +0.1710E+01,0.1629E+01,0.1551E+01,0.1476E+01,0.1404E+01,0.1335E+01,
     +0.1268E+01,0.1204E+01,0.1143E+01,0.1084E+01,0.1028E+01,0.9732E+00,
     +0.9212E+00,0.8713E+00,0.8235E+00,0.7776E+00,0.7338E+00,0.6917E+00,
     +0.6515E+00,0.6130E+00,0.5763E+00,0.5411E+00,0.5075E+00,0.4754E+00,
     +0.4448E+00,0.4156E+00,0.3878E+00,0.3613E+00,0.3360E+00,0.3120E+00,
     +0.2892E+00,0.2675E+00,0.2469E+00,0.2274E+00,0.2089E+00,0.1914E+00,
     +0.1749E+00,0.1593E+00,0.1446E+00,0.1308E+00,0.1179E+00,0.1058E+00,
     +0.9446E-01,0.8392E-01,0.7413E-01,0.6509E-01,0.5676E-01,0.4914E-01,
     +0.4219E-01,0.3590E-01,0.3025E-01,0.2521E-01,0.2076E-01,0.1687E-01,
     +0.1351E-01,0.1065E-01,0.8255E-02,0.6276E-02,0.4675E-02,0.3406E-02,
     +0.2424E-02,0.1683E-02,0.1139E-02,0.7506E-03,0.4803E-03,0.2966E-03,
     +0.2169E-03,0.1582E-03,0.1145E-03,0.8176E-04,0.5724E-04,0.3898E-04,
     +0.2557E-04,0.1596E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.4732E+01,0.4542E+01,0.4358E+01,0.4180E+01,0.4008E+01,0.3843E+01,
     +0.3683E+01,0.3529E+01,0.3380E+01,0.3237E+01,0.3099E+01,0.2966E+01,
     +0.2837E+01,0.2713E+01,0.2594E+01,0.2479E+01,0.2369E+01,0.2262E+01,
     +0.2160E+01,0.2061E+01,0.1966E+01,0.1874E+01,0.1787E+01,0.1702E+01,
     +0.1621E+01,0.1543E+01,0.1467E+01,0.1395E+01,0.1326E+01,0.1259E+01,
     +0.1195E+01,0.1134E+01,0.1075E+01,0.1019E+01,0.9647E+00,0.9128E+00,
     +0.8631E+00,0.8155E+00,0.7699E+00,0.7262E+00,0.6844E+00,0.6445E+00,
     +0.6063E+00,0.5697E+00,0.5349E+00,0.5016E+00,0.4698E+00,0.4395E+00,
     +0.4106E+00,0.3830E+00,0.3568E+00,0.3319E+00,0.3082E+00,0.2856E+00,
     +0.2642E+00,0.2440E+00,0.2247E+00,0.2066E+00,0.1894E+00,0.1731E+00,
     +0.1578E+00,0.1434E+00,0.1299E+00,0.1172E+00,0.1053E+00,0.9423E-01,
     +0.8390E-01,0.7432E-01,0.6545E-01,0.5729E-01,0.4980E-01,0.4296E-01,
     +0.3676E-01,0.3117E-01,0.2617E-01,0.2173E-01,0.1783E-01,0.1444E-01,
     +0.1152E-01,0.9049E-02,0.6986E-02,0.5292E-02,0.3928E-02,0.2852E-02,
     +0.2023E-02,0.1400E-02,0.9440E-03,0.6191E-03,0.3937E-03,0.2411E-03,
     +0.1751E-03,0.1267E-03,0.9090E-04,0.6428E-04,0.4452E-04,0.2996E-04,
     +0.1940E-04,0.1194E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.2836E+01,0.2712E+01,0.2592E+01,0.2477E+01,0.2366E+01,0.2259E+01,
     +0.2157E+01,0.2059E+01,0.1964E+01,0.1873E+01,0.1786E+01,0.1702E+01,
     +0.1621E+01,0.1544E+01,0.1469E+01,0.1398E+01,0.1330E+01,0.1264E+01,
     +0.1201E+01,0.1141E+01,0.1083E+01,0.1028E+01,0.9750E+00,0.9242E+00,
     +0.8757E+00,0.8292E+00,0.7848E+00,0.7423E+00,0.7016E+00,0.6628E+00,
     +0.6257E+00,0.5903E+00,0.5565E+00,0.5243E+00,0.4935E+00,0.4642E+00,
     +0.4362E+00,0.4096E+00,0.3843E+00,0.3601E+00,0.3372E+00,0.3154E+00,
     +0.2947E+00,0.2750E+00,0.2564E+00,0.2387E+00,0.2219E+00,0.2060E+00,
     +0.1910E+00,0.1768E+00,0.1633E+00,0.1507E+00,0.1387E+00,0.1274E+00,
     +0.1169E+00,0.1069E+00,0.9757E-01,0.8881E-01,0.8062E-01,0.7297E-01,
     +0.6583E-01,0.5919E-01,0.5302E-01,0.4731E-01,0.4203E-01,0.3717E-01,
     +0.3270E-01,0.2861E-01,0.2489E-01,0.2151E-01,0.1845E-01,0.1571E-01,
     +0.1327E-01,0.1110E-01,0.9194E-02,0.7531E-02,0.6096E-02,0.4870E-02,
     +0.3834E-02,0.2972E-02,0.2265E-02,0.1693E-02,0.1241E-02,0.8890E-03,
     +0.6219E-03,0.4236E-03,0.2803E-03,0.1794E-03,0.1104E-03,0.6465E-04,
     +0.4537E-04,0.3159E-04,0.2172E-04,0.1466E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.2223E-01,0.2345E-01,0.2473E-01,0.2608E-01,0.2750E-01,0.2899E-01,
     +0.3057E-01,0.3222E-01,0.3397E-01,0.3581E-01,0.3774E-01,0.3977E-01,
     +0.4191E-01,0.4416E-01,0.4652E-01,0.4901E-01,0.5162E-01,0.5437E-01,
     +0.5726E-01,0.6029E-01,0.6347E-01,0.6681E-01,0.7032E-01,0.7401E-01,
     +0.7787E-01,0.8192E-01,0.8617E-01,0.9062E-01,0.9528E-01,0.1002E+00,
     +0.1053E+00,0.1106E+00,0.1162E+00,0.1221E+00,0.1282E+00,0.1345E+00,
     +0.1412E+00,0.1481E+00,0.1553E+00,0.1628E+00,0.1707E+00,0.1788E+00,
     +0.1872E+00,0.1960E+00,0.2050E+00,0.2144E+00,0.2241E+00,0.2341E+00,
     +0.2444E+00,0.2550E+00,0.2658E+00,0.2769E+00,0.2883E+00,0.2998E+00,
     +0.3116E+00,0.3234E+00,0.3354E+00,0.3474E+00,0.3593E+00,0.3712E+00,
     +0.3829E+00,0.3943E+00,0.4053E+00,0.4159E+00,0.4258E+00,0.4349E+00,
     +0.4431E+00,0.4502E+00,0.4559E+00,0.4602E+00,0.4627E+00,0.4632E+00,
     +0.4615E+00,0.4574E+00,0.4507E+00,0.4411E+00,0.4285E+00,0.4127E+00,
     +0.3937E+00,0.3714E+00,0.3461E+00,0.3178E+00,0.2870E+00,0.2543E+00,
     +0.2203E+00,0.1858E+00,0.1518E+00,0.1194E+00,0.8954E-01,0.6329E-01,
     +0.4954E-01,0.3815E-01,0.2883E-01,0.2132E-01,0.1535E-01,0.1070E-01,
     +0.7160E-02,0.4549E-02,0.2697E-02,0.1452E-02,0.6783E-03,0.2520E-03,
     +0.6048E-04,0.0000E+00/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.1261E-01,0.1330E-01,0.1402E-01,0.1479E-01,0.1559E-01,0.1643E-01,
     +0.1732E-01,0.1826E-01,0.1924E-01,0.2027E-01,0.2136E-01,0.2251E-01,
     +0.2371E-01,0.2498E-01,0.2631E-01,0.2770E-01,0.2917E-01,0.3071E-01,
     +0.3233E-01,0.3403E-01,0.3581E-01,0.3768E-01,0.3964E-01,0.4170E-01,
     +0.4385E-01,0.4611E-01,0.4847E-01,0.5095E-01,0.5354E-01,0.5624E-01,
     +0.5907E-01,0.6203E-01,0.6512E-01,0.6834E-01,0.7170E-01,0.7519E-01,
     +0.7884E-01,0.8263E-01,0.8657E-01,0.9066E-01,0.9490E-01,0.9929E-01,
     +0.1038E+00,0.1085E+00,0.1134E+00,0.1184E+00,0.1235E+00,0.1288E+00,
     +0.1342E+00,0.1397E+00,0.1453E+00,0.1511E+00,0.1568E+00,0.1627E+00,
     +0.1685E+00,0.1744E+00,0.1802E+00,0.1860E+00,0.1916E+00,0.1971E+00,
     +0.2024E+00,0.2074E+00,0.2120E+00,0.2163E+00,0.2200E+00,0.2232E+00,
     +0.2257E+00,0.2274E+00,0.2282E+00,0.2281E+00,0.2269E+00,0.2245E+00,
     +0.2208E+00,0.2158E+00,0.2093E+00,0.2014E+00,0.1919E+00,0.1810E+00,
     +0.1686E+00,0.1549E+00,0.1402E+00,0.1245E+00,0.1083E+00,0.9197E-01,
     +0.7589E-01,0.6053E-01,0.4637E-01,0.3381E-01,0.2320E-01,0.1473E-01,
     +0.1069E-01,0.7599E-02,0.5268E-02,0.3548E-02,0.2309E-02,0.1440E-02,
     +0.8524E-03,0.4714E-03,0.2383E-03,0.1063E-03,0.3942E-04,0.1080E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.1748E+03,0.1669E+03,0.1593E+03,0.1520E+03,0.1450E+03,0.1383E+03,
     +0.1318E+03,0.1256E+03,0.1197E+03,0.1139E+03,0.1085E+03,0.1032E+03,
     +0.9820E+02,0.9338E+02,0.8876E+02,0.8434E+02,0.8011E+02,0.7606E+02,
     +0.7218E+02,0.6847E+02,0.6492E+02,0.6152E+02,0.5828E+02,0.5518E+02,
     +0.5222E+02,0.4939E+02,0.4669E+02,0.4411E+02,0.4166E+02,0.3931E+02,
     +0.3708E+02,0.3495E+02,0.3292E+02,0.3099E+02,0.2915E+02,0.2740E+02,
     +0.2574E+02,0.2416E+02,0.2266E+02,0.2123E+02,0.1988E+02,0.1859E+02,
     +0.1737E+02,0.1622E+02,0.1512E+02,0.1409E+02,0.1311E+02,0.1218E+02,
     +0.1130E+02,0.1048E+02,0.9694E+01,0.8957E+01,0.8262E+01,0.7608E+01,
     +0.6993E+01,0.6414E+01,0.5871E+01,0.5361E+01,0.4884E+01,0.4437E+01,
     +0.4020E+01,0.3630E+01,0.3268E+01,0.2931E+01,0.2619E+01,0.2330E+01,
     +0.2064E+01,0.1819E+01,0.1595E+01,0.1390E+01,0.1204E+01,0.1035E+01,
     +0.8837E+00,0.7480E+00,0.6274E+00,0.5210E+00,0.4278E+00,0.3469E+00,
     +0.2774E+00,0.2183E+00,0.1687E+00,0.1276E+00,0.9409E-01,0.6730E-01,
     +0.4635E-01,0.3039E-01,0.1863E-01,0.1032E-01,0.4767E-02,0.1347E-02,
     +0.8299E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.3478E+02,0.3334E+02,0.3195E+02,0.3062E+02,0.2933E+02,0.2810E+02,
     +0.2691E+02,0.2576E+02,0.2465E+02,0.2359E+02,0.2257E+02,0.2159E+02,
     +0.2064E+02,0.1973E+02,0.1886E+02,0.1801E+02,0.1721E+02,0.1643E+02,
     +0.1568E+02,0.1497E+02,0.1428E+02,0.1362E+02,0.1298E+02,0.1237E+02,
     +0.1179E+02,0.1123E+02,0.1069E+02,0.1018E+02,0.9681E+01,0.9207E+01,
     +0.8752E+01,0.8317E+01,0.7900E+01,0.7500E+01,0.7118E+01,0.6752E+01,
     +0.6401E+01,0.6065E+01,0.5744E+01,0.5437E+01,0.5143E+01,0.4862E+01,
     +0.4593E+01,0.4336E+01,0.4090E+01,0.3855E+01,0.3630E+01,0.3415E+01,
     +0.3210E+01,0.3014E+01,0.2826E+01,0.2647E+01,0.2476E+01,0.2313E+01,
     +0.2156E+01,0.2007E+01,0.1864E+01,0.1728E+01,0.1599E+01,0.1475E+01,
     +0.1357E+01,0.1244E+01,0.1138E+01,0.1036E+01,0.9402E+00,0.8493E+00,
     +0.7636E+00,0.6830E+00,0.6075E+00,0.5370E+00,0.4716E+00,0.4112E+00,
     +0.3558E+00,0.3053E+00,0.2595E+00,0.2185E+00,0.1819E+00,0.1497E+00,
     +0.1215E+00,0.9710E-01,0.7625E-01,0.5866E-01,0.4403E-01,0.3209E-01,
     +0.2258E-01,0.1525E-01,0.9805E-02,0.5967E-02,0.3422E-02,0.1849E-02,
     +0.1242E-02,0.8376E-03,0.5665E-03,0.3824E-03,0.2558E-03,0.1680E-03,
     +0.1069E-03,0.6499E-04,0.3701E-04,0.1922E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.6337E+01,0.6085E+01,0.5842E+01,0.5608E+01,0.5382E+01,0.5165E+01,
     +0.4955E+01,0.4754E+01,0.4559E+01,0.4372E+01,0.4192E+01,0.4019E+01,
     +0.3852E+01,0.3691E+01,0.3537E+01,0.3388E+01,0.3245E+01,0.3108E+01,
     +0.2975E+01,0.2848E+01,0.2726E+01,0.2609E+01,0.2496E+01,0.2387E+01,
     +0.2283E+01,0.2183E+01,0.2087E+01,0.1995E+01,0.1906E+01,0.1821E+01,
     +0.1739E+01,0.1661E+01,0.1586E+01,0.1513E+01,0.1444E+01,0.1377E+01,
     +0.1313E+01,0.1252E+01,0.1193E+01,0.1137E+01,0.1082E+01,0.1030E+01,
     +0.9802E+00,0.9320E+00,0.8858E+00,0.8413E+00,0.7984E+00,0.7572E+00,
     +0.7176E+00,0.6794E+00,0.6425E+00,0.6070E+00,0.5727E+00,0.5396E+00,
     +0.5077E+00,0.4768E+00,0.4469E+00,0.4181E+00,0.3902E+00,0.3632E+00,
     +0.3372E+00,0.3120E+00,0.2878E+00,0.2644E+00,0.2420E+00,0.2204E+00,
     +0.1999E+00,0.1803E+00,0.1616E+00,0.1441E+00,0.1276E+00,0.1121E+00,
     +0.9783E-01,0.8464E-01,0.7259E-01,0.6166E-01,0.5182E-01,0.4304E-01,
     +0.3527E-01,0.2847E-01,0.2256E-01,0.1750E-01,0.1322E-01,0.9669E-02,
     +0.6799E-02,0.4557E-02,0.2882E-02,0.1703E-02,0.9321E-03,0.4713E-03,
     +0.3018E-03,0.1942E-03,0.1259E-03,0.8217E-04,0.5366E-04,0.3471E-04,
     +0.2194E-04,0.1331E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.6163E+01,0.5911E+01,0.5668E+01,0.5434E+01,0.5209E+01,0.4991E+01,
     +0.4782E+01,0.4580E+01,0.4386E+01,0.4199E+01,0.4019E+01,0.3846E+01,
     +0.3680E+01,0.3519E+01,0.3365E+01,0.3216E+01,0.3074E+01,0.2936E+01,
     +0.2805E+01,0.2678E+01,0.2556E+01,0.2439E+01,0.2326E+01,0.2218E+01,
     +0.2115E+01,0.2015E+01,0.1919E+01,0.1828E+01,0.1740E+01,0.1655E+01,
     +0.1574E+01,0.1497E+01,0.1422E+01,0.1351E+01,0.1283E+01,0.1217E+01,
     +0.1154E+01,0.1094E+01,0.1037E+01,0.9817E+00,0.9289E+00,0.8784E+00,
     +0.8301E+00,0.7839E+00,0.7397E+00,0.6974E+00,0.6569E+00,0.6182E+00,
     +0.5812E+00,0.5458E+00,0.5119E+00,0.4796E+00,0.4486E+00,0.4190E+00,
     +0.3908E+00,0.3638E+00,0.3380E+00,0.3134E+00,0.2898E+00,0.2674E+00,
     +0.2461E+00,0.2257E+00,0.2064E+00,0.1880E+00,0.1706E+00,0.1541E+00,
     +0.1385E+00,0.1239E+00,0.1102E+00,0.9746E-01,0.8560E-01,0.7464E-01,
     +0.6458E-01,0.5540E-01,0.4709E-01,0.3963E-01,0.3298E-01,0.2712E-01,
     +0.2200E-01,0.1757E-01,0.1379E-01,0.1060E-01,0.7956E-02,0.5801E-02,
     +0.4087E-02,0.2767E-02,0.1788E-02,0.1097E-02,0.6365E-03,0.3496E-03,
     +0.2376E-03,0.1621E-03,0.1109E-03,0.7562E-04,0.5104E-04,0.3377E-04,
     +0.2164E-04,0.1323E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.6047E+01,0.5795E+01,0.5552E+01,0.5318E+01,0.5093E+01,0.4876E+01,
     +0.4666E+01,0.4465E+01,0.4271E+01,0.4084E+01,0.3904E+01,0.3731E+01,
     +0.3565E+01,0.3404E+01,0.3250E+01,0.3102E+01,0.2959E+01,0.2822E+01,
     +0.2690E+01,0.2564E+01,0.2442E+01,0.2325E+01,0.2213E+01,0.2105E+01,
     +0.2002E+01,0.1903E+01,0.1808E+01,0.1716E+01,0.1629E+01,0.1545E+01,
     +0.1464E+01,0.1387E+01,0.1313E+01,0.1243E+01,0.1175E+01,0.1110E+01,
     +0.1048E+01,0.9890E+00,0.9324E+00,0.8782E+00,0.8265E+00,0.7772E+00,
     +0.7300E+00,0.6851E+00,0.6422E+00,0.6014E+00,0.5625E+00,0.5254E+00,
     +0.4902E+00,0.4567E+00,0.4248E+00,0.3946E+00,0.3659E+00,0.3386E+00,
     +0.3129E+00,0.2884E+00,0.2654E+00,0.2435E+00,0.2230E+00,0.2036E+00,
     +0.1853E+00,0.1682E+00,0.1521E+00,0.1370E+00,0.1230E+00,0.1099E+00,
     +0.9770E-01,0.8642E-01,0.7600E-01,0.6642E-01,0.5765E-01,0.4966E-01,
     +0.4243E-01,0.3592E-01,0.3011E-01,0.2496E-01,0.2044E-01,0.1652E-01,
     +0.1316E-01,0.1032E-01,0.7948E-02,0.6008E-02,0.4449E-02,0.3223E-02,
     +0.2280E-02,0.1574E-02,0.1059E-02,0.6926E-03,0.4394E-03,0.2684E-03,
     +0.1947E-03,0.1408E-03,0.1009E-03,0.7125E-04,0.4929E-04,0.3314E-04,
     +0.2144E-04,0.1318E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.5871E+01,0.5624E+01,0.5385E+01,0.5156E+01,0.4934E+01,0.4721E+01,
     +0.4516E+01,0.4319E+01,0.4129E+01,0.3946E+01,0.3770E+01,0.3600E+01,
     +0.3438E+01,0.3281E+01,0.3130E+01,0.2986E+01,0.2846E+01,0.2713E+01,
     +0.2584E+01,0.2461E+01,0.2343E+01,0.2229E+01,0.2120E+01,0.2015E+01,
     +0.1915E+01,0.1818E+01,0.1726E+01,0.1637E+01,0.1552E+01,0.1471E+01,
     +0.1393E+01,0.1319E+01,0.1247E+01,0.1179E+01,0.1114E+01,0.1051E+01,
     +0.9918E+00,0.9348E+00,0.8803E+00,0.8283E+00,0.7787E+00,0.7313E+00,
     +0.6862E+00,0.6432E+00,0.6022E+00,0.5631E+00,0.5260E+00,0.4907E+00,
     +0.4571E+00,0.4252E+00,0.3950E+00,0.3663E+00,0.3391E+00,0.3133E+00,
     +0.2889E+00,0.2659E+00,0.2441E+00,0.2236E+00,0.2043E+00,0.1861E+00,
     +0.1691E+00,0.1531E+00,0.1381E+00,0.1241E+00,0.1111E+00,0.9898E-01,
     +0.8776E-01,0.7740E-01,0.6786E-01,0.5912E-01,0.5115E-01,0.4392E-01,
     +0.3740E-01,0.3155E-01,0.2635E-01,0.2177E-01,0.1776E-01,0.1431E-01,
     +0.1135E-01,0.8868E-02,0.6808E-02,0.5128E-02,0.3784E-02,0.2732E-02,
     +0.1926E-02,0.1325E-02,0.8875E-03,0.5777E-03,0.3641E-03,0.2203E-03,
     +0.1587E-03,0.1137E-03,0.8074E-04,0.5645E-04,0.3862E-04,0.2564E-04,
     +0.1637E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.4022E+01,0.3840E+01,0.3665E+01,0.3496E+01,0.3335E+01,0.3179E+01,
     +0.3030E+01,0.2887E+01,0.2750E+01,0.2618E+01,0.2492E+01,0.2371E+01,
     +0.2255E+01,0.2143E+01,0.2037E+01,0.1934E+01,0.1837E+01,0.1743E+01,
     +0.1653E+01,0.1568E+01,0.1486E+01,0.1407E+01,0.1332E+01,0.1260E+01,
     +0.1192E+01,0.1127E+01,0.1064E+01,0.1005E+01,0.9477E+00,0.8935E+00,
     +0.8418E+00,0.7925E+00,0.7456E+00,0.7009E+00,0.6584E+00,0.6180E+00,
     +0.5795E+00,0.5430E+00,0.5082E+00,0.4753E+00,0.4440E+00,0.4143E+00,
     +0.3862E+00,0.3596E+00,0.3343E+00,0.3105E+00,0.2879E+00,0.2666E+00,
     +0.2465E+00,0.2276E+00,0.2097E+00,0.1929E+00,0.1771E+00,0.1623E+00,
     +0.1484E+00,0.1353E+00,0.1231E+00,0.1117E+00,0.1011E+00,0.9119E-01,
     +0.8199E-01,0.7346E-01,0.6557E-01,0.5829E-01,0.5159E-01,0.4545E-01,
     +0.3983E-01,0.3471E-01,0.3006E-01,0.2587E-01,0.2210E-01,0.1873E-01,
     +0.1575E-01,0.1311E-01,0.1081E-01,0.8810E-02,0.7095E-02,0.5639E-02,
     +0.4417E-02,0.3406E-02,0.2581E-02,0.1919E-02,0.1398E-02,0.9956E-03,
     +0.6919E-03,0.4680E-03,0.3071E-03,0.1947E-03,0.1184E-03,0.6829E-04,
     +0.4740E-04,0.3261E-04,0.2213E-04,0.1473E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.2357E-01,0.2486E-01,0.2621E-01,0.2763E-01,0.2912E-01,0.3070E-01,
     +0.3235E-01,0.3410E-01,0.3593E-01,0.3786E-01,0.3989E-01,0.4202E-01,
     +0.4426E-01,0.4662E-01,0.4910E-01,0.5170E-01,0.5443E-01,0.5730E-01,
     +0.6032E-01,0.6348E-01,0.6680E-01,0.7028E-01,0.7394E-01,0.7777E-01,
     +0.8178E-01,0.8599E-01,0.9039E-01,0.9500E-01,0.9983E-01,0.1049E+00,
     +0.1102E+00,0.1157E+00,0.1214E+00,0.1274E+00,0.1337E+00,0.1403E+00,
     +0.1471E+00,0.1542E+00,0.1615E+00,0.1692E+00,0.1772E+00,0.1854E+00,
     +0.1940E+00,0.2029E+00,0.2120E+00,0.2215E+00,0.2312E+00,0.2413E+00,
     +0.2516E+00,0.2621E+00,0.2729E+00,0.2839E+00,0.2952E+00,0.3065E+00,
     +0.3181E+00,0.3296E+00,0.3413E+00,0.3529E+00,0.3644E+00,0.3757E+00,
     +0.3868E+00,0.3975E+00,0.4078E+00,0.4175E+00,0.4265E+00,0.4346E+00,
     +0.4416E+00,0.4475E+00,0.4520E+00,0.4548E+00,0.4559E+00,0.4550E+00,
     +0.4518E+00,0.4463E+00,0.4380E+00,0.4270E+00,0.4131E+00,0.3961E+00,
     +0.3761E+00,0.3530E+00,0.3272E+00,0.2988E+00,0.2682E+00,0.2361E+00,
     +0.2030E+00,0.1699E+00,0.1377E+00,0.1073E+00,0.7966E-01,0.5565E-01,
     +0.4321E-01,0.3299E-01,0.2471E-01,0.1809E-01,0.1288E-01,0.8875E-02,
     +0.5861E-02,0.3666E-02,0.2133E-02,0.1122E-02,0.5084E-03,0.1803E-03,
     +0.3940E-04,0.0000E+00/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1336E-01,0.1409E-01,0.1485E-01,0.1565E-01,0.1649E-01,0.1738E-01,
     +0.1832E-01,0.1930E-01,0.2033E-01,0.2141E-01,0.2256E-01,0.2375E-01,
     +0.2501E-01,0.2634E-01,0.2773E-01,0.2919E-01,0.3072E-01,0.3232E-01,
     +0.3401E-01,0.3578E-01,0.3763E-01,0.3958E-01,0.4161E-01,0.4375E-01,
     +0.4598E-01,0.4832E-01,0.5076E-01,0.5332E-01,0.5599E-01,0.5878E-01,
     +0.6170E-01,0.6474E-01,0.6791E-01,0.7121E-01,0.7465E-01,0.7822E-01,
     +0.8194E-01,0.8580E-01,0.8981E-01,0.9396E-01,0.9826E-01,0.1027E+00,
     +0.1073E+00,0.1120E+00,0.1169E+00,0.1219E+00,0.1270E+00,0.1323E+00,
     +0.1377E+00,0.1431E+00,0.1487E+00,0.1543E+00,0.1600E+00,0.1657E+00,
     +0.1714E+00,0.1770E+00,0.1826E+00,0.1881E+00,0.1934E+00,0.1986E+00,
     +0.2034E+00,0.2080E+00,0.2122E+00,0.2159E+00,0.2191E+00,0.2217E+00,
     +0.2235E+00,0.2246E+00,0.2248E+00,0.2239E+00,0.2220E+00,0.2189E+00,
     +0.2146E+00,0.2089E+00,0.2018E+00,0.1933E+00,0.1834E+00,0.1721E+00,
     +0.1595E+00,0.1458E+00,0.1311E+00,0.1158E+00,0.1001E+00,0.8438E-01,
     +0.6910E-01,0.5466E-01,0.4149E-01,0.2996E-01,0.2033E-01,0.1274E-01,
     +0.9171E-02,0.6457E-02,0.4433E-02,0.2955E-02,0.1901E-02,0.1170E-02,
     +0.6827E-03,0.3712E-03,0.1838E-03,0.7986E-04,0.2854E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2025E+03,0.1929E+03,0.1837E+03,0.1749E+03,0.1664E+03,0.1583E+03,
     +0.1505E+03,0.1431E+03,0.1360E+03,0.1292E+03,0.1227E+03,0.1165E+03,
     +0.1105E+03,0.1048E+03,0.9937E+02,0.9417E+02,0.8920E+02,0.8446E+02,
     +0.7994E+02,0.7562E+02,0.7151E+02,0.6758E+02,0.6384E+02,0.6027E+02,
     +0.5688E+02,0.5364E+02,0.5056E+02,0.4763E+02,0.4484E+02,0.4219E+02,
     +0.3967E+02,0.3728E+02,0.3501E+02,0.3285E+02,0.3080E+02,0.2886E+02,
     +0.2702E+02,0.2528E+02,0.2363E+02,0.2207E+02,0.2059E+02,0.1919E+02,
     +0.1787E+02,0.1662E+02,0.1544E+02,0.1433E+02,0.1328E+02,0.1230E+02,
     +0.1137E+02,0.1049E+02,0.9673E+01,0.8902E+01,0.8178E+01,0.7499E+01,
     +0.6863E+01,0.6269E+01,0.5713E+01,0.5194E+01,0.4710E+01,0.4260E+01,
     +0.3841E+01,0.3453E+01,0.3094E+01,0.2762E+01,0.2456E+01,0.2174E+01,
     +0.1916E+01,0.1681E+01,0.1466E+01,0.1271E+01,0.1095E+01,0.9374E+00,
     +0.7961E+00,0.6705E+00,0.5595E+00,0.4623E+00,0.3777E+00,0.3047E+00,
     +0.2424E+00,0.1897E+00,0.1458E+00,0.1097E+00,0.8037E-01,0.5709E-01,
     +0.3899E-01,0.2531E-01,0.1530E-01,0.8287E-02,0.3663E-02,0.8683E-03,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.4165E+02,0.3986E+02,0.3813E+02,0.3647E+02,0.3487E+02,0.3334E+02,
     +0.3186E+02,0.3044E+02,0.2908E+02,0.2777E+02,0.2652E+02,0.2531E+02,
     +0.2415E+02,0.2304E+02,0.2197E+02,0.2095E+02,0.1997E+02,0.1903E+02,
     +0.1812E+02,0.1726E+02,0.1643E+02,0.1563E+02,0.1487E+02,0.1414E+02,
     +0.1344E+02,0.1278E+02,0.1214E+02,0.1152E+02,0.1094E+02,0.1038E+02,
     +0.9842E+01,0.9329E+01,0.8840E+01,0.8372E+01,0.7924E+01,0.7497E+01,
     +0.7090E+01,0.6700E+01,0.6328E+01,0.5974E+01,0.5635E+01,0.5312E+01,
     +0.5004E+01,0.4711E+01,0.4431E+01,0.4164E+01,0.3910E+01,0.3667E+01,
     +0.3436E+01,0.3216E+01,0.3006E+01,0.2807E+01,0.2617E+01,0.2436E+01,
     +0.2264E+01,0.2100E+01,0.1944E+01,0.1796E+01,0.1655E+01,0.1521E+01,
     +0.1394E+01,0.1274E+01,0.1160E+01,0.1053E+01,0.9515E+00,0.8561E+00,
     +0.7666E+00,0.6829E+00,0.6049E+00,0.5326E+00,0.4657E+00,0.4044E+00,
     +0.3483E+00,0.2975E+00,0.2518E+00,0.2109E+00,0.1748E+00,0.1431E+00,
     +0.1155E+00,0.9181E-01,0.7167E-01,0.5479E-01,0.4085E-01,0.2958E-01,
     +0.2067E-01,0.1386E-01,0.8850E-02,0.5353E-02,0.3054E-02,0.1643E-02,
     +0.1100E-02,0.7393E-03,0.4977E-03,0.3339E-03,0.2216E-03,0.1441E-03,
     +0.9072E-04,0.5444E-04,0.3055E-04,0.1560E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.7474E+01,0.7163E+01,0.6863E+01,0.6575E+01,0.6297E+01,0.6031E+01,
     +0.5774E+01,0.5528E+01,0.5290E+01,0.5063E+01,0.4844E+01,0.4633E+01,
     +0.4431E+01,0.4237E+01,0.4051E+01,0.3872E+01,0.3700E+01,0.3535E+01,
     +0.3377E+01,0.3225E+01,0.3080E+01,0.2940E+01,0.2806E+01,0.2678E+01,
     +0.2555E+01,0.2437E+01,0.2323E+01,0.2215E+01,0.2111E+01,0.2012E+01,
     +0.1917E+01,0.1825E+01,0.1738E+01,0.1654E+01,0.1574E+01,0.1498E+01,
     +0.1424E+01,0.1354E+01,0.1287E+01,0.1222E+01,0.1160E+01,0.1101E+01,
     +0.1045E+01,0.9904E+00,0.9385E+00,0.8886E+00,0.8408E+00,0.7950E+00,
     +0.7510E+00,0.7088E+00,0.6682E+00,0.6293E+00,0.5918E+00,0.5558E+00,
     +0.5212E+00,0.4878E+00,0.4558E+00,0.4249E+00,0.3952E+00,0.3666E+00,
     +0.3392E+00,0.3128E+00,0.2874E+00,0.2632E+00,0.2400E+00,0.2178E+00,
     +0.1968E+00,0.1768E+00,0.1579E+00,0.1402E+00,0.1237E+00,0.1083E+00,
     +0.9413E-01,0.8111E-01,0.6927E-01,0.5859E-01,0.4902E-01,0.4052E-01,
     +0.3304E-01,0.2652E-01,0.2090E-01,0.1611E-01,0.1209E-01,0.8776E-02,
     +0.6124E-02,0.4071E-02,0.2555E-02,0.1498E-02,0.8148E-03,0.4102E-03,
     +0.2622E-03,0.1685E-03,0.1091E-03,0.7094E-04,0.4609E-04,0.2960E-04,
     +0.1853E-04,0.1111E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.7301E+01,0.6989E+01,0.6690E+01,0.6401E+01,0.6124E+01,0.5857E+01,
     +0.5601E+01,0.5355E+01,0.5118E+01,0.4890E+01,0.4671E+01,0.4461E+01,
     +0.4259E+01,0.4065E+01,0.3879E+01,0.3701E+01,0.3529E+01,0.3364E+01,
     +0.3207E+01,0.3055E+01,0.2910E+01,0.2771E+01,0.2637E+01,0.2509E+01,
     +0.2387E+01,0.2269E+01,0.2157E+01,0.2049E+01,0.1946E+01,0.1847E+01,
     +0.1753E+01,0.1662E+01,0.1576E+01,0.1493E+01,0.1414E+01,0.1339E+01,
     +0.1267E+01,0.1198E+01,0.1132E+01,0.1069E+01,0.1009E+01,0.9514E+00,
     +0.8966E+00,0.8444E+00,0.7946E+00,0.7470E+00,0.7017E+00,0.6584E+00,
     +0.6172E+00,0.5779E+00,0.5404E+00,0.5047E+00,0.4707E+00,0.4382E+00,
     +0.4074E+00,0.3780E+00,0.3500E+00,0.3234E+00,0.2982E+00,0.2741E+00,
     +0.2514E+00,0.2297E+00,0.2093E+00,0.1900E+00,0.1717E+00,0.1545E+00,
     +0.1384E+00,0.1233E+00,0.1093E+00,0.9622E-01,0.8416E-01,0.7308E-01,
     +0.6296E-01,0.5378E-01,0.4551E-01,0.3812E-01,0.3158E-01,0.2584E-01,
     +0.2085E-01,0.1657E-01,0.1293E-01,0.9878E-02,0.7365E-02,0.5335E-02,
     +0.3734E-02,0.2510E-02,0.1611E-02,0.9825E-03,0.5672E-03,0.3101E-03,
     +0.2100E-03,0.1428E-03,0.9716E-04,0.6583E-04,0.4408E-04,0.2889E-04,
     +0.1831E-04,0.1106E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.7185E+01,0.6873E+01,0.6574E+01,0.6286E+01,0.6009E+01,0.5742E+01,
     +0.5486E+01,0.5239E+01,0.5002E+01,0.4775E+01,0.4556E+01,0.4346E+01,
     +0.4144E+01,0.3951E+01,0.3765E+01,0.3586E+01,0.3415E+01,0.3251E+01,
     +0.3093E+01,0.2942E+01,0.2797E+01,0.2658E+01,0.2524E+01,0.2397E+01,
     +0.2275E+01,0.2157E+01,0.2045E+01,0.1938E+01,0.1835E+01,0.1737E+01,
     +0.1643E+01,0.1554E+01,0.1468E+01,0.1386E+01,0.1307E+01,0.1233E+01,
     +0.1161E+01,0.1093E+01,0.1028E+01,0.9665E+00,0.9075E+00,0.8513E+00,
     +0.7979E+00,0.7470E+00,0.6986E+00,0.6526E+00,0.6088E+00,0.5673E+00,
     +0.5279E+00,0.4906E+00,0.4551E+00,0.4216E+00,0.3899E+00,0.3599E+00,
     +0.3315E+00,0.3048E+00,0.2796E+00,0.2558E+00,0.2335E+00,0.2125E+00,
     +0.1929E+00,0.1744E+00,0.1572E+00,0.1412E+00,0.1262E+00,0.1124E+00,
     +0.9956E-01,0.8773E-01,0.7686E-01,0.6690E-01,0.5783E-01,0.4961E-01,
     +0.4220E-01,0.3557E-01,0.2968E-01,0.2449E-01,0.1997E-01,0.1606E-01,
     +0.1273E-01,0.9934E-02,0.7615E-02,0.5728E-02,0.4220E-02,0.3042E-02,
     +0.2141E-02,0.1470E-02,0.9829E-03,0.6388E-03,0.4022E-03,0.2433E-03,
     +0.1752E-03,0.1256E-03,0.8923E-04,0.6243E-04,0.4275E-04,0.2842E-04,
     +0.1816E-04,0.1102E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.7012E+01,0.6705E+01,0.6410E+01,0.6126E+01,0.5853E+01,0.5590E+01,
     +0.5338E+01,0.5096E+01,0.4863E+01,0.4639E+01,0.4424E+01,0.4218E+01,
     +0.4020E+01,0.3830E+01,0.3647E+01,0.3472E+01,0.3304E+01,0.3143E+01,
     +0.2989E+01,0.2841E+01,0.2699E+01,0.2563E+01,0.2433E+01,0.2308E+01,
     +0.2189E+01,0.2075E+01,0.1965E+01,0.1861E+01,0.1761E+01,0.1665E+01,
     +0.1574E+01,0.1487E+01,0.1403E+01,0.1324E+01,0.1248E+01,0.1175E+01,
     +0.1106E+01,0.1040E+01,0.9777E+00,0.9179E+00,0.8610E+00,0.8068E+00,
     +0.7552E+00,0.7062E+00,0.6597E+00,0.6154E+00,0.5735E+00,0.5336E+00,
     +0.4959E+00,0.4601E+00,0.4263E+00,0.3943E+00,0.3640E+00,0.3354E+00,
     +0.3085E+00,0.2831E+00,0.2592E+00,0.2367E+00,0.2156E+00,0.1958E+00,
     +0.1773E+00,0.1600E+00,0.1439E+00,0.1289E+00,0.1149E+00,0.1020E+00,
     +0.9015E-01,0.7921E-01,0.6918E-01,0.6004E-01,0.5174E-01,0.4424E-01,
     +0.3751E-01,0.3151E-01,0.2620E-01,0.2154E-01,0.1750E-01,0.1403E-01,
     +0.1108E-01,0.8613E-02,0.6580E-02,0.4932E-02,0.3621E-02,0.2601E-02,
     +0.1824E-02,0.1248E-02,0.8307E-03,0.5370E-03,0.3356E-03,0.2010E-03,
     +0.1436E-03,0.1021E-03,0.7180E-04,0.4970E-04,0.3364E-04,0.2208E-04,
     +0.1392E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.5205E+01,0.4962E+01,0.4729E+01,0.4505E+01,0.4290E+01,0.4084E+01,
     +0.3887E+01,0.3698E+01,0.3517E+01,0.3343E+01,0.3177E+01,0.3018E+01,
     +0.2866E+01,0.2720E+01,0.2581E+01,0.2448E+01,0.2320E+01,0.2198E+01,
     +0.2082E+01,0.1971E+01,0.1864E+01,0.1763E+01,0.1666E+01,0.1574E+01,
     +0.1486E+01,0.1402E+01,0.1322E+01,0.1246E+01,0.1173E+01,0.1104E+01,
     +0.1038E+01,0.9758E+00,0.9164E+00,0.8599E+00,0.8062E+00,0.7552E+00,
     +0.7068E+00,0.6610E+00,0.6175E+00,0.5762E+00,0.5372E+00,0.5003E+00,
     +0.4653E+00,0.4323E+00,0.4011E+00,0.3717E+00,0.3439E+00,0.3178E+00,
     +0.2931E+00,0.2700E+00,0.2482E+00,0.2277E+00,0.2086E+00,0.1906E+00,
     +0.1738E+00,0.1581E+00,0.1435E+00,0.1298E+00,0.1171E+00,0.1054E+00,
     +0.9445E-01,0.8437E-01,0.7508E-01,0.6653E-01,0.5869E-01,0.5153E-01,
     +0.4500E-01,0.3908E-01,0.3373E-01,0.2892E-01,0.2461E-01,0.2078E-01,
     +0.1740E-01,0.1443E-01,0.1184E-01,0.9614E-02,0.7709E-02,0.6100E-02,
     +0.4756E-02,0.3650E-02,0.2753E-02,0.2037E-02,0.1476E-02,0.1046E-02,
     +0.7226E-03,0.4856E-03,0.3163E-03,0.1988E-03,0.1196E-03,0.6803E-04,
     +0.4675E-04,0.3182E-04,0.2135E-04,0.1404E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
