/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/syncmanager.h>
#include <mcloud/api/taskqueue.h>

#include "client_priv.h"
#include "syncthread.h"
#include "syncmanager_priv.h"

#include <iostream>

using namespace mcloud::api;
using namespace std;

SyncManager::SyncManager(ClientPriv* client_priv)
    :p_(std::make_shared<SyncManagerPriv>(client_priv)) {
}

void SyncManager::start() {
    p_->start();
}

void SyncManager::cancel() {
    p_->cancel();
}

void SyncManager::pause() {
    p_->pause();
}

UploadTask::Ptr SyncManager::add_upload_task(const UploadRequest &request_item) {
    return p_->add_upload_task(request_item);
}

UploadTask::Ptr SyncManager::add_upload_task(const UploadBufferCb &buffer_cb) {
    return p_->add_upload_task(buffer_cb);
}

DownloadTask::Ptr SyncManager::add_download_task(const string &content_id) {
    return p_->add_download_task(content_id);
}

DownloadTask::Ptr SyncManager::add_download_task(const DownloadBufferCb &buffer_cb) {
    return p_->add_download_task(buffer_cb);
}

TaskQueue<std::shared_ptr<DownloadTask>> SyncManager::download_queue() {
    return p_->download_queue();
}

TaskQueue<std::shared_ptr<UploadTask>> SyncManager::upload_queue() {
    return p_->upload_queue();
}
