// Author(s): Egbert Teeselink
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// An interface to the strategy classes generated by strategy_converter.py.
//

#ifndef MCRL2_LYSA_STRATEGY_H
#define MCRL2_LYSA_STRATEGY_H

#include <map>
#include <string>

namespace lysa
{
class Strategy
{
  protected:
    std::string name;
  public:
    virtual std::string getFormatTemplate()   = 0;
    virtual std::string getPreamble()         = 0;
    virtual bool        makeSymbolicAttacker() = 0;
    static Strategy* get(std::string name);
    virtual ~Strategy()
    {}
};
}

#endif // MCRL2_LYSA_STRATEGY_H
