/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <stdio.h>

#include <med.h>
#include <med_config.h>
#include <med_outils.h>


/**\ingroup MEDfile
  \brief \MEDfileStrVersionRdBrief
  \param fid \fid
  \param medversion \medversion
  \retval med_err \error
  \details \MEDfileStrVersionRdDetails
 */

med_err
MEDfileStrVersionRd(const med_idt fid,
		    char* const medversion)
{
  med_err _ret = -1;
  med_idt _id=0;
  med_int _major;
  med_int _minor;
  med_int _release;

  int _intmajor;
  int _intminor;
  int _intrelease;

  /* We read the hdf attributes in the MED_INFOS hdf group */
  if ((_id = _MEDdatagroupOuvrir(fid,MED_INFOS)) < 0) {
    MED_ERR_(_ret,MED_ERR_OPEN,MED_ERR_DATAGROUP,MED_INFOS);
    goto ERROR;
  }

  if (_MEDattrEntierLire(_id,MED_MAJOR_NAME,&_major) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_MAJOR_NAME);
    goto ERROR;
  }

  if (_MEDattrEntierLire(_id,MED_MINOR_NAME,&_minor) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_MINOR_NAME);
    goto ERROR;
  }

  if (_MEDattrEntierLire(_id,MED_RELEASE_NAME,&_release) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_RELEASE_NAME);
    goto ERROR;
  }

  _intmajor  = (int)  _major;
  _intminor  = (int)  _minor;
  _intrelease= (int)  _release;

  if (medversion)
    sprintf(medversion,"MED-%d.%d.%d",_intmajor,_intminor,_intrelease);

  _ret = 0;
  ERROR :

  /* the hdf group is closed  */
  if (_id > 0)
    if (_MEDdatagroupFermer(_id) < 0) {
      MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_DATAGROUP,"");
      _ret = -1;
    }

  return _ret;
}
