<?php
/**
 * Internationalisation file for the CreateBox extension.
 *
 * @file
 * @ingroup Extensions
 * @author Ross McClure
 */

$messages = array();

/** English
 * @author Ross McClure
 */
$messages['en'] = array(
	'createbox-desc' => 'Specialised inputbox for page creation',
	'createbox-create' => 'Create',
	'createbox-exists' => "Sorry, \"'''{{FULLPAGENAME}}'''\" already exists.

You cannot create this page, but you can [{{fullurl:{{FULLPAGENAME}}|action=edit}} edit it], [{{fullurl:{{FULLPAGENAME}}}} read it], or choose to create a different page using the box below.

<createbox>break=no</createbox>",
);

/** Message documentation (Message documentation)
 * @author Jon Harald Søby
 * @author Purodha
 */
$messages['qqq'] = array(
	'createbox-desc' => 'Extension description displayed on [[Special:Version]].',
	'createbox-create' => '{{Identical|Create}}',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'createbox-desc' => 'Gespesialiseerde invoerveld vir die skep van nuwe bladsye',
	'createbox-create' => 'Skep',
	'createbox-exists' => "Jammer, \"'''{{FULLPAGENAME}}'''\" bestaan al reeds.

U kan nie hierdie bladsy skep nie, maar u kan dit wel [{{fullurl:{{FULLPAGENAME}}|action=edit}} wysig], [{{fullurl:{{FULLPAGENAME}}}} wys], of 'n ander bladsy via die onderstaande vorm skep.

<createbox>break=no</createbox>",
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'createbox-create' => 'Creyar',
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'createbox-desc' => 'صندوق إدخال متخصص لإنشاء الصفحات',
	'createbox-create' => 'أنشئ',
	'createbox-exists' => "عذرا، \"'''{{FULLPAGENAME}}'''\" موجودة بالفعل.

أنت لا يمكنك إنشاء هذه الصفحة، لكن يمكنك [{{fullurl:{{FULLPAGENAME}}|action=edit}} تعديلها], [{{fullurl:{{FULLPAGENAME}}}} قراءتها]، أو اختيار إنشاء صفحة أخرى باستخدام الصندوق بالأسفل.

<createbox>break=no</createbox>",
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'createbox-create' => 'ܒܪܝ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$messages['arz'] = array(
	'createbox-desc' => 'صندوق إدخال متخصص لإنشاء الصفحات',
	'createbox-create' => 'إنشاء',
	'createbox-exists' => "عذرا، \"'''{{FULLPAGENAME}}'''\" موجودة بالفعل.

أنت لا يمكنك إنشاء هذه الصفحة، لكن يمكنك [{{fullurl:{{FULLPAGENAME}}|action=edit}} تعديلها], [{{fullurl:{{FULLPAGENAME}}}} قراءتها]، أو اختيار إنشاء صفحة أخرى باستخدام الصندوق بالأسفل.

<createbox>break=no</createbox>",
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'createbox-desc' => "Caxa d'entrada especializada pa la creación de páxines",
	'createbox-create' => 'Crear',
	'createbox-exists' => "Sentímoslo, \"'''{{FULLPAGENAME}}'''\" yá esiste.

Nun puedes crear esta páxina, pero puedes [{{fullurl:{{FULLPAGENAME}}|action=edit}} editala], [{{fullurl:{{FULLPAGENAME}}}} lleela], o elixir crear una páxina diferente usando la caxa d'abaxo.

<createbox>break=no</createbox>",
);

/** Bavarian (Boarisch)
 * @author Mucalexx
 */
$messages['bar'] = array(
	'createbox-exists' => "„'''{{FULLPAGENAME}}'''“ existiard beraits.

Du kååst de Saiten ned åleeng, ower du kååstas [{{fullurl:{{FULLPAGENAME}}|action=edit}} beorwaiten], [{{fullurl:{{FULLPAGENAME}}}} leesen] oder a åndre Seiten mid da Hüif vom untensteehaten Aigobföidl åleeng.

<createbox>break=no</createbox>",
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Zedlik
 */
$messages['be-tarask'] = array(
	'createbox-desc' => 'Спэцыялізаванае поле ўводу для стварэньня старонак',
	'createbox-create' => 'Стварыць',
	'createbox-exists' => "Прабачце, «'''{{FULLPAGENAME}}'''» ужо існуе.

Вы ня можаце стварыць гэту старонку, але Вы можаце [{{fullurl:{{FULLPAGENAME}}|action=edit}} рэдагаваць яе], [{{fullurl:{{FULLPAGENAME}}}} чытаць яе] альбо стварыць іншую старонку з дапамогай поля ніжэй.

<createbox>break=no</createbox>",
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'createbox-create' => 'Създаване',
);

/** Bengali (বাংলা)
 * @author Wikitanvir
 */
$messages['bn'] = array(
	'createbox-desc' => 'পাতা তৈরির জন্য বিশেষ ইনপুট বক্স',
	'createbox-create' => 'তৈরি করুন',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'createbox-desc' => "Boest skridaozañ gouestlet d'ar c'hrouiñ pajennoù",
	'createbox-create' => 'Krouiñ',
	'createbox-exists' => "Ho tigarez, bez' ez eus eus \"'''{{FULLPAGENAME}}'''\" c'hoazh.

N'haller ket krouiñ ar bajenn-mañ, met gallout a reer [{{fullurl:{{FULLPAGENAME}}|action=edit}} degas kemmoù enni], [{{fullurl:{{FULLPAGENAME}}}} lenn anezhi], pe dibab krouiñ ur bajenn all en ur implijout ar voest a-is.

<createbox>break=no</createbox>",
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'createbox-desc' => 'Specijalizirana kutija unosa za pravljenje stranice',
	'createbox-create' => 'Napravi',
	'createbox-exists' => "Žao nam je, \"'''{{FULLPAGENAME}}'''\" već postoji.

Ne možete napraviti ovu stranicu, ali je možete [{{fullurl:{{FULLPAGENAME}}|action=edit}} urediti], [{{fullurl:{{FULLPAGENAME}}}} pročitati] ili odabrati pravljenje druge stranice koristeći kutiju ispod.

<createbox>break=no</createbox>",
);

/** Catalan (Català)
 * @author Loupeter
 */
$messages['ca'] = array(
	'createbox-create' => 'Crear',
);

/** Corsican (Corsu) */
$messages['co'] = array(
	'createbox-create' => 'Creà',
);

/** Czech (Česky)
 * @author Jkjk
 */
$messages['cs'] = array(
	'createbox-desc' => 'Speciální vkládací pole pro vytváření stránek',
	'createbox-create' => 'Vytvořit',
	'createbox-exists' => "Omlouváme se, ale \"'''{{FULLPAGENAME}}'''\" již existuje.

Nemůžete vytvořit tuto stránku, ale můžete jí [{{fullurl:{{FULLPAGENAME}}|action=edit}} editovat], [{{fullurl:{{FULLPAGENAME}}}} zobrazit], nebo vytvořit jinou stránku pomocí následujícího pole.

<createbox>break=no</createbox>",
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'createbox-desc' => "Blwch mewnbynnu arbennig ar gyfer dechrau tudalen o'r newydd",
	'createbox-create' => 'Dechrau',
	'createbox-exists' => "Mae'n ddrwg gennym, mae'r dudalen \"'''{{FULLPAGENAME}}'''\" ar gael yn barod.

Ni ellwch ddechrau'r dudalen o'r newydd, ond gallwch [{{fullurl:{{FULLPAGENAME}}|action=edit}} ei golygu], neu [{{fullurl:{{FULLPAGENAME}}}} ei darllen], neu dechrau tudalen arall gan ddefnyddio'r blwch isod.

<createbox>break=no</createbox>",
);

/** German (Deutsch)
 * @author ChrisiPK
 * @author Kghbln
 * @author Revolus
 */
$messages['de'] = array(
	'createbox-desc' => 'Ermöglicht ein spezielles Eingabefeld zur Seitenerstellung',
	'createbox-create' => 'Erstellen',
	'createbox-exists' => "„'''{{FULLPAGENAME}}'''“ ist bereits vorhanden.

Du kannst diese Seite daher nicht anlegen, sie aber [{{fullurl:{{FULLPAGENAME}}|action=edit}} bearbeiten], [{{fullurl:{{FULLPAGENAME}}}} lesen] oder eine Seite anderen Namens mithilfe des untenstehenden Eingabefeldes anlegen.

<createbox>break=no</createbox>",
);

/** German (formal address) (‪Deutsch (Sie-Form)‬)
 * @author Imre
 */
$messages['de-formal'] = array(
	'createbox-exists' => "„'''{{FULLPAGENAME}}'''“ existiert bereits.

Sie können diese Seite nicht anlegen, aber Sie können sie [{{fullurl:{{FULLPAGENAME}}|action=edit}} bearbeiten], [{{fullurl:{{FULLPAGENAME}}}} lesen] oder eine andere Seite mithilfe des untenstehenden Eingabefeldes anlegen.

<createbox>break=no</createbox>",
);

/** Zazaki (Zazaki)
 * @author Erdemaslancan
 */
$messages['diq'] = array(
	'createbox-exists' => "Xeta, \"'''{{FULLPAGENAME}}'''\" xora esta.

Feqet şıma şenê [{{fullurl:{{FULLPAGENAME}}|action=edit}} bıvurnê],  ya zi [{{fullurl:{{FULLPAGENAME}}}} buwanê], ya na  dora cêrêna peşti gerênra şıma şenê  zewmi pela vırazê.

<createbox>break=no</createbox>",
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'createbox-desc' => 'Specielne zapódawańske pólo za napóranje bokow',
	'createbox-create' => 'Napóraś',
	'createbox-exists' => "\"'''{{FULLPAGENAME}}'''\" južo eksistěrujo.

Njamóžoš tós ten bok napóraś, ale móžoš jen [{{fullurl:{{FULLPAGENAME}}|action=edit}} wobźěłaś],
[{{fullurl:{{FULLPAGENAME}}}} cytaś] abo wubraś, aby drugi bok z pomocu slědujucego kašćika napórał.

<createbox>break=no</createbox>",
);

/** Ewe (Eʋegbe)
 * @author Natsubee
 */
$messages['ee'] = array(
	'createbox-desc' => 'Go tɔxɛ na axa gɔmedzedze',
	'createbox-create' => 'Dze egɔme',
	'createbox-exists' => "Taflatse, woŋlɔ \"'''{{FULLPAGENAME}}'''\" xoxo.

Wòmateŋu adze axa sia gɔme o, ke boŋ wòateŋu [{{fullurl:{{FULLPAGENAME}}|action=edit}} atrɔ asi le eŋu], [{{fullurl:{{FULLPAGENAME}}}} alo axlẽ], alo wòateŋu adze axa bubu gɔme kple go si le afisia ɖome.",
);

/** Greek (Ελληνικά)
 * @author Konsnos
 * @author ZaDiak
 */
$messages['el'] = array(
	'createbox-desc' => 'Ειδικευμένο inputbox για δημιουργία σελίδων',
	'createbox-create' => 'Δημιουργία',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'createbox-create' => 'Krei',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Imre
 */
$messages['es'] = array(
	'createbox-desc' => 'Tabla de ingreso especializada para creación de página',
	'createbox-create' => 'Crear',
	'createbox-exists' => "Disculpe, \"'''{{FULLPAGENAME}}'''\" ya existe.

No puedes crear esta página, pero puedes [{{fullurl:{{FULLPAGENAME}}|action=edit}} editarla], [{{fullurl:{{FULLPAGENAME}}}} leerla], o escoger crear una página diferente usando la tabla de debajo.

<createbox>break=no</createbox>",
);

/** Estonian (Eesti)
 * @author Avjoska
 */
$messages['et'] = array(
	'createbox-create' => 'Loo',
);

/** Basque (Euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'createbox-create' => 'Sortu',
);

/** Finnish (Suomi)
 * @author Jack Phoenix
 * @author Mobe
 * @author Nike
 */
$messages['fi'] = array(
	'createbox-desc' => 'Erityinen syöttölomake sivun luontiin.',
	'createbox-create' => 'Luo',
	'createbox-exists' => "Pahoittelut, \"'''{{FULLPAGENAME}}'''\" on jo olemassa.

Et voi luoda tätä sivua, mutta voit [{{fullurl:{{FULLPAGENAME}}|action=edit}} muokata sitä], [{{fullurl:{{FULLPAGENAME}}}} lukea sitä], tai luoda erilaisen sivun allaolevaa laatikkoa käyttäen.

<createbox>break=no</createbox>",
);

/** French (Français)
 * @author Crochet.david
 * @author Verdy p
 */
$messages['fr'] = array(
	'createbox-desc' => 'Boîte de saisie spécialisée pour la création de page',
	'createbox-create' => 'Créer',
	'createbox-exists' => "Désolé, « '''{{FULLPAGENAME}}''' » existe déjà.

Vous ne pouvez pas créer cette page, mais vous pouvez [{{fullurl:{{FULLPAGENAME}}|action=edit}} la modifier], [{{fullurl:{{FULLPAGENAME}}}} la lire] ou choisir de créer une page différente à l’aide de la boîte ci-dessous.

<createbox>break=no</createbox>",
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'createbox-create' => 'Fâre',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'createbox-desc' => 'Caixa de entrada especializada para a creación de páxinas',
	'createbox-create' => 'Crear',
	'createbox-exists' => "Sentímolo, \"'''{{FULLPAGENAME}}'''\" xa existe.

Non pode crear esta páxina, pero pode [{{fullurl:{{FULLPAGENAME}}|action=edit}} editala], [{{fullurl:{{FULLPAGENAME}}}} lela], ou elixir crear unha páxina diferente usando a caixa de embaixo.

<createbox>break=no</createbox>",
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'createbox-create' => 'Ποιεῖν',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'createbox-desc' => 'Speziäll Yygabfäld zum Aalege vu Syte',
	'createbox-create' => 'Aalege',
	'createbox-exists' => "Excusez, „'''{{FULLPAGENAME}}'''“ git s scho.

Du chasch die Syte nit aalege, aber Du chasch si [{{fullurl:{{FULLPAGENAME}}|action=edit}} bearbeite], [{{fullurl:{{FULLPAGENAME}}}} läse] oder e anderi Syte aalege mit em Yygabfäld, wu do unte stoht.

<createbox>break=no</createbox>",
);

/** Gujarati (ગુજરાતી)
 * @author Ashok modhvadia
 */
$messages['gu'] = array(
	'createbox-desc' => 'પાનું બનાવવા માટેનું વિશેષ આગતચોકઠું',
	'createbox-create' => 'બનાવો',
	'createbox-exists' => "માફ કરો,\"'''{{FULLPAGENAME}}'''\" પહેલેથી અસ્તિત્વમાં છે.

તમે આ પાનું બનાવી શકતા નથી, પરંતુ તમે [{{fullurl:{{FULLPAGENAME}}|action=edit}} સંપાદિત] કરી શકો છો,[{{fullurl:{{FULLPAGENAME}}}} વાંચી શકો છો], અથવા નિચેનાં ચોકઠાનો ઉપયોગ કરી અલગ પાનું બનાવી શકો છો.

<createbox>break=no</createbox>",
);

/** Hausa (هَوُسَ) */
$messages['ha'] = array(
	'createbox-create' => 'Ƙirƙira',
);

/** Hakka (Hak-kâ-fa)
 * @author Hakka
 */
$messages['hak'] = array(
	'createbox-create' => 'Tshóng-kien',
);

/** Hebrew (עברית)
 * @author Rotemliss
 */
$messages['he'] = array(
	'createbox-desc' => 'תיבת קלט מיוחדת ליצירת דפים',
	'createbox-create' => 'יצירה',
	'createbox-exists' => "מצטערים, \"'''{{FULLPAGENAME}}'''\" כבר קיים.

אינכם יכולים ליצור את הדף, אך באפשרותכם [{{fullurl:{{FULLPAGENAME}}|action=edit}} לערוך אותו], [{{fullurl:{{FULLPAGENAME}}}} לקרוא אותו] או ליצור דף אחר באמצעות התיבה למטה.

<createbox>break=no</createbox>",
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'createbox-desc' => 'Specielne zapodatny kašćik za wutworjenje stronow',
	'createbox-create' => 'Wutworić',
	'createbox-exists' => "Wodaj, \"'''{{FULLPAGENAME}}'''\" hižo eksistuje.

Njemóžeš tutu stronu wutworić, ale móžeš [{{fullurl:{{FULLPAGENAME}}|action=edit}} ju wobdźěłać], [{{fullurl:{{FULLPAGENAME}}}} čitać] abo z pomocu slědowaceho kašćik druhu stronu wutworić.

<createbox>break=no</createbox>",
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'createbox-desc' => 'Speciális inputbox lapkészítéshez',
	'createbox-create' => 'Készítés',
	'createbox-exists' => "Sajnáljuk, de „'''{{FULLPAGENAME}}'''” című lap már létezik.

Nem készítheted el a lapot, de [{{fullurl:{{FULLPAGENAME}}|action=edit}} szerkesztheted], [{{fullurl:{{FULLPAGENAME}}}} elolvashatod], vagy választhatsz egy másik lapnevet a lenti dobozban.

<createbox>break=no</createbox>",
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'createbox-desc' => 'Quadro de entrata specialisate pro le creation de paginas',
	'createbox-create' => 'Crear',
	'createbox-exists' => "Pardono, \"'''{{FULLPAGENAME}}'''\" existe ja.

Tu non pote crear iste pagina, sed tu pote [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificar lo], [{{fullurl:{{FULLPAGENAME}}}} leger lo], o optar pro crear un altere pagina con le quadro infra.

<createbox>break=no</createbox>",
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 */
$messages['id'] = array(
	'createbox-desc' => '"Inputbox" khusus untuk pembuatan halaman',
	'createbox-create' => 'Buat',
	'createbox-exists' => "Maaf, \"'''{{FULLPAGENAME}}'''\" sudah ada.

Anda tidak dapat membuat halaman ini, namun Anda dapat [{{fullurl:{{FULLPAGENAME}}|action=edit}} menyuntingnya], [{{fullurl:{{FULLPAGENAME}}}} membacanya], atau membuat halaman lainnya dengan menggunakan kotak di bawah ini.

<createbox>break=no</createbox>",
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'createbox-desc' => 'Ntiyéntiyé di mkpà maka éké ihü',
	'createbox-create' => 'Ké',
	'createbox-exists' => "Ndó, \"'''{{FULLPAGENAME}}'''\" di kwà.

Í nweríkí ké ihü á, mànà Í nwẹríkí [{{fullurl:{{FULLPAGENAME}}|action=edit}} rüo élú yá], [{{fullurl:{{FULLPAGENAME}}}} gwuó ya], ma Í jí ngwa nor nà àlà ngá Í kpátá ihü nke òzór.

<createbox>gbàjié=mbạ</createbox>",
);

/** Italian (Italiano)
 * @author Pietrodn
 */
$messages['it'] = array(
	'createbox-desc' => 'Inputbox specializzato per la creazione di pagine',
	'createbox-create' => 'Crea',
	'createbox-exists' => "Scusa, \"'''{{FULLPAGENAME}}'''\" esiste già.

Non puoi creare questa pagina, ma puoi [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificarla], [{{fullurl:{{FULLPAGENAME}}}} leggerla] o scegliere di creare una pagina diversa usando il box sottostante.

<createbox>break=no</createbox>",
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fievarsty
 */
$messages['ja'] = array(
	'createbox-desc' => 'ページ作成専用のInputbox',
	'createbox-create' => '作成',
	'createbox-exists' => "残念ながら\"'''{{FULLPAGENAME}}'''\" はすでに作成されています。

このページを作成することはできませんが、[{{fullurl:{{FULLPAGENAME}}|action=edit}} 同名のページを編集]、[{{fullurl:{{FULLPAGENAME}}}} 閲覧]、または以下のBoxを使用して他の名前のページを作成することができます。

<createbox>break=no</createbox>",
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'createbox-create' => 'បង្កើត',
	'createbox-exists' => "សូមអភ័យទោស! \"'''{{FULLPAGENAME}}'''\" មានរួចហើយ។

អ្នកមិនអាចបង្កើតទំព័រនេះទេ ប៉ុន្តែអ្នកអាច[{{fullurl:{{FULLPAGENAME}}|action=edit}} កែសម្រួល] [{{fullurl:{{FULLPAGENAME}}}} អាន] ឬ បង្កើតទំព័រផ្សេងមួយទៀតដោយប្រើប្រអប់ខាងក្រោម។

<createbox>break=no</createbox>",
);

/** Korean (한국어)
 * @author Klutzy
 * @author Yknok29
 */
$messages['ko'] = array(
	'createbox-desc' => '새 문서 생성을 편리하게 만들어 주는 입력 상자',
	'createbox-create' => '생성',
	'createbox-exists' => "‘'''{{FULLPAGENAME}}'''’ 문서가 이미 존재합니다.

따라서 문서를 새로 만들 수는 없지만, [{{fullurl:{{FULLPAGENAME}}|action=edit}} 이 문서를 편집하거나] [{{fullurl:{{FULLPAGENAME}}}} 읽을 수] 있습니다. 또는, 아래 상자를 이용해 다른 문서를 만들어 주세요.

<createbox>break=no</createbox>",
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'createbox-create' => 'Mek sohmtin',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'createbox-desc' => 'En spezjell Feld för der Tittel enzejävve för neu Sigge aanzelääje.',
	'createbox-create' => 'Aanläje!',
	'createbox-exists' => "De Sigg „'''{{FULLPAGENAME}}'''“ es ald doh.

Do kanns se nit aanläje, ävver Do kanns di Sigg
[{{fullurl:{{FULLPAGENAME}}|action=edit}} ändere], [{{fullurl:{{FULLPAGENAME}}}} lesse],
udder en ander Sigg neu aanläje:
<br />
<createbox>break=no</createbox>",
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'createbox-desc' => 'Spezialiséiert Këscht fir Säiten unzeleeën',
	'createbox-create' => 'Maachen',
	'createbox-exists' => "Pardon, \"'''{{FULLPAGENAME}}'''\" gëtt et schonn.

Dir kënnt dës Säit net uleeën, awer Dir kënnt [{{fullurl:{{FULLPAGENAME}}|action=edit}} s'änneren], [{{fullurl:{{FULLPAGENAME}}}} liest] oder wielt fir eng aner Säit unzeleeë mat Hëllef vun der Këscht ënnendrënner.",
);

/** Basa Banyumasan (Basa Banyumasan)
 * @author StefanusRA
 */
$messages['map-bms'] = array(
	'createbox-desc' => '"Inputbox" khusus kanggo nggawe kaca',
	'createbox-create' => 'Gawe',
	'createbox-exists' => "Pangapura, \"'''{{FULLPAGENAME}}'''\" uwis ana.

Rika ora teyeng gawe kaca kiye, ningen Rika teyeng [{{fullurl:{{FULLPAGENAME}}|action=edit}} nyunting], [{{fullurl:{{FULLPAGENAME}}}} maca], utawa nggawe kaca sejene nganggo kotak nang ngisor kiye.

<createbox>break=no</createbox>",
);

/** Malagasy (Malagasy)
 * @author Jagwar
 */
$messages['mg'] = array(
	'createbox-desc' => "Boaty fampidirana teny natokana ho an'ny famoronana pejy",
	'createbox-create' => 'Amboary',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'createbox-desc' => 'Специјализирана вносна кутија за создавање страници',
	'createbox-create' => 'Создај',
	'createbox-exists' => "Жалиме, но „'''{{FULLPAGENAME}}'''“ веќе постои.

Не можете да ја создадете оваа страница, но можете да ја [{{fullurl:{{FULLPAGENAME}}|action=edit}} уредите], [{{fullurl:{{FULLPAGENAME}}}} прочитате], или да изберете да создадете друга страница со помош на кутијата подолу.

<createbox>break=no</createbox>",
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 */
$messages['ml'] = array(
	'createbox-create' => 'സൃഷ്ടിക്കുക',
);

/** Marathi (मराठी)
 * @author Mahitgar
 */
$messages['mr'] = array(
	'createbox-create' => 'तयार करा',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'createbox-desc' => 'Ruang input khusus untuk penciptaan laman',
	'createbox-create' => 'Cipta',
	'createbox-exists' => "Maaf, \"'''{{FULLPAGENAME}}'''\" sudah wujud.

Anda tidak boleh mencipta laman ini, tetapi anda boleh [{{fullurl:{{FULLPAGENAME}}|action=edit}} menyuntingnya], [{{fullurl:{{FULLPAGENAME}}}} membacanya], atau memilih untuk mencipta laman yang baru dengan menggunakan ruangan di bawah.

<createbox>break=no</createbox>",
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'createbox-desc' => "''Inputbox'' speċjalizzata għall-ħolqien ta' paġni",
	'createbox-create' => 'Oħloq',
	'createbox-exists' => "Skużana, \"'''{{FULLPAGENAME}}'''\" teżisti diġà.

Ma tistax toħloq din il-paġna, imma tista' [{{fullurl:{{FULLPAGENAME}}|action=edit}} timmodifikaha], [{{fullurl:{{FULLPAGENAME}}}} taqraha] jew tagħżel li tikkrea paġna differenti bl-użu tal-kaxxa t'hawn taħt.

<createbox>break=no</createbox>",
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'createbox-create' => 'Ticchīhuāz',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['nb'] = array(
	'createbox-desc' => 'Spesialisert tekstboks for sideoppretting',
	'createbox-create' => 'Opprett',
	'createbox-exists' => "Beklager, «'''{{FULLPAGENAME}}'''» finnes fra før.

Du kan ikke opprette denne siden, men du kan [{{fullurl:{{FULLPAGENAME}}|action=edit}} redigere den], [{{fullurl:{{FULLPAGENAME}}}} lese den] eller opprette en annen siden med hjelp av boksen nedenfor.

<createbox>break=no</createbox>",
);

/** Nepali (नेपाली)
 * @author Bhawani Gautam
 * @author Bhawani Gautam Rhk
 */
$messages['ne'] = array(
	'createbox-desc' => 'पृष्ठ सृजनाको निम्ति विशेष इनपुट बाकस',
	'createbox-create' => 'सृजना गर्ने',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'createbox-desc' => "Aangepast invoerveld voor het aanmaken van nieuwe pagina's",
	'createbox-create' => 'Aanmaken',
	'createbox-exists' => "\"'''{{FULLPAGENAME}}'''\" bestaat al.

U kunt deze pagina niet aanmaken, maar u kunt deze [{{fullurl:{{FULLPAGENAME}}|action=edit}} bewerken], [{{fullurl:{{FULLPAGENAME}}}} bekijken], of een andere pagina aanmaken via het onderstaande formulier.

<createbox>break=no</createbox>",
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 */
$messages['nn'] = array(
	'createbox-desc' => 'Spesialisert tekstboks for oppretting av sider',
	'createbox-create' => 'Opprett',
	'createbox-exists' => "Orsak, «'''{{FULLPAGENAME}}'''» finst frå før.

Du kan ikkje oppretta denne sida, men du kan [{{fullurl:{{FULLPAGENAME}}|action=edit}} endra ho], [{{fullurl:{{FULLPAGENAME}}}} lesa ho] eller oppretta ei anna sida ved hjelp av boksen nedanfor.

<createbox>break=no</createbox>",
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'createbox-desc' => 'Bóstia de picada especializada per la creacion de pagina',
	'createbox-create' => 'Crear',
	'createbox-exists' => "O planhèm, \"'''{{FULLPAGENAME}}'''\" existís ja.

Podètz pas crear aquesta pagina, mas la podètz [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificar], [{{fullurl:{{FULLPAGENAME}}}} legir] o causir de crear una pagina diferenta amb l’ajuda de la bóstia çaijós.

<createbox>break=no</createbox>",
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Odisha1
 */
$messages['or'] = array(
	'createbox-create' => 'ତିଆରି',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'createbox-create' => 'Schtaerte',
);

/** Polish (Polski)
 * @author Sp5uhe
 * @author Wpedzich
 */
$messages['pl'] = array(
	'createbox-desc' => 'Specjalizowane pole tekstowe do tworzenia nowych stron',
	'createbox-create' => 'Utwórz',
	'createbox-exists' => "Strona „'''{{FULLPAGENAME}}'''” już istnieje.

Nie możesz utworzyć tej strony, lecz możesz ją [{{fullurl:{{FULLPAGENAME}}|action=edit}} edytować], [{{fullurl:{{FULLPAGENAME}}}} przeczytać], lub stworzyć inną stronę za pomocą poniższego pola wyboru.

<createbox>break=no</createbox>",
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'createbox-desc' => 'Inputbox specialisà për creassion ëd pàgine',
	'createbox-create' => 'Crea',
	'createbox-exists' => "Am dëspias, \"'''{{FULLPAGENAME}}'''\" a esist già.

It peule pa creé sta pàgina-sì, ma it peule [{{fullurl:{{FULLPAGENAME}}|action=edit}} modifichela], [{{fullurl:{{FULLPAGENAME}}}} lesla], o serne ëd creé na pàgina diferenta an dovrand ël box sota.

<createbox>break=no</createbox>",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'createbox-create' => 'جوړول',
	'createbox-exists' => "بخښنه دې وي چې د \"'''{{FULLPAGENAME}}'''\" په نوم مخ د پخوا نه شته.

تاسې دا مخ نه شی جوړولای، خو تاسې کولای شی چې [{{fullurl:{{FULLPAGENAME}}|action=edit}} سم يې کړی]، [{{fullurl:{{FULLPAGENAME}}}} وې لولی]، او يا هم د لانديني چوکاټ په کارولو سره په کوم بل نوم يو مخ جوړ کړی.

<createbox>break=no</createbox>",
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Malafaya
 * @author Waldir
 */
$messages['pt'] = array(
	'createbox-desc' => 'Caixa especializada para a criação de páginas',
	'createbox-create' => 'Criar',
	'createbox-exists' => "Desculpe, \"'''{{FULLPAGENAME}}'''\" já existe.

Não pode criar esta página, mas pode [{{fullurl:{{FULLPAGENAME}}|action=edit}} editá-la], 
[{{fullurl:{{FULLPAGENAME}}}} lê-la], ou optar por criar uma página diferente usando a caixa abaixo.

<createbox>break=no</createbox>",
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 */
$messages['pt-br'] = array(
	'createbox-desc' => 'Inputbox especializado para a criação de páginas',
	'createbox-create' => 'Criar',
	'createbox-exists' => "Desculpe, \"'''{{FULLPAGENAME}}'''\" já existe.

Você não pode criar esta página, mas pode [{{fullurl:{{FULLPAGENAME}}|action=edit}} editá-la],  
[{{fullurl:{{FULLPAGENAME}}}} lê-la], ou optar por criar uma página diferente usando a caixa abaixo.

<createbox>break=no</createbox>",
);

/** Romanian (Română)
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'createbox-create' => 'Creează',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'createbox-desc' => 'scatele de input specializzate pe le ccreaziune de le pàggene',
	'createbox-create' => 'Ccreje',
	'createbox-exists' => "Me dispiace, \"'''{{FULLPAGENAME}}'''\" già esiste.

Tu non ge puè ccrejà sta pàgene, ma tu 'a puè [{{fullurl:{{FULLPAGENAME}}|action=edit}} cangià], [{{fullurl:{{FULLPAGENAME}}}} leggerle], o scacchie de ccrejà 'a pàgene cu 'nu nome differende ausanne 'a scatele ca ste aqquà sotte.

<createbox>break=no</createbox>",
);

/** Russian (Русский)
 * @author Ferrer
 * @author Innv
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'createbox-desc' => 'Специализированные формы для создания страниц',
	'createbox-create' => 'Создать',
	'createbox-exists' => "Извините, \"'''{{FULLPAGENAME}}'''\" уже существует.

Вы не можете создать эту страницу, но вы можете [{{fullurl:{{FULLPAGENAME}}|action=edit}} отредактировать], [{{fullurl:{{FULLPAGENAME}}}} просмотреть] её, или выбрать для создания другую страницу в форме.

<createbox>break=no</createbox>",
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'createbox-create' => 'Створити',
);

/** Sakha (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'createbox-desc' => 'Сирэй айарга аналлаах формалар',
	'createbox-create' => 'Айарга',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'createbox-desc' => 'Špecializované vstupné pole na vytváranie stránok',
	'createbox-create' => 'Vytvoriť',
	'createbox-exists' => "Prepáčte, „'''{{FULLPAGENAME}}'''” už existuje.

Túto stránku nemôžete vytvoriť, ale môžete ju [{{fullurl:{{FULLPAGENAME}}|action=edit}} upravovať], [{{fullurl:{{FULLPAGENAME}}}} čítať] alebo vytvoriť inú stránku pomocou tohto vstupného poľa.

<createbox>break=no</createbox>",
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬) */
$messages['sr-ec'] = array(
	'createbox-create' => 'Направи',
);

/** Serbian (Latin script) (‪Srpski (latinica)‬) */
$messages['sr-el'] = array(
	'createbox-create' => 'Napravi',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 * @author Kandar
 */
$messages['su'] = array(
	'createbox-desc' => 'Kotak asupan husus pikeun nyieun kaca',
	'createbox-create' => 'Jieun',
);

/** Swedish (Svenska)
 * @author M.M.S.
 */
$messages['sv'] = array(
	'createbox-desc' => 'Specialiserad formulärbox för sidskapning',
	'createbox-create' => 'Skapa',
	'createbox-exists' => "Beklagar, \"'''{{FULLPAGENAME}}'''\" existerar redan.

Du kan inte skapa den här sidan, men du kan [{{fullurl:{{FULLPAGENAME}}|action=edit}} redigera den], [{{fullurl:{{FULLPAGENAME}}}} läsa den], eller välja att skapa en annan sida genom att använda boxen nedan.

<createbox>break=no</createbox>",
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 */
$messages['sw'] = array(
	'createbox-desc' => 'Kisanduku ingizo maalum kwa ajili ya kuanzisha ukurasa',
	'createbox-create' => 'Anzisha kurasa',
	'createbox-exists' => "Kumradhi, \"'''{{FULLPAGENAME}}'''\" inapatikana tayari.

Huwezi kuanzisha ukurasa, lakini unaweza [{{fullurl:{{FULLPAGENAME}}|action=edit}} kuuhariri] au [{{fullurl:{{FULLPAGENAME}}}} kuusoma], au kuanzisha ukurasa mwingine kwa kutumia sanduku iliyopo chini.",
);

/** Tamil (தமிழ்)
 * @author TRYPPN
 */
$messages['ta'] = array(
	'createbox-create' => 'உருவாக்கவும்',
);

/** Telugu (తెలుగు)
 * @author Kiranmayee
 * @author Veeven
 */
$messages['te'] = array(
	'createbox-desc' => 'వ్యాసమును సృష్టించుటకు ఒక ప్రత్యేక ఇన్పుట్ బాక్స్',
	'createbox-create' => 'సృష్టించు',
	'createbox-exists' => "క్షమించండి, \"'''{{FULLPAGENAME}}'''\" ఇప్పటికే ఉంది.

ఈ పేజీని మీరు సృష్టించలేరు, కానీ మీరు [{{fullurl:{{FULLPAGENAME}}|action=edit}} దీన్ని మార్చవచ్చు], [{{fullurl:{{FULLPAGENAME}}}} చదువవచ్చు], లేదా క్రింది పెట్టెని ఉపయోగించి మరో పేజీని సృష్టించవచ్చు.

<createbox>break=no</createbox>",
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'createbox-create' => 'Kria',
);

/** Tajik (Cyrillic script) (Тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'createbox-create' => 'Эҷод',
);

/** Tajik (Latin script) (tojikī)
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'createbox-create' => 'Eçod',
);

/** Thai (ไทย)
 * @author Ans
 */
$messages['th'] = array(
	'createbox-desc' => 'inputbox ที่ออกแบบมาเฉพาะสำหรับการสร้างหน้าใหม่',
	'createbox-create' => 'สร้างหน้า',
	'createbox-exists' => "ขออภัย, มีเนื้อหาชื่อ \"'''{{FULLPAGENAME}}'''\" อยู่ก่อนแล้ว.

คุณไม่สามารถสร้างหน้านี้ได้, แต่คุณสามารถ[{{fullurl:{{FULLPAGENAME}}|action=edit}} แก้ไข]หรือ[{{fullurl:{{FULLPAGENAME}}}} เปิดอ่าน]หน้านี้, หรือเลือกที่จะสร้างเนื้อหาในชื่ออื่น โดยใช้กล่องด้านล่างนี้.

<createbox>break=no</createbox>",
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'createbox-create' => 'Döret',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'createbox-desc' => 'Natatanging lalagyang-kahon para sa paglikha ng pahina',
	'createbox-create' => 'Likhain',
	'createbox-exists' => "Paumanhin, umiiral na ang \"'''{{FULLPAGENAME}}'''\".

Hindi mo malilikha ang pahinang ito, subalit maaari mong [{{fullurl:{{FULLPAGENAME}}|action=edit}} baguhin ito], [{{fullurl:{{FULLPAGENAME}}}} basahin ito], o piliing lumikha ng isang naiibang pahina na ginagamit ang kahong nasa ibaba.
 
<createbox>break=no</createbox>",
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Karduelis
 */
$messages['tr'] = array(
	'createbox-desc' => 'Sayfası oluşturmak için özelleştirilmiş girdikutusu',
	'createbox-create' => 'Oluştur',
	'createbox-exists' => "Üzgünüz, \"'''{{FULLPAGENAME}}'''\" zaten mevcut.

Bu sayfayı oluşturamazsınız, ancak [{{fullurl:{{FULLPAGENAME}}|action=edit}} değiştirebilir], [{{fullurl:{{FULLPAGENAME}}}} okuyabilir], ya da aşağıdaki kutuyu kullanarak farklı bir sayfa oluşturmayı seçebilirsiniz.

<createbox>break=no</createbox>",
);

/** Ukrainian (Українська)
 * @author AS
 */
$messages['uk'] = array(
	'createbox-desc' => 'Спеціалізоване поле вводу для створення сторінок',
	'createbox-create' => 'Створити',
	'createbox-exists' => "Даруйте, \"'''{{FULLPAGENAME}}'''\" вже існує.

Ви не можете створити цю сторінку, але ви можете [{{fullurl:{{FULLPAGENAME}}|action=edit}} редагувати її], [{{fullurl:{{FULLPAGENAME}}}} переглянути її], або створити іншу сторінку, використовуючи поле нижче.

<createbox>break=no</createbox>",
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'createbox-desc' => 'Inputbox specialixà par la creassion de pàxene',
	'createbox-create' => 'Crèa',
	'createbox-exists' => "Scusa, \"'''{{FULLPAGENAME}}'''\" la esiste de xà.

No ti pol crear sta pàxena, ma ti pol [{{fullurl:{{FULLPAGENAME}}|action=edit}} modificarla], [{{fullurl:{{FULLPAGENAME}}}} lèxerla] o sièliere de crear na pàxena difarente doparando la casèla qua soto.

<createbox>break=no</createbox>",
);

/** Vietnamese (Tiếng Việt)
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'createbox-desc' => 'Hộp nhập liệu đặc biệt dùng để tạo trang',
	'createbox-create' => 'Tạo',
	'createbox-exists' => "Xin lỗi, \"'''{{FULLPAGENAME}}'''\" đã tồn tại.

Bạn không thể tạo trang này, nhưng bạn có thể [{{fullurl:{{FULLPAGENAME}}|action=edit}} sửa đổi nó], [{{fullurl:{{FULLPAGENAME}}}} đọc nó], hoặc chọn tạo một trang khác sử dụng hộp phía dưới.

<createbox>break=no</createbox>",
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'createbox-create' => 'Jafön',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'createbox-create' => 'שאַפֿן',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Gzdavidwong
 */
$messages['zh-hans'] = array(
	'createbox-desc' => '于Wiki中包含创建页面的输入框',
	'createbox-create' => '建立',
	'createbox-exists' => "抱歉，'''{{FULLPAGENAME}}'''已经存在于{{SITENAME}}。

你不能创建本页，但你可以[{{fullurl:{{FULLPAGENAME}}|action=edit}} 编辑本页]、[{{fullurl:{{FULLPAGENAME}}}} 阅读本页]或在下方输入另一个名字继续创建页面：

<createbox>break=no</createbox>",
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Horacewai2
 * @author Mark85296341
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'createbox-desc' => '於Wiki中包含建立頁面的輸入框',
	'createbox-create' => '建立',
	'createbox-exists' => "抱歉，'''{{FULLPAGENAME}}'''已經存在於{{SITENAME}}。

你不能建立本頁，但你可以[{{fullurl:{{FULLPAGENAME}}|action=edit}} 編輯本頁]、[{{fullurl:{{FULLPAGENAME}}}} 閱讀本頁]或在下方輸入另一個名字繼續建立頁面：

<createbox>break=no</createbox>",
);

