{-DHUN| module to switch between different ttf fonts during latex code generation DHUN-}
module FontTool where
import MegaFont
import BaseFont
import Data.Char
import Data.Array
import Data.Map hiding ((!))
import Data.Maybe
import System.Info
 
{-DHUN| a map taking a FontStyle as key. (see FontStyle in the BaseFont module). The Values of a maps is and array. The array has got an integer index covering 16 bit. The elements of the arrows are chars. These chars can be converted to the paths of ttf files on disc. (see functions fromCharToFont and getttf in the module BaseFont on how to converts the char to a path to a ttf file on disc). The idea is that you got a 16 Bit unicode charter with certain font style properties. It put in this information in the this map and the array you get from it you get the idea ttf file to print that character in that fontstyle in a latex document DHUN-}
 
megafont2 :: Map FontStyle (Array Int Char)
megafont2
  = Data.Map.fromList
      [(s,
        array ((0, (2 :: Int) ^ (16 :: Int) - 1) :: (Int, Int))
          (zip ([0 .. (2 :: Int) ^ (16 :: Int) - 1] :: [Int]) f))
       | (s, f) <- megafont]
 
{-DHUN| takes a fontstyle and a 16 bis unicode charater and give you the ideal font to print this character in a LaTeX docuemnt. See also megafont2 in this module DHUN-}
 
getFont :: FontStyle -> Char -> Font
getFont fontStyle c
  = fromMaybe GnuUnifont
      ((Data.Map.lookup fontStyle megafont2) >>=
         return . fromCharToFont . (! (if (ord c) >65535 then ord (' ') else (ord c))))
 
{-DHUN| Takes a font and returns the LaTeX Command to switch to this particular font in xelatex DHUN-}
 
fontsetter :: Font -> [Char]
fontsetter f
  = if os == "linux" then
      "\\setmainfont" ++ inner ++ "\\setmonofont" ++ innermono else ""
  where filename
          = reverse ((takeWhile (/= '/')) (reverse (getttf f)))
        pathname = reverse ((dropWhile (/= '/')) (reverse (getttf f)))
        inner = "[Path=" ++ pathname ++ (mid f) ++ "]{" ++ filename ++ "}"
        innermono
          = "[Path=" ++ pathname ++ (midmono f) ++ "]{" ++ filename ++ "}"
        mid i
          | i `elem`
              [ComputerModernRoman, ComputerModernRomanBold,
               ComputerModernRomanItalic, ComputerModernRomanBoldItalic,
               ComputerModernTypeWriter, ComputerModernTypeWriterBold,
               ComputerModernTypeWriterItalic, ComputerModernTypeWriterBoldItalic]
            =
            ",UprightFont=cmunrm.ttf,BoldFont=cmunbx.ttf" ++
              ",ItalicFont=cmunti.ttf,BoldItalicFont=cmunbi.ttf"
        mid i
          | i `elem`
              [FreeSerif, FreeSerifBold, FreeSerifBoldItalic, FreeSerifItalic,
               FreeMono, FreeMonoOblique, FreeMonoBold, FreeMonoBoldOblique]
            =
            ",UprightFont=FreeSerif.ttf,BoldFont=FreeSerifBold.ttf," ++
              "ItalicFont=FreeSerifItalic.ttf,BoldItalicFont=FreeSerifBoldItalic.ttf"
        mid _ = ""
        midmono i
          | i `elem`
              [ComputerModernRoman, ComputerModernRomanBold,
               ComputerModernRomanItalic, ComputerModernRomanBoldItalic,
               ComputerModernTypeWriter, ComputerModernTypeWriterBold,
               ComputerModernTypeWriterItalic, ComputerModernTypeWriterBoldItalic]
            =
            ",UprightFont=cmuntt.ttf,BoldFont=cmuntb.ttf" ++
              ",ItalicFont=cmunit.ttf,BoldItalicFont=cmuntx.ttf"
        midmono i
          | i `elem`
              [FreeSerif, FreeSerifBold, FreeSerifBoldItalic, FreeSerifItalic,
               FreeMono, FreeMonoOblique, FreeMonoBold, FreeMonoBoldOblique]
            =
            ",UprightFont=FreeMono.ttf,BoldFont=FreeMonoBold.ttf," ++
              "ItalicFont=FreeMonoOblique.ttf,BoldItalicFont=FreeMonoBoldOblique.ttf"
        midmono _ = ""
 
{-DHUN| Takes a FontStyle and returns the LaTeX Command to switch to that font. DHUN-}
 
fontstyler :: FontStyle -> [Char]
fontstyler s
  = (if (stylebase s) == Mono then "\\ttfamily " else "") ++
      (if (bold s) == True then "\\bfseries " else "") ++
        (if (italic s) == True then "\\itshape " else "")
