#!/bin/bash

set -e

BUILD=${BUILD:=build}
CLICK_SDK_ARCH=${CLICK_SDK_ARCH:=armhf}
CLICK_SDK_FRAMEWORK=${CLICK_SDK_FRAMEWORK:=ubuntu-sdk-15.04}
CLICK_CHROOT_SUFFIX=${CLICK_CHROOT_SUFFIX:=click}

export CLICK_SDK_ARCH CLICK_SDK_FRAMEWORK CLICK_CHROOT_SUFFIX
if [ "$1" = "clean" ]; then
    rm -rf "$BUILD"
    shift
fi

mkdir -p "$BUILD" && cd "$BUILD"

SDK_PATH="/usr/share/qtcreator/ubuntu/scripts"
${SDK_PATH}/qtc_chroot_cmake2 ${CLICK_SDK_ARCH} ${CLICK_SDK_FRAMEWORK} ${CLICK_CHROOT_SUFFIX} ..
${SDK_PATH}/qtc_chroot_make2 all

echo -e "\033[1;32m [ ${CLICK_SDK_ARCH} ] Build complete.\033[0m"

