/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_ASSOCIATIVE_CONNECTOR_FACTORY_H_
#define MESSAGING_ASSOCIATIVE_CONNECTOR_FACTORY_H_

#include <messaging/connector_factory.h>
#include <messaging/visibility.h>

#include <map>

namespace messaging
{
/// @brief AssociativeConnectorFactory implements ConnectorFactory on top of a std::map.
class MESSAGING_FW_PUBLIC AssociativeConnectorFactory : public ConnectorFactory
{
public:
    /// @brief create_instance_for_name returns a Generator for the given name.
    /// @throws std::out_of_range if no generator is known for the given name.
    Generator create_instance_for_name(const std::string& name) const override;

    /// @brief has_generator_for_name returns true if a generator is known for the given name.
    bool has_generator_for_name(const std::string& name) const noexcept(true);

    /// @brief add_generator_for_name makes the given generator known under the given name.
    void add_generator_for_name(const std::string& name, const Generator& generator) noexcept(true);

    /// @brief remove_generator_for_name removes the generator for the given name.
    void remove_generator_for_name(const std::string& name) noexcept(true);

private:
    std::map<std::string, Generator> generators;
};
}

#endif  // MESSAGING_ASSOCIATIVE_CONNECTOR_FACTORY_H_
