/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_NON_MOVABLE_H_
#define MESSAGING_NON_MOVABLE_H_

#include <messaging/visibility.h>

namespace messaging
{
/// @cond
class MESSAGING_FW_PUBLIC NonMovable
{
  public:
    virtual ~NonMovable() = default;
    NonMovable(NonMovable&&) = delete;
    NonMovable& operator=(NonMovable&&) = delete;

  protected:
    NonMovable() = default;
};
/// @endcond
}

#endif // MESSAGING_NON_MOVABLE_H_
