/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_PLUGIN_H_
#define MESSAGING_PLUGIN_H_

namespace messaging
{
// Forward declare the Connector class to use it in create/destroy entry point declaration.
class Connector;
};

/// @brief Marks the symbol that is resolved by messaging::Runner to instantiate a messaging::Connector instance.
#define MESSAGING_FW_CREATE_FUNCTION messaging_fw_create_connector
#define MESSAGING_FW_CREATE_FUNCTION_NAME "messaging_fw_create_connector"

/// @brief Marks the symbol that is resolved by messaging::Runner to destroy a messaging::Connector instance.
#define MESSAGING_FW_DESTROY_FUNCTION messaging_fw_destroy_connector
#define MESSAGING_FW_DESTROY_FUNCTION_NAME "messaging_fw_destroy_connector"

/// @brief the function called by the messaging runtime to instantiate a new messaging::Connector instance.
extern "C" __attribute__((used)) __attribute__((visibility("default"))) messaging::Connector* MESSAGING_FW_CREATE_FUNCTION();

/// @brief the function called by the messaging runtime to destroy a messaging::Connector instance.
extern "C" __attribute__((used)) __attribute__((visibility("default"))) void MESSAGING_FW_DESTROY_FUNCTION(messaging::Connector*);

namespace messaging
{
/// @brief Make the create function signature available as a type.
typedef decltype(&MESSAGING_FW_CREATE_FUNCTION) PluginCreateFunction;
/// @brief Make the destroy function signature available as a type.
typedef decltype(&MESSAGING_FW_DESTROY_FUNCTION) PluginDestroyFunction;
}

#endif // MESSAGING_PLUGIN_H_
