/*
 * Copyright 2014-2016 Canonical Ltd.
 *
 * This file and its implementation is adaptation of sync-monitor.
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_NETWORK_MONITOR
#define MESSAGING_QT_NETWORK_MONITOR

#include <QtNetwork/QNetworkConfigurationManager>
#include <QTimer>

#include <memory>

namespace messaging
{

//Handy fw declaration
class Connection;

namespace qt
{

class NetworkMonitor : public QObject
{
    Q_OBJECT
public:
    enum NetworkState {
        NetworkOffline = 0,
        NetworkPartialOnline,
        NetworkOnline
    };
    NetworkMonitor(const std::weak_ptr<Connection> &connection, QObject *parent=0);
    virtual ~NetworkMonitor();

    void stop_monitoring();
    void set_connection_ready(bool ready);

private Q_SLOTS:
    void refresh();
    void idle_refresh();

private:
    QNetworkConfigurationManager network_config_manager_;
    QTimer refresh_timer_;
    std::weak_ptr<Connection> connection_;
    std::string current_ssid_;
    bool is_connection_ready_;


    void start_monitoring();
    void dump(const QNetworkConfiguration &config);
};

}
}

#endif // MESSAGING_QT_NETWORK_MONITOR

