/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_SUBJECT_H
#define MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_SUBJECT_H

#include <TelepathyQt/BaseChannel>

#include <messaging/visibility.h>

#include <messaging/qt/tp/interfaces/types.h>

namespace messaging
{
namespace qt
{
namespace tp
{
namespace interfaces
{

class MESSAGING_FW_LOCAL BaseChannelSubjectInterface : public Tp::AbstractChannelInterface
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseChannelSubjectInterface)

public:
    static BaseChannelSubjectInterfacePtr create() {
        return BaseChannelSubjectInterfacePtr(new BaseChannelSubjectInterface());
    }
    template<typename BaseChannelSubjectInterfaceSubclass>
    static Tp::SharedPtr<BaseChannelSubjectInterfaceSubclass> create() {
        return Tp::SharedPtr<BaseChannelSubjectInterfaceSubclass>(
                   new BaseChannelSubjectInterfaceSubclass());
    }
    virtual ~BaseChannelSubjectInterface();

    QVariantMap immutableProperties() const;

    QString subject() const;
    void setSubject(const QString& subject);

    QString actor() const;
    void setActor(const QString &actor);

    uint actorHandle() const;
    void setActorHandle(uint handle);

    qlonglong timestamp() const;
    void setTimestamp(qlonglong timestamp);

    bool canSet() const;
    void setCanSet(bool canSet);

    typedef Tp::Callback2<void, const QString&, Tp::DBusError*> SetSubjectCallback;
    void setSetSubjectCallback(const SetSubjectCallback &cb);
    void setSubject(const QString &subject, Tp::DBusError *error);

private:
    BaseChannelSubjectInterface();
    void createAdaptor();

    class Adaptee;
    friend class Adaptee;
    struct Private;
    friend struct Private;
    Private *mPriv;
};


}
}
}
}
#endif // MESSAGING_QT_TP_INTERFACES_BASE_CHANNEL_SUBJECT_H
