/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MESSAGING_QT_VARIANT_H_
#define MESSAGING_QT_VARIANT_H_

#include <messaging/variant.h>
#include <messaging/visibility.h>

#include <QtCore/QVariant>

namespace messaging
{
namespace qt
{
/// @brief Variant maps QVariant to fw's world.
class MESSAGING_FW_PUBLIC Variant : public messaging::Variant
{
public:
    Variant(const QVariant& qv = QVariant{});
    Variant(const Variant& rhs);
    Variant& operator=(const Variant& rhs);
    messaging::Variant::Type type() const override;

    bool as_bool() const override;
    std::int64_t as_int() const override;
    double as_double() const override;
    std::string as_string() const override;
    const char* as_data() const override;
    std::size_t data_size() const override;

    std::size_t size() const override;
    std::deque<std::string> keys() const override;
    std::shared_ptr<messaging::Variant> at(const std::string& key) const override;
    std::shared_ptr<messaging::Variant> at(std::size_t idx) const override;

private:
    QVariant qv;
};
}
}

#endif  // MESSAGING_QT_VARIANT_H_
