/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/associative_dictionary.h>

bool messaging::AssociativeDictionary::has_value_for_key(const std::string& key) const
{
    return data.count(key) > 0;
}

std::string messaging::AssociativeDictionary::value_for_key(const std::string& key) const
{
    return data.at(key);
}

void messaging::AssociativeDictionary::set_value_for_key(const std::string& key, const std::string& value)
{
    data.insert(std::make_pair(key, value));
}
