/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/has_interfaces.h>

#include <messaging/interface.h>

struct messaging::HasInterfaces::Private
{
    messaging::InterfacesSet interfaces;
};

messaging::HasInterfaces::HasInterfaces()
        : impl{new Private{}}
{
}

const messaging::InterfacesSet &messaging::HasInterfaces::interfaces()
{
    return impl->interfaces;
}

void messaging::HasInterfaces::plug_interface(const std::shared_ptr<Interface>& interface)
{
    impl->interfaces.insert(interface);

    interface->on_plugged(shared_from_this());
    on_interface_plugged(interface);
}

void messaging::HasInterfaces::on_interface_plugged(const std::shared_ptr<Interface> &/*interface*/)
{
    // left empty on purpose
}
