/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/presence_manager.h>
#include <messaging/recipient.h>

struct messaging::PresenceManager::Private
{
    std::shared_ptr<messaging::PresenceManager::Observer> observer;
};

messaging::PresenceManager::PresenceManager(const std::shared_ptr<messaging::PresenceManager::Observer>& observer)
        : impl{new Private{observer}}
{
}

void messaging::PresenceManager::announce_presence_changed(const Recipient::shared_ptr& recipient, const messaging::Presence& presence)
{
    impl->observer->on_presence_changed(recipient, presence);
}
