/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/tp/protocol.h>

#include <messaging/connector.h>
#include <messaging/enumerator.h>
#include <messaging/parameter.h>

#include <messaging/qt/runtime.h>
#include <messaging/qt/tp/connection.h>

#include <TelepathyQt/BaseConnection>

#include <TelepathyQt/ProtocolParameterList>
#include <TelepathyQt/RequestableChannelClassSpec>
#include <TelepathyQt/RequestableChannelClassSpecList>

namespace
{
template <typename Enum>
struct FlagHelper
{
    template <Enum value>
    static bool is_set_in(Enum flags)
    {
        return (flags & value) == value;
    }
};

Tp::ConnMgrParamFlags parameter_flags_to_qt_tp(const messaging::Parameter::Flags& flags)
{
    Tp::ConnMgrParamFlags result;

    if (FlagHelper<messaging::Parameter::Flags>::is_set_in<messaging::Parameter::Flags::required>(flags))
    {
        result |= Tp::ConnMgrParamFlagRequired;
    }
    if (FlagHelper<messaging::Parameter::Flags>::is_set_in<messaging::Parameter::Flags::secret>(flags))
    {
        result |= Tp::ConnMgrParamFlagSecret;
    }
    if (FlagHelper<messaging::Parameter::Flags>::is_set_in<messaging::Parameter::Flags::required_for_registration>(
            flags))
    {
        result |= Tp::ConnMgrParamFlagRegister;
    }

    return result;
}
}

messaging::qt::tp::Protocol::Protocol(const std::shared_ptr<messaging::Connector>& connector,
                                      const std::shared_ptr<messaging::qt::Runtime>& runtime,
                                      const QString& connection_manager_name,
                                      const QString& protocol_name)
    : Tp::BaseProtocol{runtime->dbus_connection(), protocol_name}
    , runtime{runtime}
    , connection_manager_name{connection_manager_name}
    , connector{connector}
{
    addressingIface = Tp::BaseProtocolAddressingInterface::create();
    // FIXME: ugly hardcoding of values detected!!!!!
    addressingIface->setAddressableVCardFields(QStringList() << QLatin1String("tel"));
    addressingIface->setAddressableUriSchemes(QStringList() << QLatin1String("tel"));
    plugInterface(Tp::AbstractProtocolInterfacePtr::dynamicCast(addressingIface)); 
    setRequestableChannelClasses(Tp::RequestableChannelClassSpecList() << Tp::RequestableChannelClassSpec::textChat());
    setCreateConnectionCallback(memFun(this, &tp::Protocol::create_connection));

    Tp::ProtocolParameterList ppl;
    connector->parameters().enumerate([&ppl](const Parameter& parameter)
                                      {
                                          ppl << Tp::ProtocolParameter(QString::fromStdString(parameter.name),
                                                                       QString::fromStdString(parameter.signature),
                                                                       parameter_flags_to_qt_tp(parameter.flags));
                                      });
    setParameters(ppl);
}

messaging::qt::tp::Protocol::~Protocol()
{
}

Tp::BaseConnectionPtr messaging::qt::tp::Protocol::create_connection(const QVariantMap& parameters,
                                                                     Tp::DBusError* /*error*/)
{
    return tp::Connection::create(connector, runtime, connection_manager_name, name(), parameters);
}
