#include <messaging/utils.h>

#include <messaging/member.h>
#include <messaging/members.h>

/*!
 * \brief calculate which ids are in users list and not in original_ids_list
 */

QStringList messaging::ids_to_add(const QSet<QString> &original_ids_list, const Members& users)
{
    QStringList return_ids_list;
    for (auto user : users)
    {
        QString user_id = QString::fromStdString(user->id());
        auto it = original_ids_list.find(user_id);
        // if user not found in original list, add it to return one
        if (it == original_ids_list.constEnd())
        {
            return_ids_list.append(user_id);
        }
    }
    return return_ids_list;
}

QStringList messaging::ids_to_remove(const QSet<QString> &original_ids_list, const Members& users)
{
    // copy original list and remove from there any user found
    QSet<QString> set_of_ids_to_remove = original_ids_list;
    for (auto user : users)
    {
        QString user_id = QString::fromStdString(user->id());
        auto it = set_of_ids_to_remove.find(user_id);
        // if user found in original list, remove it from the set of ids to remove
        if (it != set_of_ids_to_remove.constEnd())
        {
            set_of_ids_to_remove.erase(it);
        }
    }

    return set_of_ids_to_remove.toList();
}
