/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MOCK_GROUP_STARTER_H
#define TESTING_MOCK_GROUP_STARTER_H

#include <messaging/group_starter.h>
#include <messaging/group_manager.h>

#include <gmock/gmock.h>

#include <memory>

namespace testing
{
class MockGroupStarter : public messaging::GroupStarter
{
public:
    MOCK_METHOD1(create_group, std::shared_ptr<messaging::GroupManager>(const std::shared_ptr<messaging::Group>&));
    MOCK_METHOD1(accept_group, std::shared_ptr<messaging::GroupManager>(const std::shared_ptr<messaging::Group>&));
    MOCK_METHOD1(rejoin_group, std::shared_ptr<messaging::GroupManager>(const std::shared_ptr<messaging::Group>&));
    MOCK_METHOD1(reject_group, void(const std::shared_ptr<messaging::Group>&));
    MOCK_METHOD1(create_broadcast, std::shared_ptr<messaging::Broadcast>(const messaging::Members&));
};

}


#endif // TESTING_MOCK_GROUP_STARTER_H

