/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mock_messenger.h"
#include "mock_chat.h"

namespace testing
{

MockMessenger::MockMessenger(const std::shared_ptr<messaging::Messenger::Observer>& observer)
    : messaging::Messenger{observer}
{
    ON_CALL(*this, create_chat_with(_,_)).WillByDefault(Invoke(this, &MockMessenger::fake_create_chat_with));
}

void MockMessenger::announce_message_without_chat_received(const messaging::Recipient::shared_ptr& recipient,
                                                           const messaging::Message& message)
{
    messaging::Messenger::announce_message_without_chat_received(recipient, message);
}

void MockMessenger::announce_new_group_invitation_received(const std::shared_ptr<messaging::Group> &group)
{
    messaging::Messenger::announce_new_group_invitation_received(group);
}

std::shared_ptr<messaging::Chat> MockMessenger::fake_create_chat_with(const messaging::Recipient::shared_ptr&,
                                                         const std::shared_ptr<messaging::Chat::Observer>& chat_observer)
{
    return std::make_shared<NiceMock<MockChat>>(chat_observer);
}

}
