/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mock_presence_manager.h"
#include <messaging/presence.h>

namespace testing
{

MockPresenceManager::MockPresenceManager(const std::shared_ptr<messaging::PresenceManager::Observer>& observer)
    : messaging::PresenceManager{observer}
{
    ON_CALL(*this, get_valid_statuses()).WillByDefault(
                Invoke(this, &MockPresenceManager::fake_get_valid_statuses));
}

void MockPresenceManager::announce_presence_changed(const messaging::Recipient::shared_ptr& recipient, const messaging::Presence& presence)
{
    messaging::PresenceManager::announce_presence_changed(recipient, presence);
}

messaging::PresenceManager::StatusMap MockPresenceManager::fake_get_valid_statuses()
{
    return messaging::PresenceManager::StatusMap{
        {"available", messaging::StatusSpec{messaging::PresenceType::available,
                        messaging::StatusSpec::Flags::can_have_message & messaging::StatusSpec::Flags::may_set_on_self}},
        {"offline", messaging::StatusSpec{messaging::PresenceType::offline,
                        messaging::StatusSpec::Flags::can_have_message & messaging::StatusSpec::Flags::may_set_on_self}},
        {"pstn", messaging::StatusSpec{messaging::PresenceType::unknown, messaging::StatusSpec::Flags::may_set_on_self}},
        {"unknown", messaging::StatusSpec{messaging::PresenceType::unknown, messaging::StatusSpec::Flags::none}}};
}

}
