/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/dynamic_library.h>

#include "test_data.h"

#include <boost/filesystem.hpp>

#include <gtest/gtest.h>

namespace
{
typedef int (*test_symbol)();
}

TEST(DynamicLibrary, construction_for_existing_shared_object_does_not_throw)
{
    ASSERT_TRUE(boost::filesystem::exists(testing::dynamic_library_path()));
    messaging::DynamicLibrary dl{testing::dynamic_library_path()};
}

TEST(DynamicLibrary, construction_for_non_existing_shared_object_throws)
{
    boost::filesystem::path does_not_exist("42");
    boost::filesystem::remove(does_not_exist);
    EXPECT_THROW(messaging::DynamicLibrary dl{does_not_exist}, std::runtime_error);
}

TEST(DynamicLibrary, load_existing_symbol_works)
{
    messaging::DynamicLibrary dl{testing::dynamic_library_path()};
    auto sym = reinterpret_cast<test_symbol>(dl.load_symbol_for_name("test_symbol"));
    EXPECT_EQ(42, sym());
}

TEST(DynamicLibrary, load_unknown_symbol_throws)
{
    messaging::DynamicLibrary dl{testing::dynamic_library_path()};
    EXPECT_THROW(dl.load_symbol_for_name("totally_does_not_exist_in_the_so"), std::runtime_error);
}
