#include <messaging/utils.h>

#include <gtest/gtest.h>
#include <messaging/members.h>
#include <messaging/member.h>

namespace testing
{

TEST(MembersTest, verify_ids_to_add_regular_case)
{
    messaging::Members users;
    users.push_back(std::make_shared<messaging::Member>("+8615014902027"));
    users.push_back(std::make_shared<messaging::Member>("+8613811964787"));
    users.push_back(std::make_shared<messaging::Member>("+8615976951459"));

    QSet<QString> original_set;
    original_set.insert("+8613811964787");

    auto to_add_ids_set = messaging::ids_to_add(original_set, users);
    EXPECT_EQ(to_add_ids_set.count(), 2);
    EXPECT_EQ(to_add_ids_set.at(0), "+8615014902027");
    EXPECT_EQ(to_add_ids_set.at(1), "+8615976951459");
}

TEST(MembersTest, verify_ids_to_add_empty_original_set)
{
    messaging::Members users;
    users.push_back(std::make_shared<messaging::Member>("+8615014902027"));
    users.push_back(std::make_shared<messaging::Member>("+8613811964787"));
    users.push_back(std::make_shared<messaging::Member>("+8615976951459"));

    QSet<QString> original_set;

    auto to_add_ids_set = messaging::ids_to_add(original_set, users);
    EXPECT_EQ(to_add_ids_set.count(), 3);
    EXPECT_EQ(to_add_ids_set.at(0), "+8615014902027");
    EXPECT_EQ(to_add_ids_set.at(1), "+8613811964787");
    EXPECT_EQ(to_add_ids_set.at(2), "+8615976951459");
}

TEST(MembersTest, verify_ids_to_add_empty_user_list)
{
    messaging::Members users;

    QSet<QString> original_set;
    original_set.insert("+8613811964787");

    auto to_add_ids_set = messaging::ids_to_add(original_set, users);
    EXPECT_EQ(to_add_ids_set.count(), 0);
}

TEST(MembersTest, verify_ids_to_remove_regular_case)
{
    messaging::Members users;
    users.push_back(std::make_shared<messaging::Member>("+8615014902027"));
    users.push_back(std::make_shared<messaging::Member>("+8613811964787"));
    users.push_back(std::make_shared<messaging::Member>("+8615976951459"));

    QSet<QString> original_set;
    original_set.insert("+8613811964787");
    original_set.insert("+8615811217395");

    auto to_remove_ids_set = messaging::ids_to_remove(original_set, users);
    EXPECT_EQ(to_remove_ids_set.count(), 1);
    EXPECT_EQ(to_remove_ids_set.at(0), "+8615811217395");
}

TEST(MembersTest, verify_ids_to_remove_empty_original_set)
{
    messaging::Members users;
    users.push_back(std::make_shared<messaging::Member>("+8615014902027"));
    users.push_back(std::make_shared<messaging::Member>("+8613811964787"));
    users.push_back(std::make_shared<messaging::Member>("+8615976951459"));

    QSet<QString> original_set;

    auto to_remove_ids_set = messaging::ids_to_remove(original_set, users);
    EXPECT_EQ(to_remove_ids_set.count(), 0);
}

TEST(MembersTest, verify_ids_to_remove_empty_user_list)
{
    messaging::Members users;

    QSet<QString> original_set;
    original_set.insert("+8613811964787");
    original_set.insert("+8615811217395");

    auto to_remove_ids_set = messaging::ids_to_remove(original_set, users);

    EXPECT_EQ(to_remove_ids_set.count(), 2);
    EXPECT_TRUE(to_remove_ids_set.contains("+8613811964787"));
    EXPECT_TRUE(to_remove_ids_set.contains("+8615811217395"));
}

}
